/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitContextReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u00038\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\b\u001a\u0004\u0018\u00010\u00078\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ContextReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/AbstractReceiverValue;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitContextReceiver;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "declarationDescriptor", "Lorg/jetbrains/kotlin/types/KotlinType;", "receiverType", "Lorg/jetbrains/kotlin/name/Name;", "customLabelName", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "original", "<init>", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "newType", "replaceType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getDeclarationDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/name/Name;", "getCustomLabelName", "()Lorg/jetbrains/kotlin/name/Name;"})
public final class ContextReceiver
extends AbstractReceiverValue
implements ImplicitContextReceiver {
    @NotNull
    private final CallableDescriptor declarationDescriptor;
    @Nullable
    private final Name customLabelName;

    public ContextReceiver(@NotNull CallableDescriptor declarationDescriptor, @NotNull KotlinType receiverType, @Nullable Name customLabelName, @Nullable ReceiverValue original) {
        Intrinsics.checkNotNullParameter(declarationDescriptor, "declarationDescriptor");
        Intrinsics.checkNotNullParameter(receiverType, "receiverType");
        super(receiverType, original);
        this.declarationDescriptor = declarationDescriptor;
        this.customLabelName = customLabelName;
    }

    @Override
    @NotNull
    public CallableDescriptor getDeclarationDescriptor() {
        return this.declarationDescriptor;
    }

    @Override
    @Nullable
    public Name getCustomLabelName() {
        return this.customLabelName;
    }

    @Override
    @NotNull
    public ReceiverValue replaceType(@NotNull KotlinType newType) {
        Intrinsics.checkNotNullParameter(newType, "newType");
        return new ContextReceiver(this.getDeclarationDescriptor(), newType, this.getCustomLabelName(), this.getOriginal());
    }

    @NotNull
    public String toString() {
        return "Cxt { " + this.getDeclarationDescriptor() + " }";
    }
}

