/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitContextReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\b\u001a\u0004\u0018\u00010\u00078\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00198WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ContextClassReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/AbstractReceiverValue;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitContextReceiver;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/types/KotlinType;", "receiverType", "Lorg/jetbrains/kotlin/name/Name;", "customLabelName", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "original", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "newType", "replaceType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/name/Name;", "getCustomLabelName", "()Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getDeclarationDescriptor", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "declarationDescriptor"})
public final class ContextClassReceiver
extends AbstractReceiverValue
implements ImplicitContextReceiver {
    @NotNull
    private final ClassDescriptor classDescriptor;
    @Nullable
    private final Name customLabelName;

    public ContextClassReceiver(@NotNull ClassDescriptor classDescriptor, @NotNull KotlinType receiverType, @Nullable Name customLabelName, @Nullable ReceiverValue original) {
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Intrinsics.checkNotNullParameter(receiverType, "receiverType");
        super(receiverType, original);
        this.classDescriptor = classDescriptor;
        this.customLabelName = customLabelName;
    }

    @NotNull
    public final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Override
    @Nullable
    public Name getCustomLabelName() {
        return this.customLabelName;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getDeclarationDescriptor() {
        return this.classDescriptor;
    }

    @Override
    @NotNull
    public ReceiverValue replaceType(@NotNull KotlinType newType) {
        Intrinsics.checkNotNullParameter(newType, "newType");
        return new ContextClassReceiver(this.classDescriptor, newType, this.getCustomLabelName(), this.getOriginal());
    }

    @NotNull
    public String toString() {
        return this.getType() + ": Ctx { " + this.classDescriptor + " }";
    }
}

