/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.sam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.resolve.sam.SamConstructorDescriptorImpl;
import org.jetbrains.kotlin.resolve.sam.SamConstructorTypeParameters;
import org.jetbrains.kotlin.resolve.sam.SamConversionOracle;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolver;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.sam.SamTypeAliasConstructorDescriptorImpl;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public final class SamConstructorUtilsKt {
    public static final SamConstructorDescriptor createSamConstructorFunction(DeclarationDescriptor declarationDescriptor, ClassDescriptor classDescriptor, SamConversionResolver samConversionResolver, SamConversionOracle samConversionOracle) {
        boolean bl;
        Intrinsics.checkNotNullParameter(declarationDescriptor, "owner");
        Intrinsics.checkNotNullParameter(classDescriptor, "samInterface");
        Intrinsics.checkNotNullParameter(samConversionResolver, "samResolver");
        Intrinsics.checkNotNullParameter(samConversionOracle, "samConversionOracle");
        boolean bl2 = bl = SamConversionResolverImplKt.getSingleAbstractMethodOrNull(classDescriptor) != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            ClassDescriptor classDescriptor2 = classDescriptor;
            throw new AssertionError(classDescriptor2);
        }
        SamConstructorDescriptorImpl samConstructorDescriptorImpl = new SamConstructorDescriptorImpl(declarationDescriptor, classDescriptor);
        List<TypeParameterDescriptor> list = classDescriptor.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        List<TypeParameterDescriptor> list2 = list;
        SimpleType simpleType2 = classDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
        SimpleType simpleType3 = simpleType2;
        SamConstructorUtilsKt.initializeSamConstructorDescriptor(classDescriptor, samConstructorDescriptorImpl, list2, simpleType3, samConversionResolver, samConversionOracle);
        return samConstructorDescriptorImpl;
    }

    public static final SamConstructorDescriptor createTypeAliasSamConstructorFunction(TypeAliasDescriptor typeAliasDescriptor, SamConstructorDescriptor samConstructorDescriptor, SamConversionResolver samConversionResolver, SamConversionOracle samConversionOracle) {
        Intrinsics.checkNotNullParameter(typeAliasDescriptor, "typeAliasDescriptor");
        Intrinsics.checkNotNullParameter(samConstructorDescriptor, "underlyingSamConstructor");
        Intrinsics.checkNotNullParameter(samConversionResolver, "samResolver");
        Intrinsics.checkNotNullParameter(samConversionOracle, "samConversionOracle");
        SamTypeAliasConstructorDescriptorImpl samTypeAliasConstructorDescriptorImpl = new SamTypeAliasConstructorDescriptorImpl(typeAliasDescriptor, samConstructorDescriptor);
        ClassDescriptor classDescriptor = (ClassDescriptor)samConstructorDescriptor.getBaseDescriptorForSynthetic();
        List<TypeParameterDescriptor> list = typeAliasDescriptor.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        List<TypeParameterDescriptor> list2 = list;
        SimpleType simpleType2 = typeAliasDescriptor.getExpandedType();
        SamConstructorUtilsKt.initializeSamConstructorDescriptor(classDescriptor, samTypeAliasConstructorDescriptorImpl, list2, simpleType2, samConversionResolver, samConversionOracle);
        return samTypeAliasConstructorDescriptorImpl;
    }

    private static final void initializeSamConstructorDescriptor(ClassDescriptor classDescriptor, SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl, List<? extends TypeParameterDescriptor> list, KotlinType kotlinType, SamConversionResolver samConversionResolver, SamConversionOracle samConversionOracle) {
        SamConstructorTypeParameters samConstructorTypeParameters = SamConstructorUtilsKt.recreateAndInitializeTypeParameters(list, simpleFunctionDescriptorImpl);
        KotlinType kotlinType2 = SamConversionResolverImplKt.getFunctionTypeForSamType(kotlinType, samConversionResolver, samConversionOracle);
        if (kotlinType2 == null) {
            throw new IllegalStateException(("couldn't get function type for SAM type " + kotlinType).toString());
        }
        KotlinType kotlinType3 = kotlinType2;
        KotlinType kotlinType4 = samConstructorTypeParameters.getSubstitutor().substitute(kotlinType3, Variance.IN_VARIANCE);
        if (kotlinType4 == null) {
            throw new IllegalStateException(("couldn't substitute type: " + kotlinType3 + ", substitutor = " + samConstructorTypeParameters.getSubstitutor()).toString());
        }
        KotlinType kotlinType5 = kotlinType4;
        CallableDescriptor callableDescriptor = simpleFunctionDescriptorImpl;
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        Name name = Name.identifier("function");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkNotNullExpressionValue(sourceElement, "NO_SOURCE");
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(callableDescriptor, null, 0, annotations2, name, kotlinType5, false, false, false, null, sourceElement);
        KotlinType kotlinType6 = samConstructorTypeParameters.getSubstitutor().substitute(kotlinType, Variance.OUT_VARIANCE);
        if (kotlinType6 == null) {
            throw new IllegalStateException(("couldn't substitute type: " + kotlinType + ", substitutor = " + samConstructorTypeParameters.getSubstitutor()).toString());
        }
        KotlinType kotlinType7 = kotlinType6;
        simpleFunctionDescriptorImpl.initialize((ReceiverParameterDescriptor)null, (ReceiverParameterDescriptor)null, CollectionsKt.emptyList(), samConstructorTypeParameters.getDescriptors(), CollectionsKt.listOf(valueParameterDescriptorImpl), kotlinType7, Modality.FINAL, classDescriptor.getVisibility());
    }

    public static final SamConstructorTypeParameters recreateAndInitializeTypeParameters(List<? extends TypeParameterDescriptor> list, DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter(list, "originalParameters");
        Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> map2 = SamConstructorUtilsKt.recreateTypeParametersAndReturnMapping(list, declarationDescriptor);
        TypeSubstitutor typeSubstitutor2 = SamConstructorUtilsKt.createSubstitutorForTypeParameters(map2);
        for (Map.Entry<TypeParameterDescriptor, TypeParameterDescriptorImpl> entry : map2.entrySet()) {
            TypeParameterDescriptor typeParameterDescriptor = entry.getKey();
            TypeParameterDescriptorImpl typeParameterDescriptorImpl = entry.getValue();
            for (KotlinType kotlinType : typeParameterDescriptor.getUpperBounds()) {
                KotlinType kotlinType2;
                if (typeSubstitutor2.substitute(kotlinType, Variance.INVARIANT) == null) {
                    throw new IllegalStateException(("couldn't substitute type: " + kotlinType + ", substitutor = " + typeSubstitutor2).toString());
                }
                typeParameterDescriptorImpl.addUpperBound(kotlinType2);
            }
            typeParameterDescriptorImpl.setInitialized();
        }
        return new SamConstructorTypeParameters(CollectionsKt.toList((Iterable)map2.values()), typeSubstitutor2);
    }

    public static final Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> recreateTypeParametersAndReturnMapping(List<? extends TypeParameterDescriptor> list, DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter(list, "originalParameters");
        Iterable iterable = list;
        boolean bl = false;
        LinkedHashMap linkedHashMap = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault(iterable, 10)), 16));
        Iterable iterable2 = iterable;
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)t2;
            Object t3 = t2;
            Map map2 = linkedHashMap;
            boolean bl3 = false;
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
            if (declarationDescriptor2 == null) {
                DeclarationDescriptor declarationDescriptor3 = typeParameterDescriptor.getContainingDeclaration();
                declarationDescriptor2 = declarationDescriptor3;
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor3, "getContainingDeclaration(...)");
            }
            TypeParameterDescriptorImpl typeParameterDescriptorImpl = TypeParameterDescriptorImpl.createForFurtherModification(declarationDescriptor2, typeParameterDescriptor.getAnnotations(), typeParameterDescriptor.isReified(), typeParameterDescriptor.getVariance(), typeParameterDescriptor.getName(), typeParameterDescriptor.getIndex(), SourceElement.NO_SOURCE, typeParameterDescriptor.getStorageManager());
            map2.put(t3, typeParameterDescriptorImpl);
        }
        return linkedHashMap;
    }

    public static final TypeSubstitutor createSubstitutorForTypeParameters(Map<TypeParameterDescriptor, ? extends TypeParameterDescriptorImpl> map2) {
        Intrinsics.checkNotNullParameter(map2, "originalToAltTypeParameters");
        Map<TypeParameterDescriptor, ? extends TypeParameterDescriptorImpl> map3 = map2;
        boolean bl = false;
        Map<TypeParameterDescriptor, ? extends TypeParameterDescriptorImpl> map4 = map3;
        Collection collection = new ArrayList(map3.size());
        boolean bl2 = false;
        Iterator<Map.Entry<TypeParameterDescriptor, ? extends TypeParameterDescriptorImpl>> iterator2 = map4.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<TypeParameterDescriptor, ? extends TypeParameterDescriptorImpl> entry;
            Map.Entry<TypeParameterDescriptor, ? extends TypeParameterDescriptorImpl> entry2 = entry = iterator2.next();
            Collection collection2 = collection;
            boolean bl3 = false;
            TypeParameterDescriptor typeParameterDescriptor = entry2.getKey();
            TypeParameterDescriptorImpl typeParameterDescriptorImpl = entry2.getValue();
            TypeConstructor typeConstructor2 = typeParameterDescriptor.getTypeConstructor();
            SimpleType simpleType2 = typeParameterDescriptorImpl.getDefaultType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
            collection2.add(TuplesKt.to(typeConstructor2, TypeUtilsKt.asTypeProjection(simpleType2)));
        }
        Map<TypeConstructor, TypeProjection> map5 = MapsKt.toMap((List)collection);
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(map5);
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(...)");
        return typeSubstitutor2;
    }
}

