/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeObjCRefinementOverridesChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013*\u00020\u000fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeObjCRefinementChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "hidesFromObjCFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getHidesFromObjCFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "refinesInSwiftFqName", "getRefinesInSwiftFqName", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "findRefinedAnnotations", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "frontend.native"})
public final class NativeObjCRefinementChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeObjCRefinementChecker INSTANCE = new NativeObjCRefinementChecker();
    @NotNull
    private static final FqName hidesFromObjCFqName = new FqName("kotlin.native.HidesFromObjC");
    @NotNull
    private static final FqName refinesInSwiftFqName = new FqName("kotlin.native.RefinesInSwift");

    private NativeObjCRefinementChecker() {
    }

    @NotNull
    public final FqName getHidesFromObjCFqName() {
        return hidesFromObjCFqName;
    }

    @NotNull
    public final FqName getRefinesInSwiftFqName() {
        return refinesInSwiftFqName;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(descriptor2 instanceof CallableMemberDescriptor)) {
            return;
        }
        if (!(descriptor2 instanceof FunctionDescriptor) && !(descriptor2 instanceof PropertyDescriptor)) {
            return;
        }
        Pair<List<AnnotationDescriptor>, List<AnnotationDescriptor>> pair = this.findRefinedAnnotations(descriptor2);
        List<AnnotationDescriptor> objCAnnotations = pair.component1();
        List<AnnotationDescriptor> swiftAnnotations = pair.component2();
        if (!((Collection)objCAnnotations).isEmpty() && !((Collection)swiftAnnotations).isEmpty()) {
            Iterable $this$forEach$iv = swiftAnnotations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                boolean bl = false;
                KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(it);
                KtElement reportLocation = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
                context.getTrace().report(ErrorsNative.REDUNDANT_SWIFT_REFINEMENT.on((KtElement)((PsiElement)reportLocation)));
            }
        }
        NativeObjCRefinementOverridesChecker.INSTANCE.check(declaration, (CallableMemberDescriptor)descriptor2, context, objCAnnotations, swiftAnnotations);
    }

    private final Pair<List<AnnotationDescriptor>, List<AnnotationDescriptor>> findRefinedAnnotations(DeclarationDescriptor $this$findRefinedAnnotations) {
        List objCAnnotations = new ArrayList();
        List swiftAnnotations = new ArrayList();
        block0: for (AnnotationDescriptor annotation : $this$findRefinedAnnotations.getAnnotations()) {
            Object object = DescriptorUtilsKt.getAnnotationClass(annotation);
            if (object == null || (object = object.getAnnotations()) == null) continue;
            Object annotations2 = object;
            Iterator iterator2 = annotations2.iterator();
            while (iterator2.hasNext()) {
                AnnotationDescriptor metaAnnotation = (AnnotationDescriptor)iterator2.next();
                FqName fqName2 = metaAnnotation.getFqName();
                if (Intrinsics.areEqual(fqName2, hidesFromObjCFqName)) {
                    objCAnnotations.add(annotation);
                    continue block0;
                }
                if (!Intrinsics.areEqual(fqName2, refinesInSwiftFqName)) continue;
                swiftAnnotations.add(annotation);
                continue block0;
            }
        }
        return TuplesKt.to(objCAnnotations, swiftAnnotations);
    }
}

