/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.modules;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationImpl;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryClassSignatureParser;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.ClassifierResolutionContext;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementPsiSource;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementSourceFactory;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u00172\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "", "moduleName", "", "requires", "", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Requires;", "exports", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Exports;", "annotations", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getModuleName", "()Ljava/lang/String;", "getRequires", "()Ljava/util/List;", "getExports", "getAnnotations", "toString", "Requires", "Exports", "FileReadingException", "Companion", "frontend.java"})
public final class JavaModuleInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String moduleName;
    @NotNull
    private final List<Requires> requires;
    @NotNull
    private final List<Exports> exports;
    @NotNull
    private final List<JavaAnnotation> annotations;

    public JavaModuleInfo(@NotNull String moduleName, @NotNull List<Requires> requires, @NotNull List<Exports> exports, @NotNull List<? extends JavaAnnotation> annotations2) {
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        Intrinsics.checkNotNullParameter(requires, "requires");
        Intrinsics.checkNotNullParameter(exports, "exports");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        this.moduleName = moduleName;
        this.requires = requires;
        this.exports = exports;
        this.annotations = annotations2;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final List<Requires> getRequires() {
        return this.requires;
    }

    @NotNull
    public final List<Exports> getExports() {
        return this.exports;
    }

    @NotNull
    public final List<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public String toString() {
        return "Module " + this.moduleName + " (" + this.requires.size() + " requires, " + this.exports.size() + " exports)";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "psiJavaModule", "Lcom/intellij/psi/PsiJavaModule;", "read", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "javaFileManager", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "frontend.java"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final JavaModuleInfo create(@NotNull PsiJavaModule psiJavaModule) {
            Collection<Object> collection;
            List<Object> list;
            void $this$convert$iv;
            boolean bl;
            Object it$iv$iv;
            PsiStatement statement;
            boolean bl2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Object[] $this$mapNotNullTo$iv$iv;
            Object[] $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter(psiJavaModule, "psiJavaModule");
            String string = psiJavaModule.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            Iterable<PsiRequiresStatement> iterable = psiJavaModule.getRequires();
            Intrinsics.checkNotNullExpressionValue(iterable, "getRequires(...)");
            Iterable<PsiRequiresStatement> iterable2 = iterable;
            String string2 = string;
            boolean $i$f$mapNotNull = false;
            void var4_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Object[] $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Requires requires;
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                bl2 = false;
                statement = (PsiRequiresStatement)element$iv$iv;
                boolean bl3 = false;
                if (statement.getModuleName() != null) {
                    String moduleName;
                    boolean bl4 = false;
                    requires = new Requires(moduleName, statement.hasModifierProperty("transitive"));
                } else {
                    requires = null;
                }
                if (requires == null) continue;
                it$iv$iv = requires;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Object[] objectArray = psiJavaModule.getExports();
            Intrinsics.checkNotNullExpressionValue(objectArray, "getExports(...)");
            $this$mapNotNull$iv = objectArray;
            List list2 = (List)destination$iv$iv;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Exports exports;
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                bl2 = false;
                statement = (PsiPackageAccessibilityStatement)element$iv$iv;
                boolean bl5 = false;
                if (statement.getPackageName() != null) {
                    String packageName;
                    boolean bl6 = false;
                    FqName fqName2 = new FqName(packageName);
                    List<String> list3 = statement.getModuleNames();
                    Intrinsics.checkNotNullExpressionValue(list3, "getModuleNames(...)");
                    exports = new Exports(fqName2, list3);
                } else {
                    exports = null;
                }
                if (exports == null) continue;
                it$iv$iv = exports;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list4 = (List)destination$iv$iv;
            PsiAnnotation[] psiAnnotationArray = psiJavaModule.getAnnotations();
            Intrinsics.checkNotNullExpressionValue(psiAnnotationArray, "getAnnotations(...)");
            $this$mapNotNull$iv = psiAnnotationArray;
            boolean $i$f$convert = false;
            switch (((void)$this$convert$iv).length) {
                case 0: {
                    list = kotlin.collections.CollectionsKt.emptyList();
                    break;
                }
                case 1: {
                    PsiAnnotation it = (PsiAnnotation)ArraysKt.first($this$convert$iv);
                    boolean bl7 = false;
                    Project project = psiJavaModule.getProject();
                    Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
                    JavaElementSourceFactory javaElementSourceFactory = JavaElementSourceFactory.Companion.getInstance(project);
                    Intrinsics.checkNotNull(it);
                    list = kotlin.collections.CollectionsKt.listOf(new JavaAnnotationImpl((JavaElementPsiSource<PsiAnnotation>)javaElementSourceFactory.createPsiSource((PsiElement)it)));
                    break;
                }
                default: {
                    void $this$mapTo$iv$iv$iv;
                    void $this$map$iv$iv = $this$convert$iv;
                    boolean $i$f$map = false;
                    void $i$f$forEach2 = $this$map$iv$iv;
                    Collection destination$iv$iv$iv = new ArrayList(((void)$this$map$iv$iv).length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                        void it;
                        PsiAnnotation psiAnnotation = (PsiAnnotation)item$iv$iv$iv;
                        collection = destination$iv$iv$iv;
                        boolean bl8 = false;
                        Project project = psiJavaModule.getProject();
                        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
                        JavaElementSourceFactory javaElementSourceFactory = JavaElementSourceFactory.Companion.getInstance(project);
                        Intrinsics.checkNotNull(it);
                        collection.add(new JavaAnnotationImpl((JavaElementPsiSource<PsiAnnotation>)javaElementSourceFactory.createPsiSource((PsiElement)it)));
                    }
                    list = (List)destination$iv$iv$iv;
                }
            }
            collection = list;
            List list5 = collection;
            List list6 = list4;
            List list7 = list2;
            String string3 = string2;
            return new JavaModuleInfo(string3, list7, list6, list5);
        }

        @Nullable
        public final JavaModuleInfo read(@NotNull VirtualFile file, @NotNull KotlinCliJavaFileManager javaFileManager, @NotNull GlobalSearchScope searchScope) {
            JavaModuleInfo javaModuleInfo;
            byte[] byArray;
            Intrinsics.checkNotNullParameter(file, "file");
            Intrinsics.checkNotNullParameter(javaFileManager, "javaFileManager");
            Intrinsics.checkNotNullParameter(searchScope, "searchScope");
            try {
                byArray = file.contentsToByteArray();
            }
            catch (IOException e2) {
                return null;
            }
            byte[] byArray2 = byArray;
            Intrinsics.checkNotNull(byArray2);
            byte[] contents = byArray2;
            Ref.ObjectRef<String> moduleName = new Ref.ObjectRef<String>();
            ArrayList<Requires> requires = new ArrayList<Requires>();
            ArrayList<Exports> exports = new ArrayList<Exports>();
            ArrayList<JavaAnnotation> annotations2 = new ArrayList<JavaAnnotation>();
            try {
                new ClassReader(contents).accept(new ClassVisitor(moduleName, requires, exports, annotations2, javaFileManager, searchScope){
                    final /* synthetic */ Ref.ObjectRef<String> $moduleName;
                    final /* synthetic */ ArrayList<Requires> $requires;
                    final /* synthetic */ ArrayList<Exports> $exports;
                    final /* synthetic */ ArrayList<JavaAnnotation> $annotations;
                    final /* synthetic */ KotlinCliJavaFileManager $javaFileManager;
                    final /* synthetic */ GlobalSearchScope $searchScope;
                    {
                        this.$moduleName = $moduleName;
                        this.$requires = $requires;
                        this.$exports = $exports;
                        this.$annotations = $annotations;
                        this.$javaFileManager = $javaFileManager;
                        this.$searchScope = $searchScope;
                        super(589824);
                    }

                    public ModuleVisitor visitModule(String name, int access, String version) {
                        Intrinsics.checkNotNullParameter(name, "name");
                        this.$moduleName.element = name;
                        return new ModuleVisitor(this.$requires, this.$exports){
                            final /* synthetic */ ArrayList<Requires> $requires;
                            final /* synthetic */ ArrayList<Exports> $exports;
                            {
                                this.$requires = $requires;
                                this.$exports = $exports;
                                super(589824);
                            }

                            public void visitRequire(String module2, int access, String version) {
                                Intrinsics.checkNotNullParameter(module2, "module");
                                this.$requires.add(new Requires(module2, (access & 0x20) != 0));
                            }

                            public void visitExport(String packageFqName, int access, String[] modules) {
                                Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
                                FqName fqName2 = new FqName(StringsKt.replace$default(packageFqName, '/', '.', false, 4, null));
                                List<String> list = modules != null ? ArraysKt.toList(modules) : null;
                                if (list == null) {
                                    list = kotlin.collections.CollectionsKt.emptyList();
                                }
                                this.$exports.add(new Exports(fqName2, list));
                            }
                        };
                    }

                    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
                        if (descriptor2 == null) {
                            return null;
                        }
                        Pair<JavaAnnotation, AnnotationVisitor> pair = BinaryJavaAnnotation.Companion.createAnnotationAndVisitor(descriptor2, new ClassifierResolutionContext(arg_0 -> read.1.visitAnnotation$lambda$0(this.$javaFileManager, this.$searchScope, arg_0)), new BinaryClassSignatureParser(), true);
                        JavaAnnotation annotation = pair.component1();
                        AnnotationVisitor visitor2 = pair.component2();
                        this.$annotations.add(annotation);
                        return visitor2;
                    }

                    private static final JavaClass visitAnnotation$lambda$0(KotlinCliJavaFileManager $javaFileManager, GlobalSearchScope $searchScope, ClassId it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return $javaFileManager.findClass(new JavaClassFinder.Request(it, null, null, 6, null), $searchScope);
                    }
                }, 7);
            }
            catch (Exception e3) {
                PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded(e3);
                throw new FileReadingException("Could not load module definition from: " + file.getCanonicalPath() + ". The file might be broken by incorrect post-processing via bytecode tools. Please remove this file from the classpath.", e3);
            }
            String string = (String)moduleName.element;
            if (string != null) {
                String it = string;
                boolean bl = false;
                javaModuleInfo = new JavaModuleInfo(it, CollectionsKt.compact(requires), CollectionsKt.compact(exports), (List<? extends JavaAnnotation>)annotations2);
            } else {
                javaModuleInfo = null;
            }
            return javaModuleInfo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Exports;", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "toModules", "", "", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/util/List;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getToModules", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "frontend.java"})
    public static final class Exports {
        @NotNull
        private final FqName packageFqName;
        @NotNull
        private final List<String> toModules;

        public Exports(@NotNull FqName packageFqName, @NotNull List<String> toModules) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            Intrinsics.checkNotNullParameter(toModules, "toModules");
            this.packageFqName = packageFqName;
            this.toModules = toModules;
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public final List<String> getToModules() {
            return this.toModules;
        }

        @NotNull
        public final FqName component1() {
            return this.packageFqName;
        }

        @NotNull
        public final List<String> component2() {
            return this.toModules;
        }

        @NotNull
        public final Exports copy(@NotNull FqName packageFqName, @NotNull List<String> toModules) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            Intrinsics.checkNotNullParameter(toModules, "toModules");
            return new Exports(packageFqName, toModules);
        }

        public static /* synthetic */ Exports copy$default(Exports exports, FqName fqName2, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                fqName2 = exports.packageFqName;
            }
            if ((n2 & 2) != 0) {
                list = exports.toModules;
            }
            return exports.copy(fqName2, list);
        }

        @NotNull
        public String toString() {
            return "Exports(packageFqName=" + this.packageFqName + ", toModules=" + this.toModules + ')';
        }

        public int hashCode() {
            int result2 = this.packageFqName.hashCode();
            result2 = result2 * 31 + ((Object)this.toModules).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Exports)) {
                return false;
            }
            Exports exports = (Exports)other;
            if (!Intrinsics.areEqual(this.packageFqName, exports.packageFqName)) {
                return false;
            }
            return Intrinsics.areEqual(this.toModules, exports.toModules);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$FileReadingException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "message", "", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "getMessage", "()Ljava/lang/String;", "getCause", "()Ljava/lang/Throwable;", "frontend.java"})
    public static final class FileReadingException
    extends IllegalStateException {
        @NotNull
        private final String message;
        @NotNull
        private final Throwable cause;

        public FileReadingException(@NotNull String message, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter(message, "message");
            Intrinsics.checkNotNullParameter(cause, "cause");
            super(message, cause);
            this.message = message;
            this.cause = cause;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public Throwable getCause() {
            return this.cause;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo$Requires;", "", "moduleName", "", "isTransitive", "", "<init>", "(Ljava/lang/String;Z)V", "getModuleName", "()Ljava/lang/String;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "frontend.java"})
    public static final class Requires {
        @NotNull
        private final String moduleName;
        private final boolean isTransitive;

        public Requires(@NotNull String moduleName, boolean isTransitive) {
            Intrinsics.checkNotNullParameter(moduleName, "moduleName");
            this.moduleName = moduleName;
            this.isTransitive = isTransitive;
        }

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        public final boolean isTransitive() {
            return this.isTransitive;
        }

        @NotNull
        public final String component1() {
            return this.moduleName;
        }

        public final boolean component2() {
            return this.isTransitive;
        }

        @NotNull
        public final Requires copy(@NotNull String moduleName, boolean isTransitive) {
            Intrinsics.checkNotNullParameter(moduleName, "moduleName");
            return new Requires(moduleName, isTransitive);
        }

        public static /* synthetic */ Requires copy$default(Requires requires, String string, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = requires.moduleName;
            }
            if ((n2 & 2) != 0) {
                bl = requires.isTransitive;
            }
            return requires.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "Requires(moduleName=" + this.moduleName + ", isTransitive=" + this.isTransitive + ')';
        }

        public int hashCode() {
            int result2 = this.moduleName.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isTransitive);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Requires)) {
                return false;
            }
            Requires requires = (Requires)other;
            if (!Intrinsics.areEqual(this.moduleName, requires.moduleName)) {
                return false;
            }
            return this.isTransitive == requires.isTransitive;
        }
    }
}

