/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.tree.IElementType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u001a \u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a \u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0007\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002\u001a\u000e\u0010\u0012\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\u0005\u001a\u000e\u0010\u0012\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\u0013\u001a\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0002\u001a \u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0007\u001a0\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u001a0\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0007\u001a@\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\"\u0019\u0010\u0000\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"DIVISION_OPERATION_NAMES", "", "", "Lkotlin/jvm/internal/EnhancedNullability;", "createCompileTimeConstantForEquals", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "result", "", "operationReference", "Lorg/jetbrains/kotlin/psi/KtExpression;", "createCompileTimeConstantForCompareTo", "isIntegerType", "", "value", "getReceiverExpressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isStandaloneOnlyConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "isZero", "typeStrToCompileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "str", "evaluateUnary", "name", "typeStr", "evaluateUnaryAndCheck", "type", "reportIntegerOverflow", "Lkotlin/Function0;", "", "evaluateBinary", "receiverTypeStr", "receiverValue", "parameterTypeStr", "parameterValue", "evaluateBinaryAndCheck", "receiverType", "parameterType", "frontend"})
public final class ConstantExpressionEvaluatorKt {
    @NotNull
    private static final Set<String> DIVISION_OPERATION_NAMES;

    private static final ConstantValue<?> createCompileTimeConstantForEquals(Object result2, KtExpression operationReference) {
        if (result2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = operationReference instanceof KtSimpleNameExpression;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-ConstantExpressionEvaluatorKt$createCompileTimeConstantForEquals$22 = false;
                String $i$a$-assert-ConstantExpressionEvaluatorKt$createCompileTimeConstantForEquals$22 = "This method should be called only for equals operations";
                throw new AssertionError((Object)$i$a$-assert-ConstantExpressionEvaluatorKt$createCompileTimeConstantForEquals$22);
            }
            Intrinsics.checkNotNull(operationReference, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
            IElementType operationToken = ((KtSimpleNameExpression)operationReference).getReferencedNameElementType();
            if (Intrinsics.areEqual(operationToken, KtTokens.EQEQ)) {
                bl = (Boolean)result2;
            } else if (Intrinsics.areEqual(operationToken, KtTokens.EXCLEQ)) {
                bl = !((Boolean)result2).booleanValue();
            } else if (Intrinsics.areEqual(operationToken, KtTokens.IDENTIFIER)) {
                boolean bl3 = Intrinsics.areEqual(((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), OperatorNameConventions.EQUALS);
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl4 = false;
                    String string = "This method should be called only for equals operations";
                    throw new AssertionError((Object)string);
                }
                bl = (Boolean)result2;
            } else {
                throw new IllegalStateException("Unknown equals operation token: " + operationToken + ' ' + ((KtSimpleNameExpression)operationReference).getText());
            }
            boolean value2 = bl;
            return new BooleanValue(value2);
        }
        return null;
    }

    private static final ConstantValue<?> createCompileTimeConstantForCompareTo(Object result2, KtExpression operationReference) {
        if (result2 instanceof Integer) {
            ConstantValue constantValue;
            boolean bl = operationReference instanceof KtSimpleNameExpression;
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "This method should be called only for compareTo operations";
                throw new AssertionError((Object)string);
            }
            Intrinsics.checkNotNull(operationReference, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
            IElementType operationToken = ((KtSimpleNameExpression)operationReference).getReferencedNameElementType();
            if (Intrinsics.areEqual(operationToken, KtTokens.LT)) {
                constantValue = new BooleanValue(((Number)result2).intValue() < 0);
            } else if (Intrinsics.areEqual(operationToken, KtTokens.LTEQ)) {
                constantValue = new BooleanValue(((Number)result2).intValue() <= 0);
            } else if (Intrinsics.areEqual(operationToken, KtTokens.GT)) {
                constantValue = new BooleanValue(((Number)result2).intValue() > 0);
            } else if (Intrinsics.areEqual(operationToken, KtTokens.GTEQ)) {
                constantValue = new BooleanValue(((Number)result2).intValue() >= 0);
            } else {
                if (Intrinsics.areEqual(operationToken, KtTokens.IDENTIFIER)) {
                    boolean bl3 = Intrinsics.areEqual(((KtSimpleNameExpression)operationReference).getReferencedNameAsName(), OperatorNameConventions.COMPARE_TO);
                    if (_Assertions.ENABLED && !bl3) {
                        boolean bl4 = false;
                        String string = "This method should be called only for compareTo operations";
                        throw new AssertionError((Object)string);
                    }
                    return new IntValue(((Number)result2).intValue());
                }
                throw new IllegalStateException("Unknown compareTo operation token: " + operationToken);
            }
            return constantValue;
        }
        return null;
    }

    public static final boolean isIntegerType(@Nullable Object value2) {
        return value2 instanceof Byte || value2 instanceof Short || value2 instanceof Integer || value2 instanceof Long;
    }

    private static final KotlinType getReceiverExpressionType(ResolvedCall<?> resolvedCall2) {
        KotlinType kotlinType;
        switch (WhenMappings.$EnumSwitchMapping$0[resolvedCall2.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
                Intrinsics.checkNotNull(receiverValue);
                kotlinType = receiverValue.getType();
                break;
            }
            case 2: {
                ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
                Intrinsics.checkNotNull(receiverValue);
                kotlinType = receiverValue.getType();
                break;
            }
            case 3: {
                kotlinType = null;
                break;
            }
            case 4: {
                kotlinType = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return kotlinType;
    }

    public static final boolean isStandaloneOnlyConstant(@NotNull ConstantValue<?> $this$isStandaloneOnlyConstant) {
        Intrinsics.checkNotNullParameter($this$isStandaloneOnlyConstant, "<this>");
        return $this$isStandaloneOnlyConstant instanceof KClassValue || $this$isStandaloneOnlyConstant instanceof EnumValue || $this$isStandaloneOnlyConstant instanceof AnnotationValue || $this$isStandaloneOnlyConstant instanceof ArrayValue;
    }

    public static final boolean isStandaloneOnlyConstant(@NotNull CompileTimeConstant<?> $this$isStandaloneOnlyConstant) {
        Intrinsics.checkNotNullParameter($this$isStandaloneOnlyConstant, "<this>");
        if (!($this$isStandaloneOnlyConstant instanceof TypedCompileTimeConstant)) {
            return false;
        }
        return ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(((TypedCompileTimeConstant)$this$isStandaloneOnlyConstant).getConstantValue());
    }

    private static final boolean isZero(Object value2) {
        boolean bl;
        if (ConstantExpressionEvaluatorKt.isIntegerType(value2)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Number");
            bl = ((Number)value2).longValue() == 0L;
        } else {
            bl = value2 instanceof Float || value2 instanceof Double ? ((Number)value2).doubleValue() == 0.0 : false;
        }
        return bl;
    }

    private static final CompileTimeType typeStrToCompileTimeType(String str) {
        CompileTimeType compileTimeType;
        switch (str) {
            case "Byte": {
                compileTimeType = CompileTimeType.BYTE;
                break;
            }
            case "Short": {
                compileTimeType = CompileTimeType.SHORT;
                break;
            }
            case "Int": {
                compileTimeType = CompileTimeType.INT;
                break;
            }
            case "Long": {
                compileTimeType = CompileTimeType.LONG;
                break;
            }
            case "Double": {
                compileTimeType = CompileTimeType.DOUBLE;
                break;
            }
            case "Float": {
                compileTimeType = CompileTimeType.FLOAT;
                break;
            }
            case "Char": {
                compileTimeType = CompileTimeType.CHAR;
                break;
            }
            case "Boolean": {
                compileTimeType = CompileTimeType.BOOLEAN;
                break;
            }
            case "String": {
                compileTimeType = CompileTimeType.STRING;
                break;
            }
            case "Any": {
                compileTimeType = CompileTimeType.ANY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + str);
            }
        }
        return compileTimeType;
    }

    @Nullable
    public static final Object evaluateUnary(@NotNull String name, @NotNull String typeStr, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(typeStr, "typeStr");
        Intrinsics.checkNotNullParameter(value2, "value");
        return OperationsMapGeneratedKt.evalUnaryOp(name, ConstantExpressionEvaluatorKt.typeStrToCompileTimeType(typeStr), value2);
    }

    private static final Object evaluateUnaryAndCheck(String name, CompileTimeType type2, Object value2, Function0<Unit> reportIntegerOverflow) {
        Object object;
        Object result2 = object = OperationsMapGeneratedKt.evalUnaryOp(name, type2, value2);
        boolean bl = false;
        if (ConstantExpressionEvaluatorKt.isIntegerType(value2) && (Intrinsics.areEqual(name, "minus") || Intrinsics.areEqual(name, "unaryMinus")) && Intrinsics.areEqual(value2, result2) && !ConstantExpressionEvaluatorKt.isZero(value2)) {
            reportIntegerOverflow.invoke();
        }
        return object;
    }

    @Nullable
    public static final Object evaluateBinary(@NotNull String name, @NotNull String receiverTypeStr, @NotNull Object receiverValue, @NotNull String parameterTypeStr, @NotNull Object parameterValue) {
        Object object;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(receiverTypeStr, "receiverTypeStr");
        Intrinsics.checkNotNullParameter(receiverValue, "receiverValue");
        Intrinsics.checkNotNullParameter(parameterTypeStr, "parameterTypeStr");
        Intrinsics.checkNotNullParameter(parameterValue, "parameterValue");
        CompileTimeType receiverType = ConstantExpressionEvaluatorKt.typeStrToCompileTimeType(receiverTypeStr);
        CompileTimeType parameterType = ConstantExpressionEvaluatorKt.typeStrToCompileTimeType(parameterTypeStr);
        try {
            object = OperationsMapGeneratedKt.evalBinaryOp(name, receiverType, receiverValue, parameterType, parameterValue);
        }
        catch (Exception e2) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded(e2);
            object = null;
        }
        return object;
    }

    private static final Object evaluateBinaryAndCheck(String name, CompileTimeType receiverType, Object receiverValue, CompileTimeType parameterType, Object parameterValue, Function0<Unit> reportIntegerOverflow) {
        Object object;
        try {
            object = OperationsMapGeneratedKt.evalBinaryOp(name, receiverType, receiverValue, parameterType, parameterValue);
        }
        catch (Exception e2) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded(e2);
            object = null;
        }
        Object actualResult = object;
        if (actualResult != null && ConstantExpressionEvaluatorKt.isIntegerType(receiverValue) && ConstantExpressionEvaluatorKt.isIntegerType(parameterValue)) {
            BigInteger bigInteger = ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$toBigInteger(receiverValue);
            Intrinsics.checkNotNullExpressionValue(bigInteger, "evaluateBinaryAndCheck$toBigInteger(...)");
            BigInteger bigInteger2 = ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$toBigInteger(parameterValue);
            Intrinsics.checkNotNullExpressionValue(bigInteger2, "evaluateBinaryAndCheck$toBigInteger(...)");
            BigInteger checkedResult = OperationsMapGeneratedKt.checkBinaryOp(name, receiverType, bigInteger, parameterType, bigInteger2);
            if (checkedResult != null && !Intrinsics.areEqual(ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck$toBigInteger(actualResult), checkedResult)) {
                reportIntegerOverflow.invoke();
            }
        }
        return actualResult;
    }

    private static final BigInteger evaluateBinaryAndCheck$toBigInteger(Object value2) {
        Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Number");
        return BigInteger.valueOf(((Number)value2).longValue());
    }

    public static final /* synthetic */ ConstantValue access$createCompileTimeConstantForCompareTo(Object result2, KtExpression operationReference) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForCompareTo(result2, operationReference);
    }

    public static final /* synthetic */ ConstantValue access$createCompileTimeConstantForEquals(Object result2, KtExpression operationReference) {
        return ConstantExpressionEvaluatorKt.createCompileTimeConstantForEquals(result2, operationReference);
    }

    public static final /* synthetic */ Object access$evaluateUnaryAndCheck(String name, CompileTimeType type2, Object value2, Function0 reportIntegerOverflow) {
        return ConstantExpressionEvaluatorKt.evaluateUnaryAndCheck(name, type2, value2, reportIntegerOverflow);
    }

    public static final /* synthetic */ Object access$evaluateBinaryAndCheck(String name, CompileTimeType receiverType, Object receiverValue, CompileTimeType parameterType, Object parameterValue, Function0 reportIntegerOverflow) {
        return ConstantExpressionEvaluatorKt.evaluateBinaryAndCheck(name, receiverType, receiverValue, parameterType, parameterValue, reportIntegerOverflow);
    }

    public static final /* synthetic */ Set access$getDIVISION_OPERATION_NAMES$p() {
        return DIVISION_OPERATION_NAMES;
    }

    public static final /* synthetic */ boolean access$isZero(Object value2) {
        return ConstantExpressionEvaluatorKt.isZero(value2);
    }

    public static final /* synthetic */ KotlinType access$getReceiverExpressionType(ResolvedCall resolvedCall2) {
        return ConstantExpressionEvaluatorKt.getReceiverExpressionType(resolvedCall2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Name[] nameArray = new Name[]{OperatorNameConventions.DIV, OperatorNameConventions.REM};
        Iterable $this$map$iv = CollectionsKt.listOf(nameArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Name name = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.asString());
        }
        DIVISION_OPERATION_NAMES = CollectionsKt.toSet((List)var3_3);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExplicitReceiverKind.values().length];
            try {
                nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.NO_EXPLICIT_RECEIVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

