/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantKt;
import org.jetbrains.kotlin.resolve.constants.PrimitiveTypeUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\fJ\u001f\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0011\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u0002\u00a2\u0006\u0004\b \u0010!J\u000f\u0010#\u001a\u00020\"H\u0017\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010'\u001a\u00020\u00012\u0006\u0010&\u001a\u00020%H\u0017\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010*\u001a\u00020)H\u0017\u00a2\u0006\u0004\b*\u0010+R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010,R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010-R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000e0.8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "", "value", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "module", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "parameters", "<init>", "(JLorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)V", "", "addSignedSuperTypes", "()V", "addUnsignedSuperTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlinType", "checkBoundsAndAddSuperType", "(JLorg/jetbrains/kotlin/types/KotlinType;)V", "", "getSupertypes", "()Ljava/util/Collection;", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getParameters", "()Ljava/util/List;", "", "isFinal", "()Z", "isDenotable", "", "getDeclarationDescriptor", "()Ljava/lang/Void;", "getValue", "()J", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "kotlinTypeRefiner", "refine", "(Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;)Lorg/jetbrains/kotlin/types/TypeConstructor;", "", "toString", "()Ljava/lang/String;", "J", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Ljava/util/ArrayList;", "supertypes", "Ljava/util/ArrayList;"})
public final class IntegerValueTypeConstructor
implements TypeConstructor {
    private final long value;
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final ArrayList<KotlinType> supertypes;

    public IntegerValueTypeConstructor(long value2, @NotNull ModuleDescriptor module2, @NotNull CompileTimeConstant.Parameters parameters2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        this.value = value2;
        this.module = module2;
        this.supertypes = new ArrayList(4);
        boolean isUnsigned = parameters2.isUnsignedNumberLiteral();
        boolean isConvertable = parameters2.isConvertableConstVal();
        if (isUnsigned || isConvertable) {
            boolean bl = CompileTimeConstantKt.hasUnsignedTypesInModuleDependencies(this.module);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Unsigned types should be on classpath to create an unsigned type constructor";
                throw new AssertionError((Object)string);
            }
        }
        if (isConvertable) {
            this.addSignedSuperTypes();
            this.addUnsignedSuperTypes();
        } else if (isUnsigned) {
            this.addUnsignedSuperTypes();
        } else {
            this.addSignedSuperTypes();
        }
    }

    private final void addSignedSuperTypes() {
        SimpleType simpleType2 = this.getBuiltIns().getIntType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getIntType(...)");
        this.checkBoundsAndAddSuperType(this.value, simpleType2);
        SimpleType simpleType3 = this.getBuiltIns().getByteType();
        Intrinsics.checkNotNullExpressionValue(simpleType3, "getByteType(...)");
        this.checkBoundsAndAddSuperType(this.value, simpleType3);
        SimpleType simpleType4 = this.getBuiltIns().getShortType();
        Intrinsics.checkNotNullExpressionValue(simpleType4, "getShortType(...)");
        this.checkBoundsAndAddSuperType(this.value, simpleType4);
        this.supertypes.add(this.getBuiltIns().getLongType());
    }

    private final void addUnsignedSuperTypes() {
        this.checkBoundsAndAddSuperType(this.value, PrimitiveTypeUtilKt.unsignedType(this.module, StandardNames.FqNames.uInt));
        this.checkBoundsAndAddSuperType(this.value, PrimitiveTypeUtilKt.unsignedType(this.module, StandardNames.FqNames.uByte));
        this.checkBoundsAndAddSuperType(this.value, PrimitiveTypeUtilKt.unsignedType(this.module, StandardNames.FqNames.uShort));
        this.supertypes.add(PrimitiveTypeUtilKt.unsignedType(this.module, StandardNames.FqNames.uLong));
    }

    private final void checkBoundsAndAddSuperType(long value2, KotlinType kotlinType) {
        long l2 = PrimitiveTypeUtilKt.minValue(kotlinType);
        boolean bl = value2 <= PrimitiveTypeUtilKt.maxValue(kotlinType) ? l2 <= value2 : false;
        if (bl) {
            this.supertypes.add(kotlinType);
        }
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return this.supertypes;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Nullable
    public Void getDeclarationDescriptor() {
        return null;
    }

    public final long getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    @Override
    @NotNull
    public TypeConstructor refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        return this;
    }

    @NotNull
    public String toString() {
        return "IntegerValueType(" + this.value + ')';
    }
}

