/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\u0005*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/InlineParameterChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "reportIncorrectInline", "Lorg/jetbrains/kotlin/psi/KtParameter;", "modifierToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
public final class InlineParameterChecker
implements DeclarationChecker {
    @NotNull
    public static final InlineParameterChecker INSTANCE = new InlineParameterChecker();

    private InlineParameterChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block5: {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!(declaration instanceof KtFunction)) break block5;
            boolean inline = declaration.hasModifier(KtTokens.INLINE_KEYWORD);
            for (KtParameter parameter : ((KtFunction)declaration).getValueParameters()) {
                VariableDescriptor parameterDescriptor;
                block7: {
                    block6: {
                        parameterDescriptor = (VariableDescriptor)context.getTrace().get(BindingContext.VALUE_PARAMETER, parameter);
                        if (!inline) break block6;
                        if (parameterDescriptor == null) break block7;
                        KotlinType kotlinType = parameterDescriptor.getType();
                        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                        if (FunctionTypesKt.isBuiltinFunctionalType(kotlinType)) break block7;
                    }
                    Intrinsics.checkNotNull(parameter);
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.NOINLINE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "NOINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter, ktModifierKeywordToken, context.getTrace());
                    KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.CROSSINLINE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken2, "CROSSINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter, ktModifierKeywordToken2, context.getTrace());
                }
                if (!inline || parameter.hasModifier(KtTokens.NOINLINE_KEYWORD) || parameter.hasModifier(KtTokens.CROSSINLINE_KEYWORD)) continue;
                Annotated annotated = parameterDescriptor;
                boolean bl = annotated != null && (annotated = annotated.getType()) != null ? FunctionTypesKt.isSuspendFunctionType((KotlinType)annotated) : false;
                if (!bl) continue;
                if (declaration.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                    KtElementImplStub ktElementImplStub = parameter.getTypeReference();
                    PsiElement modifier = ktElementImplStub != null && (ktElementImplStub = ((KtModifierListOwnerStub)ktElementImplStub).getModifierList()) != null ? ((KtModifierList)ktElementImplStub).getModifier(KtTokens.SUSPEND_KEYWORD) : null;
                    if (modifier == null) continue;
                    context.getTrace().report(Errors.REDUNDANT_INLINE_SUSPEND_FUNCTION_TYPE.on(modifier));
                    continue;
                }
                context.getTrace().report(Errors.INLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }

    private final void reportIncorrectInline(KtParameter $this$reportIncorrectInline, KtModifierKeywordToken modifierToken, DiagnosticSink diagnosticHolder) {
        block0: {
            PsiElement modifier;
            KtModifierList ktModifierList = $this$reportIncorrectInline.getModifierList();
            PsiElement psiElement = modifier = ktModifierList != null ? ktModifierList.getModifier(modifierToken) : null;
            if (psiElement == null) break block0;
            PsiElement it = psiElement;
            boolean bl = false;
            diagnosticHolder.report(Errors.ILLEGAL_INLINE_PARAMETER_MODIFIER.on(modifier, modifierToken));
        }
    }
}

