/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tower.AbstractInvokeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactoryProviderForInvoke;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.InvokeExtensionScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.InvokeProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.TowerData;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u001e\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/InvokeExtensionTowerProcessor;", "C", "Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;", "Lorg/jetbrains/kotlin/resolve/calls/tower/AbstractInvokeTowerProcessor;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "name", "Lorg/jetbrains/kotlin/name/Name;", "factoryProviderForInvoke", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactoryProviderForInvoke;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactoryProviderForInvoke;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;)V", "getScopeTower", "()Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "createInvokeProcessor", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "variableCandidate", "(Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;)Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "mayDataBeApplicable", "", "data", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerData;", "recordLookups", "", "skippedData", "", "resolution"})
public final class InvokeExtensionTowerProcessor<C extends Candidate>
extends AbstractInvokeTowerProcessor<C> {
    @NotNull
    private final ImplicitScopeTower scopeTower;
    @NotNull
    private final Name name;
    @Nullable
    private final ReceiverValueWithSmartCastInfo explicitReceiver;

    public InvokeExtensionTowerProcessor(@NotNull ImplicitScopeTower scopeTower, @NotNull Name name, @NotNull CandidateFactoryProviderForInvoke<C> factoryProviderForInvoke, @Nullable ReceiverValueWithSmartCastInfo explicitReceiver) {
        Intrinsics.checkNotNullParameter(scopeTower, "scopeTower");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(factoryProviderForInvoke, "factoryProviderForInvoke");
        super(factoryProviderForInvoke, ScopeTowerProcessorsKt.createVariableAndObjectProcessor$default(scopeTower, name, factoryProviderForInvoke.factoryForVariable(true), null, false, 16, null));
        this.scopeTower = scopeTower;
        this.name = name;
        this.explicitReceiver = explicitReceiver;
    }

    @NotNull
    public final ImplicitScopeTower getScopeTower() {
        return this.scopeTower;
    }

    @NotNull
    public final Name getName() {
        return this.name;
    }

    @Override
    @Nullable
    protected ScopeTowerProcessor<C> createInvokeProcessor(@NotNull C variableCandidate) {
        Intrinsics.checkNotNullParameter(variableCandidate, "variableCandidate");
        Pair pair = this.getFactoryProviderForInvoke().factoryForInvoke(variableCandidate, true);
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        ReceiverValueWithSmartCastInfo variableReceiver = pair2.component1();
        CandidateFactory invokeContext = pair2.component2();
        CandidateWithBoundDispatchReceiver candidateWithBoundDispatchReceiver = InvokeProcessorsKt.access$getExtensionInvokeCandidateDescriptor(this.scopeTower, variableReceiver);
        if (candidateWithBoundDispatchReceiver == null) {
            return null;
        }
        CandidateWithBoundDispatchReceiver invokeDescriptor = candidateWithBoundDispatchReceiver;
        return new InvokeExtensionScopeTowerProcessor(invokeContext, invokeDescriptor, this.explicitReceiver);
    }

    @Override
    protected boolean mayDataBeApplicable(@NotNull TowerData data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        return Intrinsics.areEqual(data2, TowerData.Empty.INSTANCE) || data2 instanceof TowerData.OnlyImplicitReceiver;
    }

    @Override
    public void recordLookups(@NotNull Collection<? extends TowerData> skippedData, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(skippedData, "skippedData");
        Intrinsics.checkNotNullParameter(name, "name");
        this.getVariableProcessor().recordLookups(skippedData, name);
    }
}

