/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.AbstractFakeOverrideSuperCall;
import org.jetbrains.kotlin.resolve.calls.model.AbstractSuperCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionPart;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SuperAsExtensionReceiver;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/CheckSuperExpressionCallPart;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolutionPart;", "<init>", "()V", "process", "", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "workIndex", "", "checkSuperCandidateDescriptor", "candidateDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "resolution"})
public final class CheckSuperExpressionCallPart
extends ResolutionPart {
    @NotNull
    public static final CheckSuperExpressionCallPart INSTANCE = new CheckSuperExpressionCallPart();

    private CheckSuperExpressionCallPart() {
    }

    @Override
    public void process(@NotNull ResolutionCandidate $this$process, int workIndex) {
        SimpleKotlinCallArgument extensionReceiver;
        Intrinsics.checkNotNullParameter($this$process, "<this>");
        CallableDescriptor candidateDescriptor = $this$process.getResolvedCall().getCandidateDescriptor();
        if ($this$process.getCallComponents().getStatelessCallbacks().isSuperExpression($this$process.getResolvedCall().getDispatchReceiverArgument()) && candidateDescriptor instanceof CallableMemberDescriptor) {
            this.checkSuperCandidateDescriptor($this$process, (CallableMemberDescriptor)candidateDescriptor);
        }
        if ((extensionReceiver = $this$process.getResolvedCall().getExtensionReceiverArgument()) != null && $this$process.getCallComponents().getStatelessCallbacks().isSuperExpression(extensionReceiver)) {
            $this$process.addDiagnostic(new SuperAsExtensionReceiver(extensionReceiver));
        }
    }

    private final void checkSuperCandidateDescriptor(ResolutionCandidate $this$checkSuperCandidateDescriptor, CallableMemberDescriptor candidateDescriptor) {
        if (candidateDescriptor.getModality() == Modality.ABSTRACT) {
            SimpleKotlinCallArgument simpleKotlinCallArgument = $this$checkSuperCandidateDescriptor.getResolvedCall().getDispatchReceiverArgument();
            Intrinsics.checkNotNull(simpleKotlinCallArgument);
            $this$checkSuperCandidateDescriptor.addDiagnostic(new AbstractSuperCall(simpleKotlinCallArgument));
        } else if (candidateDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            CallableMemberDescriptor intersectionFakeOverrideDescriptor = candidateDescriptor;
            while (intersectionFakeOverrideDescriptor.getOverriddenDescriptors().size() == 1) {
                Collection<? extends CallableMemberDescriptor> collection = intersectionFakeOverrideDescriptor.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
                Object t2 = CollectionsKt.first((Iterable)collection);
                Intrinsics.checkNotNullExpressionValue(t2, "first(...)");
                intersectionFakeOverrideDescriptor = (CallableMemberDescriptor)t2;
                if (intersectionFakeOverrideDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
                return;
            }
            if (intersectionFakeOverrideDescriptor.getOverriddenDescriptors().size() > 1) {
                Object v4;
                block7: {
                    Collection<? extends CallableMemberDescriptor> collection = intersectionFakeOverrideDescriptor.getOverriddenDescriptors();
                    Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
                    Iterable $this$firstOrNull$iv = collection;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull(it);
                        if (!(!DescriptorUtilsKt.isInsideInterface(it))) continue;
                        v4 = element$iv;
                        break block7;
                    }
                    v4 = null;
                }
                CallableMemberDescriptor callableMemberDescriptor = v4;
                if ((callableMemberDescriptor != null ? callableMemberDescriptor.getModality() : null) == Modality.ABSTRACT) {
                    $this$checkSuperCandidateDescriptor.addDiagnostic(AbstractFakeOverrideSuperCall.INSTANCE);
                }
            }
        }
    }
}

