/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/UnderscoreUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallElement", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "checkSimpleNameUsage", "ktName", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isUnderscoreOnlyName", "", "", "frontend"})
public final class UnderscoreUsageChecker
implements CallChecker {
    @NotNull
    public static final UnderscoreUsageChecker INSTANCE = new UnderscoreUsageChecker();

    private UnderscoreUsageChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            return;
        }
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
        Object descriptor2 = obj;
        Substitutable<CallableDescriptor> substitutable = descriptor2 instanceof ConstructorDescriptor ? (ConstructorDescriptor)descriptor2 : null;
        DeclarationDescriptor namedDescriptor = substitutable != null && (substitutable = substitutable.getContainingDeclaration()) != null ? (DeclarationDescriptor)((Object)substitutable) : (DeclarationDescriptor)descriptor2;
        String string = namedDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        if (!this.isUnderscoreOnlyName(string)) {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "getCallElement(...)");
        this.checkCallElement(ktElement, context);
    }

    private final void checkCallElement(KtElement ktElement, CallCheckerContext context) {
        block2: {
            KtElement ktElement2;
            block1: {
                ktElement2 = ktElement;
                if (!(ktElement2 instanceof KtSimpleNameExpression)) break block1;
                this.checkSimpleNameUsage((KtSimpleNameExpression)ktElement, context.getTrace());
                break block2;
            }
            if (!(ktElement2 instanceof KtCallExpression)) break block2;
            KtExpression ktExpression = ((KtCallExpression)ktElement).getCalleeExpression();
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                INSTANCE.checkCallElement(it, context);
            }
        }
    }

    private final void checkSimpleNameUsage(KtSimpleNameExpression ktName, BindingTrace trace) {
        String string = ktName.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        if (this.isUnderscoreOnlyName(string)) {
            trace.report(Errors.UNDERSCORE_USAGE_WITHOUT_BACKTICKS.on(ktName));
        }
    }

    public final void checkSimpleNameUsage(@NotNull DeclarationDescriptor descriptor2, @NotNull KtSimpleNameExpression ktName, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(ktName, "ktName");
        Intrinsics.checkNotNullParameter(trace, "trace");
        String string = descriptor2.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        if (this.isUnderscoreOnlyName(string)) {
            this.checkSimpleNameUsage(ktName, trace);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnderscoreOnlyName(String $this$isUnderscoreOnlyName) {
        if (((CharSequence)$this$isUnderscoreOnlyName).length() <= 0) return false;
        boolean bl = true;
        if (!bl) return false;
        CharSequence $this$all$iv = $this$isUnderscoreOnlyName;
        boolean $i$f$all = false;
        int n2 = 0;
        while (n2 < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n2);
            boolean bl2 = false;
            if (it != '_') return false;
            boolean bl3 = true;
            if (!bl3) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

