/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.IncorrectCapturedApproximationCallChecker;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/IncorrectCapturedApproximationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "shouldWarningBeReported", "", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expectedType", "dataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "frontend"})
public final class IncorrectCapturedApproximationCallChecker
implements CallChecker {
    @NotNull
    public static final IncorrectCapturedApproximationCallChecker INSTANCE = new IncorrectCapturedApproximationCallChecker();

    private IncorrectCapturedApproximationCallChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!ArgumentMappingKt.isReallySuccess(resolvedCall2)) {
            return;
        }
        KotlinType kotlinType = resolvedCall2.getSmartCastDispatchReceiverType();
        if (kotlinType == null) {
            ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
            if (receiverValue == null) return;
            KotlinType kotlinType2 = receiverValue.getType();
            kotlinType = kotlinType2;
            if (kotlinType2 == null) {
                return;
            }
        }
        KotlinType dispatchReceiverType = kotlinType;
        Iterable $this$all$iv = dispatchReceiverType.getArguments();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return;
            Object t2 = iterator2.next();
            TypeProjection it = (TypeProjection)t2;
            boolean bl2 = false;
            if (it.getProjectionKind() == Variance.INVARIANT) {
                KotlinType kotlinType3 = it.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType3, "getType(...)");
                if (!CapturedTypeConstructorKt.isCaptured(kotlinType3)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (bl);
        boolean bl3 = false;
        if (bl3) {
            return;
        }
        TypeSubstitution typeSubstitution = TypeSubstitutor.create(dispatchReceiverType).getSubstitution();
        Intrinsics.checkNotNullExpressionValue(typeSubstitution, "getSubstitution(...)");
        TypeSubstitutor substitutor2 = CapturedTypeConstructorKt.wrapWithCapturingSubstitution(typeSubstitution, false).buildSubstitutor();
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor().getOriginal();
        if (!(callableDescriptor instanceof FunctionDescriptor)) return;
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        FunctionDescriptor functionDescriptor3 = functionDescriptor2.substitute(substitutor2);
        if (functionDescriptor3 == null) {
            return;
        }
        FunctionDescriptor capturedSubstituted = functionDescriptor3;
        List<ResolvedValueArgument> list = resolvedCall2.getValueArgumentsByIndex();
        if (list == null) {
            return;
        }
        List<ResolvedValueArgument> list2 = list;
        Iterator iterator3 = ((Iterable)capturedSubstituted.getValueParameters()).iterator();
        int n2 = 0;
        while (iterator3.hasNext()) {
            int index2 = n2++;
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)iterator3.next();
            for (ValueArgument argument : list2.get(index2).getArguments()) {
                DataFlowValue dataFlowValue;
                KotlinType expressionType;
                KtExpression argumentExpression;
                Intrinsics.checkNotNull(parameter);
                Intrinsics.checkNotNull(argument);
                KotlinType expectedType = CallResolverUtilKt.getEffectiveExpectedType(parameter, argument, context.getResolutionContext());
                if (argument.getArgumentExpression() == null) continue;
                BindingContext bindingContext = context.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                if (CallUtilKt.getType(argumentExpression, bindingContext) == null || !this.shouldWarningBeReported(expressionType, expectedType, dataFlowValue = context.getDataFlowValueFactory().createDataFlowValue(argumentExpression, expressionType, context.getResolutionContext()), context)) continue;
                context.getTrace().report(Errors.TYPE_MISMATCH_WARNING_FOR_INCORRECT_CAPTURE_APPROXIMATION.on(argumentExpression, expectedType, expressionType));
            }
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = capturedSubstituted.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) return;
        ReceiverParameterDescriptor extensionReceiverParameter = receiverParameterDescriptor;
        boolean bl4 = false;
        ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
        if (receiverValue == null) return;
        ReceiverValue extensionReceiver = receiverValue;
        DataFlowValue dataFlowValue = context.getDataFlowValueFactory().createDataFlowValue(extensionReceiver, context.getResolutionContext());
        KotlinType kotlinType4 = extensionReceiver.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType4, "getType(...)");
        KotlinType kotlinType5 = extensionReceiverParameter.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType5, "getType(...)");
        if (!INSTANCE.shouldWarningBeReported(kotlinType4, kotlinType5, dataFlowValue, context)) return;
        Object object = extensionReceiver instanceof ExpressionReceiver ? (ExpressionReceiver)extensionReceiver : null;
        PsiElement expression = object != null && (object = object.getExpression()) != null ? (PsiElement)object : reportOn;
        context.getTrace().report(Errors.RECEIVER_TYPE_MISMATCH_WARNING_FOR_INCORRECT_CAPTURE_APPROXIMATION.on(expression, extensionReceiverParameter.getType(), extensionReceiver.getType()));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldWarningBeReported(KotlinType expressionType, KotlinType expectedType, DataFlowValue dataFlowValue, CallCheckerContext context) {
        KotlinType it;
        void $this$none$iv;
        boolean bl;
        boolean bl2;
        Iterable $this$none$iv2 = expectedType.getArguments();
        boolean $i$f$none22 = false;
        if ($this$none$iv2 instanceof Collection && ((Collection)$this$none$iv2).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$none$iv2.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            TypeProjection arg = (TypeProjection)element$iv;
            boolean bl3 = false;
            if (!arg.isStarProjection()) {
                KotlinType kotlinType = arg.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                if (TypeUtilsKt.contains(kotlinType, shouldWarningBeReported.1.1.INSTANCE)) {
                    bl2 = true;
                    continue;
                }
            }
            bl2 = false;
        } while (!bl2);
        boolean bl4 = false;
        if (bl4) {
            return false;
        }
        if (TypeUtilsKt.isSubtypeOf(expressionType, expectedType)) {
            return false;
        }
        KotlinType samExpectedType = SamConversionResolverImplKt.getFunctionTypeForSamType(expectedType, context.getCallComponents().getSamConversionResolver(), context.getCallComponents().getSamConversionOracle());
        if (FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType)) return false;
        KotlinType kotlinType = samExpectedType;
        if (kotlinType != null) {
            if (FunctionTypesKt.isFunctionOrSuspendFunctionType(kotlinType)) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) {
            return false;
        }
        Iterable $i$f$none22 = context.getDataFlowInfo().getCollectedTypes(dataFlowValue, context.getLanguageVersionSettings());
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator3 = $this$none$iv.iterator();
        do {
            if (!iterator3.hasNext()) return true;
            Object element$iv = iterator3.next();
            it = (KotlinType)element$iv;
            boolean bl5 = false;
        } while (!TypeUtilsKt.isSubtypeOf(it, expectedType));
        return false;
    }
}

