/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CompanionIncorrectlyUnboundedWhenUsedAsLHSCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class CompanionIncorrectlyUnboundedWhenUsedAsLHSCallChecker
implements CallChecker {
    @NotNull
    public static final CompanionIncorrectlyUnboundedWhenUsedAsLHSCallChecker INSTANCE = new CompanionIncorrectlyUnboundedWhenUsedAsLHSCallChecker();

    private CompanionIncorrectlyUnboundedWhenUsedAsLHSCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement psiElement = resolvedCall2.getCall().getCallElement().getParent();
        KtCallableReferenceExpression ktCallableReferenceExpression = psiElement instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null;
        if (ktCallableReferenceExpression == null) {
            return;
        }
        KtCallableReferenceExpression callableReference = ktCallableReferenceExpression;
        Receiver receiver = resolvedCall2.getCall().getExplicitReceiver();
        ClassQualifier classQualifier = receiver instanceof ClassQualifier ? (ClassQualifier)receiver : null;
        if (classQualifier == null) {
            return;
        }
        ClassQualifier classQualifier2 = classQualifier;
        ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
        if (receiverValue == null) {
            return;
        }
        ReceiverValue dispatchReceiver = receiverValue;
        if (!Intrinsics.areEqual(dispatchReceiver, classQualifier2.getClassValueReceiver())) {
            return;
        }
        if (!(context.getResolutionContext().callPosition instanceof CallPosition.CallableReferenceRhs)) {
            return;
        }
        ClassifierDescriptor classifierDescriptor = dispatchReceiver.getType().getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor referencedClass = classDescriptor;
        if (!referencedClass.isCompanionObject()) {
            return;
        }
        context.getTrace().report(Errors.INCORRECT_CALLABLE_REFERENCE_RESOLUTION_FOR_COMPANION_LHS.on(callableReference));
    }
}

