/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.EffectSystem;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImplicitIntegerCoercion;
import org.jetbrains.kotlin.resolve.MissingSupertypesResolver;
import org.jetbrains.kotlin.resolve.RecursiveContractHelperKt;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.MissingDependencySupertypeChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J4\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001a2\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010$\u001a\u00020#\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001aH\u0002J@\u0010%\u001a\u00020#\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u0002H\u001b\u0018\u00010'2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J,\u0010(\u001a\u00020#\"\b\b\u0000\u0010\u001b*\u00020\u001c*\b\u0012\u0004\u0012\u0002H\u001b0'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J,\u0010-\u001a\u00020#\"\b\b\u0000\u0010\u001b*\u00020\u001c*\b\u0012\u0004\u0012\u0002H\u001b0'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J(\u0010.\u001a\u00020#\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001aH\u0002J\u0016\u0010/\u001a\u0004\u0018\u0001002\n\u00101\u001a\u0006\u0012\u0002\b\u000302H\u0002J\"\u00103\u001a\u00020#2\u0006\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001e\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u00109\u001a\u00020:2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J6\u0010;\u001a\u0004\u0018\u00010*2\b\u0010<\u001a\u0004\u0018\u00010*2\b\u0010=\u001a\u0004\u0018\u00010*2\u0006\u0010>\u001a\u00020:2\u0006\u0010?\u001a\u00020@2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010A\u001a\u00020B2\u0006\u00109\u001a\u00020:2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010C\u001a\u00020#*\u0006\u0012\u0002\b\u00030'2\u0006\u0010D\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "candidateResolver", "Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "callCheckers", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "effectSystem", "Lorg/jetbrains/kotlin/contracts/EffectSystem;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "missingSupertypesResolver", "Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;Lorg/jetbrains/kotlin/contracts/EffectSystem;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;)V", "completeCall", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "results", "tracing", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "checkMissingSupertypes", "", "completeAllCandidates", "completeResolvedCallAndArguments", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "completeConstraintSystem", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "updateResolutionStatusFromConstraintSystem", "completeArguments", "createTypeForConvertableConstant", "Lorg/jetbrains/kotlin/types/SimpleType;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "completeOneArgument", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "completeCallForArgument", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "updateRecordedTypeForArgument", "updatedType", "recordedType", "argumentExpression", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "hasNecessarySafeCall", "", "updateResultDataFlowInfoUsingEffects", "bindingTrace", "frontend"})
public final class CallCompleter {
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final CandidateResolver candidateResolver;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final Iterable<CallChecker> callCheckers;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final DeprecationResolver deprecationResolver;
    @NotNull
    private final EffectSystem effectSystem;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final MissingSupertypesResolver missingSupertypesResolver;
    @NotNull
    private final KotlinCallComponents callComponents;

    public CallCompleter(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull CandidateResolver candidateResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer2, @NotNull Iterable<? extends CallChecker> callCheckers, @NotNull ModuleDescriptor moduleDescriptor, @NotNull DeprecationResolver deprecationResolver, @NotNull EffectSystem effectSystem, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull MissingSupertypesResolver missingSupertypesResolver, @NotNull KotlinCallComponents callComponents) {
        Intrinsics.checkNotNullParameter(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkNotNullParameter(candidateResolver, "candidateResolver");
        Intrinsics.checkNotNullParameter(dataFlowAnalyzer2, "dataFlowAnalyzer");
        Intrinsics.checkNotNullParameter(callCheckers, "callCheckers");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(deprecationResolver, "deprecationResolver");
        Intrinsics.checkNotNullParameter(effectSystem, "effectSystem");
        Intrinsics.checkNotNullParameter(dataFlowValueFactory, "dataFlowValueFactory");
        Intrinsics.checkNotNullParameter(missingSupertypesResolver, "missingSupertypesResolver");
        Intrinsics.checkNotNullParameter(callComponents, "callComponents");
        this.argumentTypeResolver = argumentTypeResolver;
        this.candidateResolver = candidateResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer2;
        this.callCheckers = callCheckers;
        this.moduleDescriptor = moduleDescriptor;
        this.deprecationResolver = deprecationResolver;
        this.effectSystem = effectSystem;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.missingSupertypesResolver = missingSupertypesResolver;
        this.callComponents = callComponents;
    }

    @NotNull
    public final <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeCall(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(results, "results");
        Intrinsics.checkNotNullParameter(tracing, "tracing");
        ResolvedCall resolvedCall2 = results.isSingleResult() ? results.getResultingCall() : null;
        Call call2 = context.call;
        Intrinsics.checkNotNullExpressionValue(call2, "call");
        if (!CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
            this.completeResolvedCallAndArguments((MutableResolvedCall<D>)resolvedCall2, results, context, tracing);
            this.completeAllCandidates(context, results);
        }
        if (context.trace.wantsDiagnostics()) {
            if (resolvedCall2 == null) {
                this.checkMissingSupertypes(context, this.missingSupertypesResolver);
            } else {
                KtExpression calleeExpression = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCall().getCalleeExpression() : resolvedCall2.getCall().getCalleeExpression();
                KtElement ktElement = calleeExpression != null && !CallUtilKt.isFakeElement(calleeExpression) ? (KtElement)calleeExpression : resolvedCall2.getCall().getCallElement();
                Intrinsics.checkNotNull(ktElement);
                KtElement reportOn = ktElement;
                CallCheckerContext callCheckerContext = new CallCheckerContext(context, this.deprecationResolver, this.moduleDescriptor, this.missingSupertypesResolver, this.callComponents, null, 32, null);
                for (CallChecker callChecker : this.callCheckers) {
                    callChecker.check(resolvedCall2, reportOn, callCheckerContext);
                    if (!(resolvedCall2 instanceof VariableAsFunctionResolvedCall)) continue;
                    callChecker.check(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall(), reportOn, callCheckerContext);
                }
            }
        }
        if (results.isSingleResult() && results.getResultingCall().getStatus().isSuccess()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results.changeStatusToSuccess();
            Intrinsics.checkNotNullExpressionValue(overloadResolutionResultsImpl, "changeStatusToSuccess(...)");
            return overloadResolutionResultsImpl;
        }
        return results;
    }

    private final void checkMissingSupertypes(BasicCallResolutionContext context, MissingSupertypesResolver missingSupertypesResolver) {
        Call call2 = context.call;
        Intrinsics.checkNotNullExpressionValue(call2, "call");
        Call call3 = call2;
        Receiver receiver = call3.getExplicitReceiver();
        ReceiverValue receiverValue = receiver instanceof ReceiverValue ? (ReceiverValue)receiver : null;
        if (receiverValue == null) {
            return;
        }
        ReceiverValue explicitReceiver = receiverValue;
        KotlinType kotlinType = explicitReceiver.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        KtElement ktElement = call3.getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "getCallElement(...)");
        PsiElement psiElement = ktElement;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        MissingDependencySupertypeChecker.INSTANCE.checkSupertypes(kotlinType, psiElement, bindingTrace, missingSupertypesResolver);
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> void completeAllCandidates(BasicCallResolutionContext context, OverloadResolutionResultsImpl<D> results) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Collection<ResolvedCall<D>> collection;
        if (context.collectAllCandidates) {
            Collection<ResolvedCall<D>> collection2 = results.getAllCandidates();
            collection = collection2;
            Intrinsics.checkNotNull(collection2);
        } else {
            Collection<MutableResolvedCall<D>> collection3 = results.getResultingCalls();
            Intrinsics.checkNotNull(collection3);
            collection = collection3;
        }
        Collection<ResolvedCall<D>> collection4 = collection;
        Intrinsics.checkNotNull(collection4, "null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall<D of org.jetbrains.kotlin.resolve.calls.CallCompleter.completeAllCandidates>>");
        Collection<ResolvedCall<D>> candidates = collection4;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "Trace to complete a candidate that is not a resulting call");
        Intrinsics.checkNotNullExpressionValue(temporaryBindingTrace, "create(...)");
        TemporaryBindingTrace temporaryBindingTrace2 = temporaryBindingTrace;
        Iterable $this$filterNot$iv = candidates;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            MutableResolvedCall resolvedCall2 = (MutableResolvedCall)element$iv$iv;
            boolean bl = false;
            if (resolvedCall2.isCompleted()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableResolvedCall resolvedCall3 = (MutableResolvedCall)element$iv;
            boolean bl = false;
            Object Context2 = context.replaceBindingTrace(temporaryBindingTrace2);
            Intrinsics.checkNotNullExpressionValue(Context2, "replaceBindingTrace(...)");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)Context2;
            TracingStrategy tracingStrategy = TracingStrategy.EMPTY;
            Intrinsics.checkNotNullExpressionValue(tracingStrategy, "EMPTY");
            this.completeResolvedCallAndArguments(resolvedCall3, results, basicCallResolutionContext, tracingStrategy);
        }
    }

    private final <D extends CallableDescriptor> void completeResolvedCallAndArguments(MutableResolvedCall<D> resolvedCall2, OverloadResolutionResultsImpl<D> results, BasicCallResolutionContext context, TracingStrategy tracing) {
        Call call2 = context.call;
        Intrinsics.checkNotNullExpressionValue(call2, "call");
        MutableResolvedCall<D> mutableResolvedCall = resolvedCall2;
        Object object = mutableResolvedCall != null ? mutableResolvedCall.getResultingDescriptor() : null;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkNotNullExpressionValue(lexicalScope, "scope");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        RecursiveContractHelperKt.disableContractsInsideContractsBlock(call2, object, lexicalScope, bindingTrace);
        if (resolvedCall2 == null || resolvedCall2.isCompleted() || resolvedCall2.getConstraintSystem() == null) {
            this.completeArguments(context, results);
            MutableResolvedCall<D> mutableResolvedCall2 = resolvedCall2;
            if (mutableResolvedCall2 != null) {
                BindingTrace bindingTrace2 = context.trace;
                Intrinsics.checkNotNullExpressionValue(bindingTrace2, "trace");
                this.updateResultDataFlowInfoUsingEffects(mutableResolvedCall2, bindingTrace2);
            }
            MutableResolvedCall<D> mutableResolvedCall3 = resolvedCall2;
            if (mutableResolvedCall3 != null) {
                mutableResolvedCall3.markCallAsCompleted();
            }
            return;
        }
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkNotNullExpressionValue(kotlinType, "expectedType");
        BindingTrace bindingTrace3 = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace3, "trace");
        this.completeConstraintSystem(resolvedCall2, kotlinType, bindingTrace3);
        this.completeArguments(context, results);
        this.updateResolutionStatusFromConstraintSystem(resolvedCall2, context, tracing);
        BindingTrace bindingTrace4 = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace4, "trace");
        this.updateResultDataFlowInfoUsingEffects(resolvedCall2, bindingTrace4);
        resolvedCall2.markCallAsCompleted();
    }

    private final <D extends CallableDescriptor> void completeConstraintSystem(MutableResolvedCall<D> $this$completeConstraintSystem, KotlinType expectedType, BindingTrace trace) {
        ConstraintSystemCompleter constraintSystemCompleter;
        KotlinType expectedReturnType;
        KotlinType kotlinType;
        KotlinType returnType = $this$completeConstraintSystem.getCandidateDescriptor().getReturnType();
        Call call2 = $this$completeConstraintSystem.getCall();
        Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
        if (CallUtilKt.isCallableReference(call2)) {
            if (!TypeUtils.noExpectedType(expectedType) && FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType)) {
                kotlinType = FunctionTypesKt.getReturnTypeFromFunctionType(expectedType);
            } else {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
                kotlinType = simpleType2;
            }
        } else {
            kotlinType = expectedReturnType = expectedType;
        }
        if (returnType != null && !TypeUtils.noExpectedType(expectedReturnType)) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, arg_0 -> CallCompleter.completeConstraintSystem$lambda$3(returnType, expectedReturnType, $this$completeConstraintSystem, arg_0));
        }
        if ((constraintSystemCompleter = (ConstraintSystemCompleter)trace.get(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, $this$completeConstraintSystem.getCall().getCalleeExpression())) != null) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, arg_0 -> CallCompleter.completeConstraintSystem$lambda$4(constraintSystemCompleter, $this$completeConstraintSystem, arg_0));
        }
        if (returnType != null && expectedReturnType == TypeUtils.UNIT_EXPECTED_TYPE) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, arg_0 -> CallCompleter.completeConstraintSystem$lambda$5(returnType, this, $this$completeConstraintSystem, arg_0));
        }
        Call call3 = $this$completeConstraintSystem.getCall();
        Intrinsics.checkNotNullExpressionValue(call3, "getCall(...)");
        if (CallUtilKt.isCallableReference(call3) && !TypeUtils.noExpectedType(expectedType) && FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType)) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, arg_0 -> CallCompleter.completeConstraintSystem$lambda$7($this$completeConstraintSystem, expectedType, arg_0));
        }
        ConstraintSystem constraintSystem = $this$completeConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull(constraintSystem);
        ConstraintSystem.Builder builder2 = ConstraintSystem.toBuilder$default(constraintSystem, null, 1, null);
        builder2.fixVariables();
        ConstraintSystem system = builder2.build();
        $this$completeConstraintSystem.setConstraintSystem(system);
        boolean isNewInferenceEnabled = this.effectSystem.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference);
        TypeSubstitutor typeSubstitutor2 = isNewInferenceEnabled ? system.getResultingSubstitutor().replaceWithContravariantApproximatingSubstitution() : system.getResultingSubstitutor();
        Intrinsics.checkNotNull(typeSubstitutor2);
        TypeSubstitutor resultingSubstitutor = typeSubstitutor2;
        $this$completeConstraintSystem.setSubstitutor(resultingSubstitutor);
    }

    private final <D extends CallableDescriptor> void updateResolutionStatusFromConstraintSystem(MutableResolvedCall<D> $this$updateResolutionStatusFromConstraintSystem, BasicCallResolutionContext context, TracingStrategy tracing) {
        CallCandidateResolutionContext<D> callCandidateResolutionContext = CallCandidateResolutionContext.createForCallBeingAnalyzed($this$updateResolutionStatusFromConstraintSystem, context, tracing);
        Intrinsics.checkNotNullExpressionValue(callCandidateResolutionContext, "createForCallBeingAnalyzed(...)");
        CallCandidateResolutionContext<D> contextWithResolvedCall = callCandidateResolutionContext;
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.candidateResolver.checkAllValueArguments(contextWithResolvedCall, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        ResolutionStatus resolutionStatus = $this$updateResolutionStatusFromConstraintSystem.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)resolutionStatus, "getStatus(...)");
        ResolutionStatus status2 = resolutionStatus;
        ConstraintSystem constraintSystem = $this$updateResolutionStatusFromConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull(constraintSystem);
        if (constraintSystem.getStatus().isSuccessful()) {
            if (status2 == ResolutionStatus.UNKNOWN_STATUS || status2 == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                $this$updateResolutionStatusFromConstraintSystem.setStatusToSuccess();
            }
            return;
        }
        ReceiverValue receiverValue = $this$updateResolutionStatusFromConstraintSystem.getExtensionReceiver();
        KotlinType receiverType = receiverValue != null ? receiverValue.getType() : null;
        Object d2 = $this$updateResolutionStatusFromConstraintSystem.getCandidateDescriptor();
        ConstraintSystem constraintSystem2 = $this$updateResolutionStatusFromConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull(constraintSystem2);
        InferenceErrorData inferenceErrorData = InferenceErrorData.create(d2, constraintSystem2, valueArgumentsCheckingResult.getArgumentTypes(), receiverType, context.expectedType, context.call);
        Intrinsics.checkNotNullExpressionValue(inferenceErrorData, "create(...)");
        InferenceErrorData errorData = inferenceErrorData;
        tracing.typeInferenceFailed(context, errorData);
        $this$updateResolutionStatusFromConstraintSystem.addStatus(ResolutionStatus.OTHER_ERROR);
    }

    private final <D extends CallableDescriptor> void completeArguments(BasicCallResolutionContext context, OverloadResolutionResultsImpl<D> results) {
        if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        Function1<ValueArgument, ArgumentMapping> getArgumentMapping = null;
        Function1<ValueArgument, DataFlowInfo> getDataFlowInfoForArgument = null;
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall2 = results.getResultingCall();
            Intrinsics.checkNotNullExpressionValue(resolvedCall2, "getResultingCall(...)");
            ResolvedCall resolvedCall3 = resolvedCall2;
            getArgumentMapping = arg_0 -> CallCompleter.completeArguments$lambda$8((MutableResolvedCall)resolvedCall3, arg_0);
            getDataFlowInfoForArgument = arg_0 -> CallCompleter.completeArguments$lambda$9((MutableResolvedCall)resolvedCall3, arg_0);
        } else {
            getArgumentMapping = CallCompleter::completeArguments$lambda$10;
            getDataFlowInfoForArgument = arg_0 -> CallCompleter.completeArguments$lambda$11(context, arg_0);
        }
        Iterator<? extends ValueArgument> iterator2 = context.call.getValueArguments().iterator();
        while (iterator2.hasNext()) {
            ValueArgument valueArgument;
            ValueArgument valueArgument2 = valueArgument = iterator2.next();
            Intrinsics.checkNotNull(valueArgument2);
            ArgumentMapping argumentMapping2 = getArgumentMapping.invoke(valueArgument2);
            KotlinType expectedType = null;
            CallPosition callPosition = null;
            ValueParameterDescriptor parameter = null;
            if (argumentMapping2 instanceof ArgumentMatch) {
                expectedType = CallResolverUtilKt.getEffectiveExpectedType(((ArgumentMatch)argumentMapping2).getValueParameter(), valueArgument, context);
                ResolvedCall resolvedCall4 = results.getResultingCall();
                Intrinsics.checkNotNullExpressionValue(resolvedCall4, "getResultingCall(...)");
                callPosition = new CallPosition.ValueArgumentPosition(resolvedCall4, ((ArgumentMatch)argumentMapping2).getValueParameter(), valueArgument);
                parameter = ((ArgumentMatch)argumentMapping2).getValueParameter();
            } else {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
                expectedType = simpleType2;
                callPosition = CallPosition.Unknown.INSTANCE;
                parameter = null;
            }
            Object Context2 = ((BasicCallResolutionContext)((BasicCallResolutionContext)context.replaceDataFlowInfo(getDataFlowInfoForArgument.invoke(valueArgument))).replaceExpectedType(expectedType)).replaceCallPosition(callPosition);
            Intrinsics.checkNotNullExpressionValue(Context2, "replaceCallPosition(...)");
            BasicCallResolutionContext newContext = (BasicCallResolutionContext)Context2;
            this.completeOneArgument(valueArgument, parameter, newContext);
        }
    }

    private final SimpleType createTypeForConvertableConstant(CompileTimeConstant<?> constant) {
        SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
        Object object = constant.getValue(simpleType2);
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
        if (number == null) {
            return null;
        }
        long value2 = number.longValue();
        IntegerValueTypeConstructor typeConstructor2 = new IntegerValueTypeConstructor(value2, this.moduleDescriptor, constant.getParameters());
        object = new String[]{typeConstructor2.toString()};
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), typeConstructor2, CollectionsKt.emptyList(), false, ErrorUtils.createErrorScope(ErrorScopeKind.INTEGER_LITERAL_TYPE_SCOPE, true, object));
    }

    /*
     * Unable to fully structure code
     */
    private final void completeOneArgument(ValueArgument argument, ValueParameterDescriptor parameter, BasicCallResolutionContext context) {
        if (argument.isExternal()) {
            return;
        }
        v0 = argument.getArgumentExpression();
        if (v0 == null) {
            return;
        }
        expression = v0;
        v1 = KtPsiUtil.getLastElementDeparenthesized(expression, context.statementFilter);
        if (v1 == null) {
            return;
        }
        deparenthesized = v1;
        updatedType = recordedType = context.trace.getType(expression);
        results = this.completeCallForArgument(deparenthesized, context);
        constant = (CompileTimeConstant)context.trace.get(BindingContext.COMPILE_TIME_VALUE, deparenthesized);
        v2 = convertedConst = constant instanceof IntegerValueTypeConstant != false && ((IntegerValueTypeConstant)constant).getConvertedFromSigned() != false;
        if (results != null && results.isSingleResult()) {
            v3 = results.getResultingCall();
            Intrinsics.checkNotNullExpressionValue(v3, "getResultingCall(...)");
            resolvedCall = v3;
            if (!convertedConst) {
                if (resolvedCall.hasInferredReturnType()) {
                    v4 = resolvedCall.getResultingDescriptor();
                    v5 = ResolvedCallUtilKt.makeNullableTypeIfSafeReceiver(resolvedCall, v4 != null ? v4.getReturnType() : null, context);
                } else {
                    v5 = updatedType = null;
                }
            }
        }
        if (recordedType != null && !recordedType.getConstructor().isDenotable() && (v6 = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context, expression)) == null) {
            v6 = updatedType = updatedType;
        }
        if (parameter == null) ** GOTO lbl-1000
        v7 = parameter;
        v8 = context.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(v8, "languageVersionSettings");
        if (ImplicitIntegerCoercion.INSTANCE.isEnabledFor(v7, v8)) {
            argumentCompileTimeValue = (CompileTimeConstant)context.trace.get(BindingContext.COMPILE_TIME_VALUE, deparenthesized);
            if (argumentCompileTimeValue != null && argumentCompileTimeValue.getParameters().isConvertableConstVal() && (generalNumberType = this.createTypeForConvertableConstant(argumentCompileTimeValue)) != null) {
                updatedType = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context.trace, context.statementFilter, context.expectedType, generalNumberType, expression);
            }
        } else if (convertedConst) {
            context.trace.report(Errors.SIGNED_CONSTANT_CONVERTED_TO_UNSIGNED.on((KtExpression)((PsiElement)deparenthesized)));
        }
        v9 = context.statementFilter;
        Intrinsics.checkNotNullExpressionValue(v9, "statementFilter");
        v10 = context.trace;
        Intrinsics.checkNotNullExpressionValue(v10, "trace");
        updatedType = this.updateRecordedTypeForArgument(updatedType, recordedType, expression, v9, v10);
        v11 = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression, context);
        if (v11 != null) {
            functionLiteralArgument = v11;
            $i$a$-let-CallCompleter$completeOneArgument$1 = false;
            this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression, functionLiteralArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, false);
        }
        v12 = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression, context);
        if (v12 != null) {
            callableReferenceArgument = v12;
            $i$a$-let-CallCompleter$completeOneArgument$2 = false;
            this.argumentTypeResolver.getCallableReferenceTypeInfo(expression, callableReferenceArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        }
        this.dataFlowAnalyzer.checkType(updatedType, deparenthesized, (ResolutionContext)context);
    }

    private final OverloadResolutionResultsImpl<?> completeCallForArgument(KtExpression expression, BasicCallResolutionContext context) {
        ResolutionResultsCache.CachedData cachedData = GenericCandidateResolverKt.getResolutionResultsCachedData(expression, context);
        if (cachedData == null) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedData2 = cachedData;
        OverloadResolutionResultsImpl<?> cachedResolutionResults = cachedData2.component1();
        BasicCallResolutionContext cachedContext = cachedData2.component2();
        TracingStrategy tracing = cachedData2.component3();
        Object Context2 = ((BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)cachedContext.replaceBindingTrace(context.trace)).replaceExpectedType(context.expectedType)).replaceCollectAllCandidates(false)).replaceCallPosition(context.callPosition);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceCallPosition(...)");
        BasicCallResolutionContext contextForArgument = (BasicCallResolutionContext)Context2;
        return this.completeCall(contextForArgument, cachedResolutionResults, tracing);
    }

    private final KotlinType updateRecordedTypeForArgument(KotlinType updatedType, KotlinType recordedType, KtExpression argumentExpression, StatementFilter statementFilter, BindingTrace trace) {
        if (!ErrorUtils.INSTANCE.containsErrorType(recordedType) && Intrinsics.areEqual(recordedType, updatedType) || updatedType == null) {
            return updatedType;
        }
        ArrayList<KtExpression> expressions = new ArrayList<KtExpression>();
        KtExpression expression = argumentExpression;
        while (expression != null) {
            expressions.add(expression);
            expression = CallCompleter.updateRecordedTypeForArgument$deparenthesizeOrGetSelector(statementFilter, expression);
        }
        boolean shouldBeMadeNullable = false;
        Iterable $this$forEach$iv = CollectionsKt.asReversedMutable((List)expressions);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression ktExpression = (KtExpression)element$iv;
            boolean bl = false;
            if (!(ktExpression instanceof KtParenthesizedExpression || ktExpression instanceof KtLabeledExpression || ktExpression instanceof KtAnnotatedExpression)) {
                shouldBeMadeNullable = this.hasNecessarySafeCall(ktExpression, trace);
            }
            BindingContextUtils.updateRecordedType(updatedType, ktExpression, trace, shouldBeMadeNullable);
        }
        return trace.getType(argumentExpression);
    }

    private final boolean hasNecessarySafeCall(KtExpression expression, BindingTrace trace) {
        if (!(expression instanceof KtSafeQualifiedExpression)) {
            return false;
        }
        KotlinType expressionType = trace.getType(((KtSafeQualifiedExpression)expression).getReceiverExpression());
        return expressionType != null && TypeUtils.isNullableType(expressionType);
    }

    private final void updateResultDataFlowInfoUsingEffects(MutableResolvedCall<?> $this$updateResultDataFlowInfoUsingEffects, BindingTrace bindingTrace) {
        if ($this$updateResultDataFlowInfoUsingEffects.getDataFlowInfoForArguments() instanceof MutableDataFlowInfoForArguments.WithoutArgumentsCheck) {
            return;
        }
        Object d2 = $this$updateResultDataFlowInfoUsingEffects.getResultingDescriptor();
        if (d2 == null || (d2 = d2.getContainingDeclaration()) == null) {
            return;
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(d2);
        Intrinsics.checkNotNullExpressionValue(moduleDescriptor, "getContainingModule(...)");
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        DataFlowInfo resultDFIfromES = this.effectSystem.getDataFlowInfoForFinishedCall((ResolvedCall)$this$updateResultDataFlowInfoUsingEffects, bindingTrace, moduleDescriptor2);
        $this$updateResultDataFlowInfoUsingEffects.getDataFlowInfoForArguments().updateResultInfo(resultDFIfromES);
        this.effectSystem.recordDefiniteInvocations((ResolvedCall)$this$updateResultDataFlowInfoUsingEffects, bindingTrace, moduleDescriptor2);
    }

    private static final <D extends CallableDescriptor> KotlinType completeConstraintSystem$typeInSystem(ConstraintSystem.Builder $this$completeConstraintSystem_u24typeInSystem, MutableResolvedCall<D> $this_completeConstraintSystem, KotlinType type2) {
        KotlinType kotlinType;
        KotlinType kotlinType2 = type2;
        if (kotlinType2 != null) {
            KotlinType it = kotlinType2;
            boolean bl = false;
            Map<CallHandle, TypeSubstitutor> map2 = $this$completeConstraintSystem_u24typeInSystem.getTypeVariableSubstitutors();
            Call call2 = $this_completeConstraintSystem.getCall();
            Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
            TypeSubstitutor typeSubstitutor2 = map2.get(TypeVariableKt.toHandle(call2));
            if (typeSubstitutor2 == null) {
                throw new IllegalStateException(("No substitutor for call: " + $this_completeConstraintSystem.getCall()).toString());
            }
            TypeSubstitutor substitutor2 = typeSubstitutor2;
            kotlinType = substitutor2.substitute(it, Variance.INVARIANT);
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    private static final <D extends CallableDescriptor> void completeConstraintSystem$updateSystemIfNeeded(MutableResolvedCall<D> $this_completeConstraintSystem, Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem> buildSystemWithAdditionalConstraints) {
        ConstraintSystem constraintSystem = $this_completeConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull(constraintSystem);
        ConstraintSystem system = buildSystemWithAdditionalConstraints.invoke(ConstraintSystem.toBuilder$default(constraintSystem, null, 1, null));
        if (system != null) {
            $this_completeConstraintSystem.setConstraintSystem(system);
        }
    }

    private static final ConstraintSystem completeConstraintSystem$lambda$3(KotlinType $returnType, KotlinType $expectedReturnType, MutableResolvedCall $this_completeConstraintSystem, ConstraintSystem.Builder builder2) {
        ConstraintSystem constraintSystem;
        Intrinsics.checkNotNullParameter(builder2, "builder");
        KotlinType returnTypeInSystem = CallCompleter.completeConstraintSystem$typeInSystem(builder2, $this_completeConstraintSystem, $returnType);
        if (returnTypeInSystem != null) {
            builder2.addSubtypeConstraint(returnTypeInSystem, $expectedReturnType, ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
            constraintSystem = builder2.build();
        } else {
            constraintSystem = null;
        }
        return constraintSystem;
    }

    private static final ConstraintSystem completeConstraintSystem$lambda$4(ConstraintSystemCompleter $constraintSystemCompleter, MutableResolvedCall $this_completeConstraintSystem, ConstraintSystem.Builder builder2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        $constraintSystemCompleter.completeConstraintSystem(builder2, $this_completeConstraintSystem);
        ConstraintSystem system = builder2.build();
        ConstraintSystemStatus status2 = ConstraintSystemUtilsKt.filterConstraintsOut(system, ConstraintPositionKind.TYPE_BOUND_POSITION).getStatus();
        return status2.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.FROM_COMPLETER) ? null : system;
    }

    private static final ConstraintSystem completeConstraintSystem$lambda$5(KotlinType $returnType, CallCompleter this$0, MutableResolvedCall $this_completeConstraintSystem, ConstraintSystem.Builder builder2) {
        ConstraintSystem constraintSystem;
        Intrinsics.checkNotNullParameter(builder2, "builder");
        KotlinType returnTypeInSystem = CallCompleter.completeConstraintSystem$typeInSystem(builder2, $this_completeConstraintSystem, $returnType);
        if (returnTypeInSystem != null) {
            builder2.addSubtypeConstraint(returnTypeInSystem, this$0.moduleDescriptor.getBuiltIns().getUnitType(), ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
            ConstraintSystem system = builder2.build();
            constraintSystem = system.getStatus().isSuccessful() ? system : null;
        } else {
            constraintSystem = null;
        }
        return constraintSystem;
    }

    private static final ConstraintSystem completeConstraintSystem$lambda$7(MutableResolvedCall $this_completeConstraintSystem, KotlinType $expectedType, ConstraintSystem.Builder builder2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        List<ValueParameterDescriptor> list = $this_completeConstraintSystem.getCandidateDescriptor().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)list, (Iterable)FunctionTypesKt.getValueParameterTypesFromFunctionType($expectedType));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)pair.component1();
            TypeProjection argument = (TypeProjection)pair.component2();
            KotlinType valueParameterInSystem = CallCompleter.completeConstraintSystem$typeInSystem(builder2, $this_completeConstraintSystem, parameter.getType());
            builder2.addSubtypeConstraint(valueParameterInSystem, argument.getType(), ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(parameter.getIndex()));
        }
        return builder2.build();
    }

    private static final ArgumentMapping completeArguments$lambda$8(MutableResolvedCall $resolvedCall, ValueArgument argument) {
        Intrinsics.checkNotNullParameter(argument, "argument");
        return $resolvedCall.getArgumentMapping(argument);
    }

    private static final DataFlowInfo completeArguments$lambda$9(MutableResolvedCall $resolvedCall, ValueArgument argument) {
        Intrinsics.checkNotNullParameter(argument, "argument");
        return $resolvedCall.getDataFlowInfoForArguments().getInfo(argument);
    }

    private static final ArgumentUnmapped completeArguments$lambda$10(ValueArgument it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ArgumentUnmapped.INSTANCE;
    }

    private static final DataFlowInfo completeArguments$lambda$11(BasicCallResolutionContext $context, ValueArgument it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $context.dataFlowInfo;
    }

    private static final KtExpression updateRecordedTypeForArgument$deparenthesizeOrGetSelector(StatementFilter $statementFilter, KtExpression expression) {
        KtExpression deparenthesized = KtPsiUtil.deparenthesizeOnce(expression);
        if (!Intrinsics.areEqual(deparenthesized, expression)) {
            return deparenthesized;
        }
        if (expression instanceof KtBlockExpression) {
            return StatementFilterKt.getLastStatementInABlock($statementFilter, (KtBlockExpression)expression);
        }
        KtQualifiedExpression ktQualifiedExpression = expression instanceof KtQualifiedExpression ? (KtQualifiedExpression)expression : null;
        return ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
    }
}

