/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.ArrayFqNames;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;

public class CompileTimeConstantUtils {
    public static void checkConstructorParametersType(@NotNull List<KtParameter> parameters2, @NotNull BindingTrace trace) {
        if (parameters2 == null) {
            CompileTimeConstantUtils.$$$reportNull$$$0(0);
        }
        if (trace == null) {
            CompileTimeConstantUtils.$$$reportNull$$$0(1);
        }
        for (KtParameter parameter : parameters2) {
            VariableDescriptor parameterDescriptor = trace.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
            if (parameterDescriptor == null) continue;
            KotlinType parameterType = parameterDescriptor.getType();
            KtTypeReference typeReference = parameter.getTypeReference();
            if (typeReference == null) continue;
            if (parameterType.isMarkedNullable()) {
                trace.report(Errors.NULLABLE_TYPE_OF_ANNOTATION_MEMBER.on(typeReference));
                continue;
            }
            if (CompileTimeConstantUtils.isAcceptableTypeForAnnotationParameter(parameterType)) continue;
            trace.report(Errors.INVALID_TYPE_OF_ANNOTATION_MEMBER.on(typeReference));
        }
    }

    private static boolean isAcceptableTypeForAnnotationParameter(@NotNull KotlinType parameterType) {
        List<TypeProjection> arguments2;
        if (parameterType == null) {
            CompileTimeConstantUtils.$$$reportNull$$$0(2);
        }
        if (KotlinTypeKt.isError(parameterType)) {
            return true;
        }
        ClassDescriptor typeDescriptor = TypeUtils.getClassDescriptor(parameterType);
        if (typeDescriptor == null) {
            return false;
        }
        if (DescriptorUtils.isEnumClass(typeDescriptor) || DescriptorUtils.isAnnotationClass(typeDescriptor) || KotlinBuiltIns.isKClass(typeDescriptor) || KotlinBuiltIns.isPrimitiveArray(parameterType) || KotlinBuiltIns.isPrimitiveType(parameterType) || KotlinBuiltIns.isString(parameterType) || UnsignedTypes.isUnsignedType(parameterType) || UnsignedTypes.isUnsignedArrayType(parameterType)) {
            return true;
        }
        if (KotlinBuiltIns.isArray(parameterType) && (arguments2 = parameterType.getArguments()).size() == 1) {
            KotlinType arrayType = arguments2.get(0).getType();
            if (arrayType.isMarkedNullable()) {
                return false;
            }
            ClassDescriptor arrayTypeDescriptor = TypeUtils.getClassDescriptor(arrayType);
            if (arrayTypeDescriptor != null) {
                return DescriptorUtils.isEnumClass(arrayTypeDescriptor) || DescriptorUtils.isAnnotationClass(arrayTypeDescriptor) || KotlinBuiltIns.isKClass(arrayTypeDescriptor) || KotlinBuiltIns.isString(arrayType);
            }
        }
        return false;
    }

    public static boolean isArrayFunctionCall(@NotNull ResolvedCall<?> resolvedCall2) {
        FqNameUnsafe unsafe;
        if (resolvedCall2 == null) {
            CompileTimeConstantUtils.$$$reportNull$$$0(3);
        }
        if (!(unsafe = DescriptorUtils.getFqName(resolvedCall2.getCandidateDescriptor())).isSafe()) {
            return false;
        }
        return ArrayFqNames.ARRAY_CALL_FQ_NAMES.contains(unsafe.toSafe());
    }

    public static boolean canBeReducedToBooleanConstant(@Nullable KtExpression expression, @NotNull BindingContext context, @Nullable Boolean expectedValue) {
        KtExpression effectiveExpression;
        if (context == null) {
            CompileTimeConstantUtils.$$$reportNull$$$0(4);
        }
        if ((effectiveExpression = KtPsiUtil.deparenthesize(expression)) == null) {
            return false;
        }
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.getConstant(effectiveExpression, context);
        if (!(compileTimeConstant instanceof TypedCompileTimeConstant) || compileTimeConstant.getUsesVariableAsConstant()) {
            return false;
        }
        ConstantValue constantValue = ((TypedCompileTimeConstant)compileTimeConstant).getConstantValue();
        if (!(constantValue instanceof BooleanValue)) {
            return false;
        }
        Boolean value2 = (Boolean)((BooleanValue)constantValue).getValue();
        return expectedValue == null || expectedValue.equals(value2);
    }

    private CompileTimeConstantUtils() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/CompileTimeConstantUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConstructorParametersType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableTypeForAnnotationParameter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isArrayFunctionCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeReducedToBooleanConstant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

