/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.KeywordStringsGenerated;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0013\u0010\u0005\u001a\u00020\u0004*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u0002\u0010\b\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\tH\u0007\u00a2\u0006\u0004\b\u0002\u0010\n\u001a\u001d\u0010\r\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u001a9\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u001d\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019"}, d2={"Lorg/jetbrains/kotlin/name/Name;", "", "render", "(Lorg/jetbrains/kotlin/name/Name;)Ljava/lang/String;", "", "shouldBeEscaped", "(Lorg/jetbrains/kotlin/name/Name;)Z", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "(Lorg/jetbrains/kotlin/name/FqNameUnsafe;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/lang/String;", "", "pathSegments", "renderFqName", "(Ljava/util/List;)Ljava/lang/String;", "lowerRendered", "lowerPrefix", "upperRendered", "upperPrefix", "foldedPrefix", "replacePrefixesInTypeRepresentations", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "lower", "upper", "typeStringsDifferOnlyInNullability", "(Ljava/lang/String;Ljava/lang/String;)Z"})
public final class RenderingUtilsKt {
    @NotNull
    public static final String render(@NotNull Name $this$render) {
        String string;
        Intrinsics.checkNotNullParameter($this$render, "<this>");
        if (RenderingUtilsKt.shouldBeEscaped($this$render)) {
            StringBuilder stringBuilder = new StringBuilder();
            char c2 = '`';
            String string2 = $this$render.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String string3 = string2;
            string = stringBuilder.append(c2 + string3).append('`').toString();
        } else {
            String string4 = $this$render.asString();
            string = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "asString(...)");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeEscaped(Name $this$shouldBeEscaped) {
        String string = $this$shouldBeEscaped.asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        String string2 = string;
        if (KeywordStringsGenerated.KEYWORDS.contains(string2)) return true;
        CharSequence $this$any$iv = string2;
        boolean $i$f$any = false;
        for (int i2 = 0; i2 < $this$any$iv.length(); ++i2) {
            char element$iv;
            char it = element$iv = $this$any$iv.charAt(i2);
            boolean bl = false;
            if (!Character.isLetterOrDigit(it) && it != '_') {
                return true;
            }
            boolean bl2 = false;
            if (!bl2) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (((CharSequence)string2).length() == 0) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        if (Character.isJavaIdentifierStart(string2.codePointAt(0))) return false;
        return true;
    }

    @NotNull
    public static final String render(@NotNull FqNameUnsafe $this$render) {
        Intrinsics.checkNotNullParameter($this$render, "<this>");
        return RenderingUtilsKt.renderFqName($this$render.pathSegments());
    }

    @NotNull
    public static final String render(@NotNull FqName $this$render) {
        Intrinsics.checkNotNullParameter($this$render, "<this>");
        return RenderingUtilsKt.renderFqName($this$render.pathSegments());
    }

    @NotNull
    public static final String renderFqName(@NotNull List<Name> pathSegments) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(pathSegments, "pathSegments");
        StringBuilder $this$renderFqName_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Name element : pathSegments) {
            if ($this$renderFqName_u24lambda_u241.length() > 0) {
                $this$renderFqName_u24lambda_u241.append(".");
            }
            $this$renderFqName_u24lambda_u241.append(RenderingUtilsKt.render(element));
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static final String replacePrefixesInTypeRepresentations(@NotNull String lowerRendered, @NotNull String lowerPrefix, @NotNull String upperRendered, @NotNull String upperPrefix, @NotNull String foldedPrefix) {
        Intrinsics.checkNotNullParameter(lowerRendered, "lowerRendered");
        Intrinsics.checkNotNullParameter(lowerPrefix, "lowerPrefix");
        Intrinsics.checkNotNullParameter(upperRendered, "upperRendered");
        Intrinsics.checkNotNullParameter(upperPrefix, "upperPrefix");
        Intrinsics.checkNotNullParameter(foldedPrefix, "foldedPrefix");
        if (StringsKt.startsWith$default(lowerRendered, lowerPrefix, false, 2, null) && StringsKt.startsWith$default(upperRendered, upperPrefix, false, 2, null)) {
            String string = lowerRendered.substring(lowerPrefix.length());
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String lowerWithoutPrefix = string;
            String string2 = upperRendered.substring(upperPrefix.length());
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String upperWithoutPrefix = string2;
            String flexibleCollectionName = foldedPrefix + lowerWithoutPrefix;
            if (Intrinsics.areEqual(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName;
            }
            if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName + '!';
            }
        }
        return null;
    }

    public static final boolean typeStringsDifferOnlyInNullability(@NotNull String lower, @NotNull String upper) {
        Intrinsics.checkNotNullParameter(lower, "lower");
        Intrinsics.checkNotNullParameter(upper, "upper");
        return Intrinsics.areEqual(lower, StringsKt.replace$default(upper, "?", "", false, 4, null)) || StringsKt.endsWith$default(upper, "?", false, 2, null) && Intrinsics.areEqual(lower + '?', upper) || Intrinsics.areEqual('(' + lower + ")?", upper);
    }
}

