/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0003\t\n\u000bJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H'\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "classifier", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderer", "", "renderClassifier", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;)Ljava/lang/String;", "SHORT", "FULLY_QUALIFIED", "SOURCE_CODE_QUALIFIED"})
public interface ClassifierNamePolicy {
    @NotNull
    public String renderClassifier(@NotNull ClassifierDescriptor var1, @NotNull DescriptorRenderer var2);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy$FULLY_QUALIFIED;", "Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "classifier", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderer", "", "renderClassifier", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;)Ljava/lang/String;"})
    public static final class FULLY_QUALIFIED
    implements ClassifierNamePolicy {
        @NotNull
        public static final FULLY_QUALIFIED INSTANCE = new FULLY_QUALIFIED();

        private FULLY_QUALIFIED() {
        }

        @Override
        @NotNull
        public String renderClassifier(@NotNull ClassifierDescriptor classifier2, @NotNull DescriptorRenderer renderer) {
            Intrinsics.checkNotNullParameter(classifier2, "classifier");
            Intrinsics.checkNotNullParameter(renderer, "renderer");
            if (classifier2 instanceof TypeParameterDescriptor) {
                Name name = ((TypeParameterDescriptor)classifier2).getName();
                Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
                return renderer.renderName(name, false);
            }
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(classifier2);
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "getFqName(...)");
            return renderer.renderFqName(fqNameUnsafe);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy$SHORT;", "Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "classifier", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderer", "", "renderClassifier", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;)Ljava/lang/String;"})
    public static final class SHORT
    implements ClassifierNamePolicy {
        @NotNull
        public static final SHORT INSTANCE = new SHORT();

        private SHORT() {
        }

        @Override
        @NotNull
        public String renderClassifier(@NotNull ClassifierDescriptor classifier2, @NotNull DescriptorRenderer renderer) {
            Intrinsics.checkNotNullParameter(classifier2, "classifier");
            Intrinsics.checkNotNullParameter(renderer, "renderer");
            if (classifier2 instanceof TypeParameterDescriptor) {
                Name name = ((TypeParameterDescriptor)classifier2).getName();
                Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
                return renderer.renderName(name, false);
            }
            ArrayList<Name> qualifiedNameElements = new ArrayList<Name>();
            DeclarationDescriptor current = classifier2;
            do {
                qualifiedNameElements.add(current.getName());
            } while ((current = current.getContainingDeclaration()) instanceof ClassDescriptor);
            return RenderingUtilsKt.renderFqName(CollectionsKt.asReversedMutable((List)qualifiedNameElements));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy$SOURCE_CODE_QUALIFIED;", "Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "classifier", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderer", "", "renderClassifier", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;)Ljava/lang/String;", "descriptor", "qualifiedNameForSourceCode", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "qualifierName", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Ljava/lang/String;"})
    public static final class SOURCE_CODE_QUALIFIED
    implements ClassifierNamePolicy {
        @NotNull
        public static final SOURCE_CODE_QUALIFIED INSTANCE = new SOURCE_CODE_QUALIFIED();

        private SOURCE_CODE_QUALIFIED() {
        }

        @Override
        @NotNull
        public String renderClassifier(@NotNull ClassifierDescriptor classifier2, @NotNull DescriptorRenderer renderer) {
            Intrinsics.checkNotNullParameter(classifier2, "classifier");
            Intrinsics.checkNotNullParameter(renderer, "renderer");
            return this.qualifiedNameForSourceCode(classifier2);
        }

        private final String qualifiedNameForSourceCode(ClassifierDescriptor descriptor2) {
            Name name = descriptor2.getName();
            Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
            String nameString = RenderingUtilsKt.render(name);
            if (descriptor2 instanceof TypeParameterDescriptor) {
                return nameString;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            String qualifier = this.qualifierName(declarationDescriptor);
            return qualifier != null && !Intrinsics.areEqual(qualifier, "") ? qualifier + '.' + nameString : nameString;
        }

        private final String qualifierName(DeclarationDescriptor descriptor2) {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            return declarationDescriptor instanceof ClassDescriptor ? this.qualifiedNameForSourceCode((ClassifierDescriptor)descriptor2) : (declarationDescriptor instanceof PackageFragmentDescriptor ? RenderingUtilsKt.render(((PackageFragmentDescriptor)descriptor2).getFqName().toUnsafe()) : null);
        }
    }
}

