/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import com.intellij.psi.stubs.StubOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.KtBinaryLogicExpression;
import org.jetbrains.kotlin.contracts.description.KtBooleanValueParameterReference;
import org.jetbrains.kotlin.contracts.description.KtCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConstantReference;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.KtIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtIsNullPredicate;
import org.jetbrains.kotlin.contracts.description.KtLogicalNot;
import org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtValueParameterReference;
import org.jetbrains.kotlin.contracts.description.LogicOperationKind;
import org.jetbrains.kotlin.psi.stubs.elements.TypeBeanSerializationKt;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinContractEffectType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeBean;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\u000b\u001a\u00020\u00022\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u000f\u001a\u00020\u00022\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0012\u001a\u00020\u00022\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0015\u001a\u00020\u00022\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0018\u001a\u00020\u00022\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001a2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u001b\u001a\u00020\u00022\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001d2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u001e\u001a\u00020\u00022\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030 2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010!\u001a\u00020\u00022\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030#2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010$\u001a\u00020\u00022\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030&2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010'\u001a\u00020\u00022\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00030)2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinContractSerializationVisitor;", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionVisitor;", "", "", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeBean;", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "<init>", "(Lcom/intellij/psi/stubs/StubOutputStream;)V", "getDataStream", "()Lcom/intellij/psi/stubs/StubOutputStream;", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "data", "visitReturnsEffectDeclaration", "returnsEffect", "Lorg/jetbrains/kotlin/contracts/description/KtReturnsEffectDeclaration;", "visitCallsEffectDeclaration", "callsEffect", "Lorg/jetbrains/kotlin/contracts/description/KtCallsEffectDeclaration;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/contracts/description/KtLogicalNot;", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/contracts/description/KtIsNullPredicate;", "visitConstantDescriptor", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/KtConstantReference;", "visitValueParameterReference", "valueParameterReference", "Lorg/jetbrains/kotlin/contracts/description/KtValueParameterReference;", "visitBooleanValueParameterReference", "booleanValueParameterReference", "Lorg/jetbrains/kotlin/contracts/description/KtBooleanValueParameterReference;", "psi"})
public final class KotlinContractSerializationVisitor
extends KtContractDescriptionVisitor {
    @NotNull
    private final StubOutputStream dataStream;

    public KotlinContractSerializationVisitor(@NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        this.dataStream = dataStream;
    }

    @NotNull
    public final StubOutputStream getDataStream() {
        return this.dataStream;
    }

    public void visitConditionalEffectDeclaration(@NotNull KtConditionalEffectDeclaration conditionalEffect, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(conditionalEffect, "conditionalEffect");
        this.dataStream.writeInt(KotlinContractEffectType.CONDITIONAL.ordinal());
        conditionalEffect.getEffect().accept(this, data2);
        conditionalEffect.getCondition().accept(this, data2);
    }

    public void visitReturnsEffectDeclaration(@NotNull KtReturnsEffectDeclaration returnsEffect, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(returnsEffect, "returnsEffect");
        this.dataStream.writeInt(KotlinContractEffectType.RETURNS.ordinal());
        this.dataStream.writeName(returnsEffect.getValue().getName());
    }

    public void visitCallsEffectDeclaration(@NotNull KtCallsEffectDeclaration callsEffect, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(callsEffect, "callsEffect");
        this.dataStream.writeInt(KotlinContractEffectType.CALLS.ordinal());
        this.dataStream.writeInt(callsEffect.getValueParameterReference().getParameterIndex());
        this.dataStream.writeInt(callsEffect.getKind().ordinal());
    }

    public void visitLogicalBinaryOperationContractExpression(@NotNull KtBinaryLogicExpression binaryLogicExpression, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(binaryLogicExpression, "binaryLogicExpression");
        this.dataStream.writeInt(KotlinContractEffectType.BOOLEAN_LOGIC.ordinal());
        this.dataStream.writeBoolean(binaryLogicExpression.getKind() == LogicOperationKind.AND);
        binaryLogicExpression.getLeft().accept(this, data2);
        binaryLogicExpression.getRight().accept(this, data2);
    }

    public void visitLogicalNot(@NotNull KtLogicalNot logicalNot, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(logicalNot, "logicalNot");
        this.dataStream.writeInt(KotlinContractEffectType.NOT.ordinal());
        logicalNot.getArg().accept(this, data2);
    }

    public void visitIsInstancePredicate(@NotNull KtIsInstancePredicate isInstancePredicate, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(isInstancePredicate, "isInstancePredicate");
        this.dataStream.writeInt(KotlinContractEffectType.IS_INSTANCE.ordinal());
        this.dataStream.writeInt(isInstancePredicate.getArg().getParameterIndex());
        TypeBeanSerializationKt.serializeTypeBean(this.dataStream, (KotlinTypeBean)isInstancePredicate.getType());
        this.dataStream.writeBoolean(isInstancePredicate.isNegated());
    }

    public void visitIsNullPredicate(@NotNull KtIsNullPredicate isNullPredicate, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(isNullPredicate, "isNullPredicate");
        this.dataStream.writeInt(KotlinContractEffectType.IS_NULL.ordinal());
        this.dataStream.writeInt(isNullPredicate.getArg().getParameterIndex());
        this.dataStream.writeBoolean(isNullPredicate.isNegated());
    }

    public void visitConstantDescriptor(@NotNull KtConstantReference constantReference, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(constantReference, "constantReference");
        this.dataStream.writeInt(KotlinContractEffectType.CONSTANT.ordinal());
        this.dataStream.writeName(constantReference.getName());
    }

    public void visitValueParameterReference(@NotNull KtValueParameterReference valueParameterReference, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(valueParameterReference, "valueParameterReference");
        this.dataStream.writeInt(KotlinContractEffectType.PARAMETER_REFERENCE.ordinal());
        this.dataStream.writeInt(valueParameterReference.getParameterIndex());
    }

    public void visitBooleanValueParameterReference(@NotNull KtBooleanValueParameterReference booleanValueParameterReference, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(booleanValueParameterReference, "booleanValueParameterReference");
        this.dataStream.writeInt(KotlinContractEffectType.BOOLEAN_PARAMETER_REFERENCE.ordinal());
        this.dataStream.writeInt(booleanValueParameterReference.getParameterIndex());
    }
}

