/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBackingField;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtContextReceiver;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;

public class KtProperty
extends KtTypeParameterListOwnerStub<KotlinPropertyStub>
implements KtVariableDeclaration {
    private static final Logger LOG = Logger.getInstance(KtProperty.class);
    private static final TokenSet VAL_VAR_TOKEN_SET = TokenSet.create(KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD);

    public KtProperty(@NotNull ASTNode node) {
        if (node == null) {
            KtProperty.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public KtProperty(@NotNull KotlinPropertyStub stub2) {
        if (stub2 == null) {
            KtProperty.$$$reportNull$$$0(1);
        }
        super(stub2, (IStubElementType)KtStubElementTypes.PROPERTY);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            KtProperty.$$$reportNull$$$0(2);
        }
        return visitor2.visitProperty(this, data2);
    }

    @Override
    public boolean isVar() {
        KotlinPropertyStub stub2 = (KotlinPropertyStub)this.getGreenStub();
        if (stub2 != null) {
            return stub2.isVar();
        }
        return this.getNode().findChildByType(KtTokens.VAR_KEYWORD) != null;
    }

    public boolean isLocal() {
        return !this.isTopLevel() && !this.isMember();
    }

    public boolean isMember() {
        PsiElement parent2 = this.getParent();
        return parent2 instanceof KtClassOrObject || parent2 instanceof KtClassBody || parent2 instanceof KtBlockExpression && parent2.getParent() instanceof KtScript;
    }

    public boolean isTopLevel() {
        KotlinPropertyStub stub2 = (KotlinPropertyStub)this.getGreenStub();
        if (stub2 != null) {
            return stub2.isTopLevel();
        }
        return KtPsiUtilKt.isKtFile(this.getParent());
    }

    @Override
    @Nullable
    public KtParameterList getValueParameterList() {
        return null;
    }

    @Override
    @NotNull
    public List<KtParameter> getValueParameters() {
        List<KtParameter> list = Collections.emptyList();
        if (list == null) {
            KtProperty.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public KtTypeReference getReceiverTypeReference() {
        KotlinPropertyStub stub2 = (KotlinPropertyStub)this.getGreenStub();
        if (stub2 != null) {
            if (!stub2.isExtension()) {
                return null;
            }
            return (KtTypeReference)this.getStubOrPsiChild(KtStubElementTypes.TYPE_REFERENCE);
        }
        return this.getReceiverTypeRefByTree();
    }

    @Override
    @NotNull
    public List<KtContextReceiver> getContextReceivers() {
        KtContextReceiverList contextReceiverList = this.getContextReceiverList();
        if (contextReceiverList != null) {
            List<KtContextReceiver> list = contextReceiverList.contextReceivers();
            if (list == null) {
                KtProperty.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<KtContextReceiver> list = Collections.emptyList();
        if (list == null) {
            KtProperty.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    private KtTypeReference getReceiverTypeRefByTree() {
        IElementType tt;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null && (tt = node.getElementType()) != KtTokens.COLON; node = node.getTreeNext()) {
            if (tt != KtNodeTypes.TYPE_REFERENCE) continue;
            return (KtTypeReference)node.getPsi();
        }
        return null;
    }

    @Override
    @Nullable
    public KtTypeReference getTypeReference() {
        KotlinPropertyStub stub2 = (KotlinPropertyStub)this.getGreenStub();
        if (stub2 != null) {
            int returnTypeRefPositionInPsi;
            if (!stub2.hasReturnTypeRef()) {
                return null;
            }
            List typeReferences = this.getStubOrPsiChildrenAsList(KtStubElementTypes.TYPE_REFERENCE);
            int n2 = returnTypeRefPositionInPsi = stub2.isExtension() ? 1 : 0;
            if (typeReferences.size() <= returnTypeRefPositionInPsi) {
                LOG.error("Invalid stub structure built for property:\n" + this.getText());
                return null;
            }
            return (KtTypeReference)typeReferences.get(returnTypeRefPositionInPsi);
        }
        return TypeRefHelpersKt.getTypeReference(this);
    }

    @Override
    @Nullable
    public KtTypeReference setTypeReference(@Nullable KtTypeReference typeRef) {
        return TypeRefHelpersKt.setTypeReference(this, this.getNameIdentifier(), typeRef);
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(KtTokens.COLON);
    }

    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    @NotNull
    public List<KtPropertyAccessor> getAccessors() {
        List<KtPropertyAccessor> list = this.getStubOrPsiChildrenAsList(KtStubElementTypes.PROPERTY_ACCESSOR);
        if (list == null) {
            KtProperty.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public KtPropertyAccessor getGetter() {
        for (KtPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isGetter()) continue;
            return accessor;
        }
        return null;
    }

    @Nullable
    public KtPropertyAccessor getSetter() {
        for (KtPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isSetter()) continue;
            return accessor;
        }
        return null;
    }

    @Nullable
    public KtBackingField getFieldDeclaration() {
        Iterator<KtBackingField> iterator2 = this.getStubOrPsiChildrenAsList(KtStubElementTypes.BACKING_FIELD).iterator();
        if (iterator2.hasNext()) {
            KtBackingField field = iterator2.next();
            return field;
        }
        return null;
    }

    public boolean hasDelegate() {
        KotlinPropertyStub stub2 = (KotlinPropertyStub)this.getGreenStub();
        if (stub2 != null) {
            return stub2.hasDelegate();
        }
        return this.getDelegate() != null;
    }

    @Nullable
    public KtPropertyDelegate getDelegate() {
        KotlinPropertyStub stub2 = (KotlinPropertyStub)this.getStub();
        if (stub2 != null && !stub2.hasDelegate()) {
            return null;
        }
        return (KtPropertyDelegate)this.findChildByType(KtNodeTypes.PROPERTY_DELEGATE);
    }

    public boolean hasDelegateExpression() {
        KotlinPropertyStub stub2 = (KotlinPropertyStub)this.getGreenStub();
        if (stub2 != null) {
            return stub2.hasDelegateExpression();
        }
        return this.getDelegateExpression() != null;
    }

    @Nullable
    public KtExpression getDelegateExpression() {
        KotlinPropertyStub stub2 = (KotlinPropertyStub)this.getStub();
        if (stub2 != null && !stub2.hasDelegateExpression()) {
            return null;
        }
        KtPropertyDelegate delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.getExpression();
        }
        return null;
    }

    @Override
    public boolean hasInitializer() {
        KotlinPropertyStub stub2 = (KotlinPropertyStub)this.getGreenStub();
        if (stub2 != null) {
            return stub2.hasInitializer();
        }
        return this.getInitializer() != null;
    }

    @Override
    @Nullable
    public KtExpression getInitializer() {
        KotlinPropertyStub stub2 = (KotlinPropertyStub)this.getStub();
        if (stub2 != null) {
            if (!stub2.hasInitializer()) {
                return null;
            }
            if (this.getContainingKtFile().isCompiled()) {
                return null;
            }
        }
        return PsiTreeUtil.getNextSiblingOfType(this.findChildByType(KtTokens.EQ), KtExpression.class);
    }

    public boolean hasDelegateExpressionOrInitializer() {
        return this.hasDelegateExpression() || this.hasInitializer();
    }

    @Nullable
    public KtExpression setInitializer(@Nullable KtExpression initializer) {
        KtExpression oldInitializer = this.getInitializer();
        if (oldInitializer != null) {
            if (initializer != null) {
                return (KtExpression)oldInitializer.replace(initializer);
            }
            PsiElement nextSibling = oldInitializer.getNextSibling();
            KtExpression last2 = nextSibling != null && nextSibling.getNode() != null && nextSibling.getNode().getElementType() == KtTokens.SEMICOLON ? nextSibling : oldInitializer;
            this.deleteChildRange((PsiElement)this.findChildByType(KtTokens.EQ), last2);
            return null;
        }
        if (initializer != null) {
            PsiElement addAfter = this.getTypeReference();
            if (addAfter == null) {
                addAfter = this.getNameIdentifier();
            }
            PsiElement eq = this.addAfter(new KtPsiFactory(this.getProject()).createEQ(), addAfter);
            return (KtExpression)this.addAfter(initializer, eq);
        }
        return null;
    }

    @Nullable
    public KtExpression getDelegateExpressionOrInitializer() {
        KtExpression expression = this.getDelegateExpression();
        if (expression == null) {
            return this.getInitializer();
        }
        return expression;
    }

    @Override
    @NotNull
    public PsiElement getValOrVarKeyword() {
        Object element = this.findChildByType(VAL_VAR_TOKEN_SET);
        assert (element != null) : "Val or var should always exist for property" + this.getText();
        Object t2 = element;
        if (t2 == null) {
            KtProperty.$$$reportNull$$$0(7);
        }
        return t2;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    public boolean shouldChangeModificationCount(PsiElement place) {
        return false;
    }

    public boolean hasBody() {
        if (this.hasDelegateExpressionOrInitializer()) {
            return true;
        }
        KtPropertyAccessor getter = this.getGetter();
        if (getter != null && getter.hasBody()) {
            return true;
        }
        KtPropertyAccessor setter = this.getSetter();
        return setter != null && setter.hasBody();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtProperty";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtProperty";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParameters";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextReceivers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValOrVarKeyword";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

