/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0007J\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u001f\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\r\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u001f\u0010\u0012J\u0017\u0010 \u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b \u0010\u001dR\u0014\u0010\"\u001a\u00020!8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R \u0010$\u001a\u00020\u00048\u0007X\u0086D\u00a2\u0006\u0012\n\u0004\b$\u0010%\u0012\u0004\b(\u0010\u0003\u001a\u0004\b&\u0010'"}, d2={"Lorg/jetbrains/kotlin/name/NameUtils;", "", "<init>", "()V", "", "name", "sanitizeAsJavaIdentifier", "(Ljava/lang/String;)Ljava/lang/String;", "shortFileName", "getPackagePartClassNamePrefix", "str", "capitalizeAsJavaClassName", "filePath", "Lorg/jetbrains/kotlin/name/Name;", "getScriptNameForFile", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/name/Name;", "originalName", "getScriptTargetClassName", "(Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/name/Name;", "getSnippetTargetClassName", "prefix", "getSnippetOrScriptTargetClassName", "(Lorg/jetbrains/kotlin/name/Name;Ljava/lang/String;)Lorg/jetbrains/kotlin/name/Name;", "", "hasName", "(Lorg/jetbrains/kotlin/name/Name;)Z", "", "index", "delegateFieldName", "(I)Lorg/jetbrains/kotlin/name/Name;", "propertyName", "propertyDelegateName", "contextReceiverName", "Lkotlin/text/Regex;", "SANITIZE_AS_JAVA_INVALID_CHARACTERS", "Lkotlin/text/Regex;", "CONTEXT_RECEIVER_PREFIX", "Ljava/lang/String;", "getCONTEXT_RECEIVER_PREFIX", "()Ljava/lang/String;", "getCONTEXT_RECEIVER_PREFIX$annotations"})
public final class NameUtils {
    @NotNull
    public static final NameUtils INSTANCE = new NameUtils();
    @NotNull
    private static final Regex SANITIZE_AS_JAVA_INVALID_CHARACTERS = new Regex("[^\\p{L}\\p{Digit}]");
    @NotNull
    private static final String CONTEXT_RECEIVER_PREFIX = "$context_receiver";

    private NameUtils() {
    }

    @NotNull
    public static final String getCONTEXT_RECEIVER_PREFIX() {
        return CONTEXT_RECEIVER_PREFIX;
    }

    public static /* synthetic */ void getCONTEXT_RECEIVER_PREFIX$annotations() {
    }

    @NotNull
    public static final String sanitizeAsJavaIdentifier(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return SANITIZE_AS_JAVA_INVALID_CHARACTERS.replace((CharSequence)name, "_");
    }

    @NotNull
    public static final String getPackagePartClassNamePrefix(@NotNull String shortFileName) {
        Intrinsics.checkNotNullParameter(shortFileName, "shortFileName");
        return ((CharSequence)shortFileName).length() == 0 ? "_" : NameUtils.capitalizeAsJavaClassName(NameUtils.sanitizeAsJavaIdentifier(shortFileName));
    }

    private static final String capitalizeAsJavaClassName(String str) {
        String string;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = String.valueOf(str.charAt(0));
            Intrinsics.checkNotNull(string2, "null cannot be cast to non-null type java.lang.String");
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string3);
            String string4 = str.substring(1);
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            string = stringBuilder2.append(string4).toString();
        } else {
            string = '_' + str;
        }
        return string;
    }

    @NotNull
    public static final Name getScriptNameForFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        Name name = Name.identifier(NameUtils.getPackagePartClassNamePrefix(StringsKt.substringBeforeLast$default(StringsKt.substringAfterLast$default(filePath, '/', null, 2, null), '.', null, 2, null)));
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        return name;
    }

    @NotNull
    public static final Name getScriptTargetClassName(@NotNull Name originalName) {
        Intrinsics.checkNotNullParameter(originalName, "originalName");
        return INSTANCE.getSnippetOrScriptTargetClassName(originalName, "script-");
    }

    @NotNull
    public static final Name getSnippetTargetClassName(@NotNull Name originalName) {
        Intrinsics.checkNotNullParameter(originalName, "originalName");
        return INSTANCE.getSnippetOrScriptTargetClassName(originalName, "snippet-");
    }

    private final Name getSnippetOrScriptTargetClassName(Name originalName, String prefix) {
        Name name;
        if (originalName.isSpecial()) {
            String string = originalName.asStringStripSpecialMarkers();
            Intrinsics.checkNotNullExpressionValue(string, "asStringStripSpecialMarkers(...)");
            name = NameUtils.getScriptNameForFile(StringsKt.removePrefix(string, (CharSequence)prefix));
        } else {
            name = originalName;
        }
        return name;
    }

    public static final boolean hasName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return !Intrinsics.areEqual(name, SpecialNames.NO_NAME_PROVIDED) && !Intrinsics.areEqual(name, SpecialNames.ANONYMOUS);
    }

    @NotNull
    public static final Name delegateFieldName(int index2) {
        Name name = Name.identifier("$$delegate_" + index2);
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        return name;
    }

    @NotNull
    public static final Name propertyDelegateName(@NotNull Name propertyName) {
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        Name name = Name.identifier(propertyName.asString() + "$delegate");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        return name;
    }

    @NotNull
    public static final Name contextReceiverName(int index2) {
        Name name = Name.identifier(CONTEXT_RECEIVER_PREFIX + '_' + index2);
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        return name;
    }
}

