/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.State;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0019\u0010\u0003\u001a\u00020\u0002*\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0019\u0010\u0005\u001a\u00020\u0002*\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0004\u001a\u001f\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0003\u0010\t\u001a\u0011\u0010\n\u001a\u00020\u0002*\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001b\u0010\r\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u0000*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0017\u0010\u0012\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a/\u0010\u0017\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u0014*\u00020\u00002\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00028\u00000\u0015H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a\u0013\u0010\u001b\u001a\u00020\u001a*\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/name/FqName;", "packageName", "", "isSubpackageOf", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;)Z", "isChildOf", "", "subpackageNameStr", "packageNameStr", "(Ljava/lang/String;Ljava/lang/String;)Z", "isOneSegmentFQN", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "prefix", "tail", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;)Lorg/jetbrains/kotlin/name/FqName;", "parentOrNull", "(Lorg/jetbrains/kotlin/name/FqName;)Lorg/jetbrains/kotlin/name/FqName;", "qualifiedName", "isValidJavaFqName", "(Ljava/lang/String;)Z", "V", "", "values", "findValueForMostSpecificFqname", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/util/Map;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/name/CallableId;", "callableIdForConstructor", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/name/CallableId;"})
public final class FqNamesUtilKt {
    public static final boolean isSubpackageOf(@NotNull FqName $this$isSubpackageOf, @NotNull FqName packageName) {
        Intrinsics.checkNotNullParameter($this$isSubpackageOf, "<this>");
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        return Intrinsics.areEqual($this$isSubpackageOf, packageName) ? true : (packageName.isRoot() ? true : FqNamesUtilKt.isSubpackageOf($this$isSubpackageOf.asString(), packageName.asString()));
    }

    public static final boolean isChildOf(@NotNull FqName $this$isChildOf, @NotNull FqName packageName) {
        Intrinsics.checkNotNullParameter($this$isChildOf, "<this>");
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        return Intrinsics.areEqual(FqNamesUtilKt.parentOrNull($this$isChildOf), packageName);
    }

    private static final boolean isSubpackageOf(String subpackageNameStr, String packageNameStr) {
        return StringsKt.startsWith$default(subpackageNameStr, packageNameStr, false, 2, null) && subpackageNameStr.charAt(packageNameStr.length()) == '.';
    }

    public static final boolean isOneSegmentFQN(@NotNull FqName $this$isOneSegmentFQN) {
        Intrinsics.checkNotNullParameter($this$isOneSegmentFQN, "<this>");
        return !$this$isOneSegmentFQN.isRoot() && $this$isOneSegmentFQN.parent().isRoot();
    }

    @NotNull
    public static final FqName tail(@NotNull FqName $this$tail, @NotNull FqName prefix) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$tail, "<this>");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        if (!FqNamesUtilKt.isSubpackageOf($this$tail, prefix) || prefix.isRoot()) {
            fqName2 = $this$tail;
        } else if (Intrinsics.areEqual($this$tail, prefix)) {
            fqName2 = FqName.ROOT;
        } else {
            String string = $this$tail.asString().substring(prefix.asString().length() + 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            fqName2 = new FqName(string);
        }
        return fqName2;
    }

    @Nullable
    public static final FqName parentOrNull(@NotNull FqName $this$parentOrNull) {
        Intrinsics.checkNotNullParameter($this$parentOrNull, "<this>");
        return $this$parentOrNull.isRoot() ? null : $this$parentOrNull.parent();
    }

    public static final boolean isValidJavaFqName(@Nullable String qualifiedName2) {
        if (qualifiedName2 == null) {
            return false;
        }
        State state = State.BEGINNING;
        block4: for (int i2 = 0; i2 < ((CharSequence)qualifiedName2).length(); ++i2) {
            char c2 = ((CharSequence)qualifiedName2).charAt(i2);
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: 
                case 2: {
                    if (!Character.isJavaIdentifierStart(c2)) {
                        return false;
                    }
                    state = State.MIDDLE;
                    continue block4;
                }
                case 3: {
                    if (c2 == '.') {
                        state = State.AFTER_DOT;
                        continue block4;
                    }
                    if (Character.isJavaIdentifierPart(c2)) continue block4;
                    return false;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return state != State.AFTER_DOT;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <V> V findValueForMostSpecificFqname(@NotNull FqName $this$findValueForMostSpecificFqname, @NotNull Map<FqName, ? extends V> values2) {
        Object v1;
        Map map2;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$findValueForMostSpecificFqname, "<this>");
        Intrinsics.checkNotNullParameter(values2, "values");
        Map<FqName, ? extends V> $this$filter$iv = values2;
        boolean $i$f$filter = false;
        Map<FqName, ? extends V> map3 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            FqName fqName2 = (FqName)entry.getKey();
            if (!(Intrinsics.areEqual($this$findValueForMostSpecificFqname, fqName2) || FqNamesUtilKt.isChildOf($this$findValueForMostSpecificFqname, fqName2))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map it = map2 = destination$iv$iv;
        boolean bl = false;
        Map map4 = !it.isEmpty() ? map2 : null;
        if (map4 == null) {
            return null;
        }
        Map suitableItems = map4;
        Iterable iterable = suitableItems.entrySet();
        Iterator iterator3 = iterable.iterator();
        if (!iterator3.hasNext()) {
            v1 = null;
        } else {
            Object t2 = iterator3.next();
            if (!iterator3.hasNext()) {
                v1 = t2;
            } else {
                Map.Entry entry = (Map.Entry)t2;
                boolean bl2 = false;
                FqName fqName3 = (FqName)entry.getKey();
                int n2 = FqNamesUtilKt.tail(fqName3, $this$findValueForMostSpecificFqname).asString().length();
                do {
                    Object t3 = iterator3.next();
                    Map.Entry entry2 = (Map.Entry)t3;
                    $i$a$-minByOrNull-FqNamesUtilKt$findValueForMostSpecificFqname$1 = false;
                    FqName fqName4 = (FqName)entry2.getKey();
                    int n3 = FqNamesUtilKt.tail(fqName4, $this$findValueForMostSpecificFqname).asString().length();
                    if (n2 <= n3) continue;
                    t2 = t3;
                    n2 = n3;
                } while (iterator3.hasNext());
                v1 = t2;
            }
        }
        Map.Entry entry = v1;
        return (V)(entry != null ? entry.getValue() : null);
    }

    @NotNull
    public static final CallableId callableIdForConstructor(@NotNull ClassId $this$callableIdForConstructor) {
        CallableId callableId;
        Intrinsics.checkNotNullParameter($this$callableIdForConstructor, "<this>");
        if ($this$callableIdForConstructor.isNestedClass()) {
            ClassId classId = $this$callableIdForConstructor.getOuterClassId();
            Intrinsics.checkNotNull(classId);
            callableId = new CallableId(classId, $this$callableIdForConstructor.getShortClassName());
        } else {
            callableId = new CallableId($this$callableIdForConstructor.getPackageFqName(), $this$callableIdForConstructor.getShortClassName());
        }
        return callableId;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.BEGINNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.AFTER_DOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

