/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u0000 22\u00020\u0001:\u00012B\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\bB!\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0000\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\t\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\t\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0015\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020\n\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0000\u00a2\u0006\u0004\b\"\u0010%J\u000f\u0010&\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b&\u0010\u0014J\u001a\u0010'\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010+R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010,R\u0018\u0010\t\u001a\u0004\u0018\u00010\u00008\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010-R\u0018\u0010\u000b\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010.R\u0011\u0010/\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b1\u00100"}, d2={"Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "safe", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqName;)V", "(Ljava/lang/String;)V", "parent", "Lorg/jetbrains/kotlin/name/Name;", "shortName", "(Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqNameUnsafe;Lorg/jetbrains/kotlin/name/Name;)V", "", "compute", "()V", "", "indexOfLastDotWithBackticksSupport", "(Ljava/lang/String;)I", "asString", "()Ljava/lang/String;", "toSafe", "()Lorg/jetbrains/kotlin/name/FqName;", "()Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "name", "child", "(Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "()Lorg/jetbrains/kotlin/name/Name;", "shortNameOrSpecial", "", "pathSegments", "()Ljava/util/List;", "segment", "", "startsWith", "(Lorg/jetbrains/kotlin/name/Name;)Z", "other", "(Lorg/jetbrains/kotlin/name/FqNameUnsafe;)Z", "toString", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "Lorg/jetbrains/kotlin/name/Name;", "isSafe", "()Z", "isRoot", "Companion"})
public final class FqNameUnsafe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fqName;
    @Nullable
    private transient FqName safe;
    @Nullable
    private transient FqNameUnsafe parent;
    @Nullable
    private transient Name shortName;
    @NotNull
    private static final Name ROOT_NAME;
    @NotNull
    private static final Pattern SPLIT_BY_DOTS;

    public FqNameUnsafe(@NotNull String fqName2, @NotNull FqName safe) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(safe, "safe");
        this.fqName = fqName2;
        this.safe = safe;
    }

    public FqNameUnsafe(@NotNull String fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        this.fqName = fqName2;
    }

    private FqNameUnsafe(String fqName2, FqNameUnsafe parent2, Name shortName) {
        this.fqName = fqName2;
        this.parent = parent2;
        this.shortName = shortName;
    }

    private final void compute() {
        int lastDot = this.indexOfLastDotWithBackticksSupport(this.fqName);
        if (lastDot >= 0) {
            String string = this.fqName.substring(lastDot + 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            this.shortName = Name.guessByFirstCharacter(string);
            String string2 = this.fqName.substring(0, lastDot);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            this.parent = new FqNameUnsafe(string2);
        } else {
            this.shortName = Name.guessByFirstCharacter(this.fqName);
            this.parent = FqName.ROOT.toUnsafe();
        }
    }

    private final int indexOfLastDotWithBackticksSupport(String fqName2) {
        boolean isBacktick = false;
        for (int index2 = fqName2.length() - 1; index2 >= 0; --index2) {
            char c2 = fqName2.charAt(index2);
            if (c2 == '.' && !isBacktick) {
                return index2;
            }
            if (c2 == '`') {
                isBacktick = !isBacktick;
                continue;
            }
            if (c2 != '\\') continue;
            --index2;
        }
        return -1;
    }

    @NotNull
    public final String asString() {
        return this.fqName;
    }

    public final boolean isSafe() {
        return this.safe != null || StringsKt.indexOf$default((CharSequence)this.asString(), '<', 0, false, 6, null) < 0;
    }

    @NotNull
    public final FqName toSafe() {
        FqName fqName2 = this.safe;
        if (fqName2 == null) {
            FqName fqName3;
            FqName it = fqName3 = new FqName(this);
            boolean bl = false;
            this.safe = it;
            fqName2 = fqName3;
        }
        return fqName2;
    }

    public final boolean isRoot() {
        return ((CharSequence)this.fqName).length() == 0;
    }

    @NotNull
    public final FqNameUnsafe parent() {
        FqNameUnsafe fqNameUnsafe = this.parent;
        if (fqNameUnsafe != null) {
            FqNameUnsafe it = fqNameUnsafe;
            boolean bl = false;
            return it;
        }
        if (!(!this.isRoot())) {
            boolean bl = false;
            String string = "root";
            throw new IllegalStateException(string.toString());
        }
        this.compute();
        FqNameUnsafe fqNameUnsafe2 = this.parent;
        Intrinsics.checkNotNull(fqNameUnsafe2);
        return fqNameUnsafe2;
    }

    @NotNull
    public final FqNameUnsafe child(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string = this.isRoot() ? name.asString() : this.fqName + '.' + name.asString();
        Intrinsics.checkNotNull(string);
        String childFqName = string;
        return new FqNameUnsafe(childFqName, this, name);
    }

    @NotNull
    public final Name shortName() {
        Name name = this.shortName;
        if (name != null) {
            Name it = name;
            boolean bl = false;
            return it;
        }
        if (!(!this.isRoot())) {
            boolean bl = false;
            String string = "root";
            throw new IllegalStateException(string.toString());
        }
        this.compute();
        Name name2 = this.shortName;
        Intrinsics.checkNotNull(name2);
        return name2;
    }

    @NotNull
    public final Name shortNameOrSpecial() {
        return this.isRoot() ? ROOT_NAME : this.shortName();
    }

    @NotNull
    public final List<Name> pathSegments() {
        return FqNameUnsafe.pathSegments$collectSegmentsOf(this);
    }

    public final boolean startsWith(@NotNull Name segment) {
        Intrinsics.checkNotNullParameter(segment, "segment");
        if (this.isRoot()) {
            return false;
        }
        int firstDot = StringsKt.indexOf$default((CharSequence)this.fqName, '.', 0, false, 6, null);
        int fqNameFirstSegmentLength = firstDot == -1 ? this.fqName.length() : firstDot;
        String string = segment.asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        String segmentAsString = string;
        return fqNameFirstSegmentLength == segmentAsString.length() && StringsKt.regionMatches$default(this.fqName, 0, segmentAsString, 0, fqNameFirstSegmentLength, false, 16, null);
    }

    public final boolean startsWith(@NotNull FqNameUnsafe other) {
        int otherLength;
        Intrinsics.checkNotNullParameter(other, "other");
        if (this.isRoot()) {
            return false;
        }
        int thisLength = this.fqName.length();
        if (thisLength < (otherLength = other.fqName.length())) {
            return false;
        }
        return (thisLength == otherLength || this.fqName.charAt(otherLength) == '.') && StringsKt.regionMatches$default(this.fqName, 0, other.fqName, 0, otherLength, false, 16, null);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.isRoot()) {
            String string2 = ROOT_NAME.asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        } else {
            string = this.fqName;
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FqNameUnsafe)) {
            return false;
        }
        return Intrinsics.areEqual(this.fqName, ((FqNameUnsafe)other).fqName);
    }

    public int hashCode() {
        return this.fqName.hashCode();
    }

    private static final List<Name> pathSegments$collectSegmentsOf(FqNameUnsafe fqName2) {
        if (fqName2.isRoot()) {
            return new ArrayList();
        }
        List<Name> parentSegments = FqNameUnsafe.pathSegments$collectSegmentsOf(fqName2.parent());
        parentSegments.add(fqName2.shortName());
        return parentSegments;
    }

    public static final boolean isValid(@Nullable String qualifiedName2) {
        return Companion.isValid(qualifiedName2);
    }

    @NotNull
    public static final FqNameUnsafe topLevel(@NotNull Name shortName) {
        return Companion.topLevel(shortName);
    }

    public /* synthetic */ FqNameUnsafe(String fqName2, FqNameUnsafe parent2, Name shortName, DefaultConstructorMarker $constructor_marker) {
        this(fqName2, parent2, shortName);
    }

    static {
        Name name = Name.special("<root>");
        Intrinsics.checkNotNullExpressionValue(name, "special(...)");
        ROOT_NAME = name;
        Pattern pattern = Pattern.compile("\\.");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        SPLIT_BY_DOTS = pattern;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/name/FqNameUnsafe$Companion;", "", "<init>", "()V", "", "qualifiedName", "", "isValid", "(Ljava/lang/String;)Z", "Lorg/jetbrains/kotlin/name/Name;", "shortName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "topLevel", "(Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "ROOT_NAME", "Lorg/jetbrains/kotlin/name/Name;", "Ljava/util/regex/Pattern;", "SPLIT_BY_DOTS", "Ljava/util/regex/Pattern;"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isValid(@Nullable String qualifiedName2) {
            return qualifiedName2 != null && StringsKt.indexOf$default((CharSequence)qualifiedName2, '/', 0, false, 6, null) < 0 && StringsKt.indexOf$default((CharSequence)qualifiedName2, '*', 0, false, 6, null) < 0;
        }

        @NotNull
        public final FqNameUnsafe topLevel(@NotNull Name shortName) {
            Intrinsics.checkNotNullParameter(shortName, "shortName");
            String string = shortName.asString();
            Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
            return new FqNameUnsafe(string, FqName.ROOT.toUnsafe(), shortName, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

