/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0012\b\u0086\b\u0018\u0000 42\u00020\u0001:\u00014B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0014H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u0010\u0010\u0019\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\u0019\u0010\u0010J\u0010\u0010\u001a\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\u001a\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ.\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c7\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001a\u0010 \u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b \u0010!J\u0010\u0010#\u001a\u00020\"H\u00d6\u0001\u00a2\u0006\u0004\b#\u0010$R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010%\u001a\u0004\b&\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010%\u001a\u0004\b'\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010(\u001a\u0004\b\u0006\u0010\u001cR\u0013\u0010+\u001a\u0004\u0018\u00010\u00008G\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010.\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0013\u00100\u001a\u0004\u0018\u00010\u00008G\u00a2\u0006\u0006\u001a\u0004\b/\u0010*R\u0011\u00102\u001a\u00020\u00008G\u00a2\u0006\u0006\u001a\u0004\b1\u0010*R\u0011\u00103\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/name/ClassId;", "", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "relativeClassName", "", "isLocal", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Z)V", "Lorg/jetbrains/kotlin/name/Name;", "topLevelName", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)V", "name", "createNestedClassId", "(Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/name/ClassId;", "asSingleFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "segment", "startsWith", "(Lorg/jetbrains/kotlin/name/Name;)Z", "", "asString", "()Ljava/lang/String;", "asFqNameString", "toString", "component1", "component2", "component3", "()Z", "copy", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Z)Lorg/jetbrains/kotlin/name/ClassId;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "getRelativeClassName", "Z", "getParentClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "parentClassId", "getShortClassName", "()Lorg/jetbrains/kotlin/name/Name;", "shortClassName", "getOuterClassId", "outerClassId", "getOutermostClassId", "outermostClassId", "isNestedClass", "Companion"})
public final class ClassId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName packageFqName;
    @NotNull
    private final FqName relativeClassName;
    private final boolean isLocal;

    public ClassId(@NotNull FqName packageFqName, @NotNull FqName relativeClassName, boolean isLocal) {
        boolean bl;
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(relativeClassName, "relativeClassName");
        this.packageFqName = packageFqName;
        this.relativeClassName = relativeClassName;
        this.isLocal = isLocal;
        boolean bl2 = bl = !this.relativeClassName.isRoot();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Class name must not be root: " + this.packageFqName + (this.isLocal ? " (local)" : "");
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public final FqName getRelativeClassName() {
        return this.relativeClassName;
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    public ClassId(@NotNull FqName packageFqName, @NotNull Name topLevelName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(topLevelName, "topLevelName");
        this(packageFqName, FqName.Companion.topLevel(topLevelName), false);
    }

    @Nullable
    public final ClassId getParentClassId() {
        ClassId classId;
        boolean condition$iv = this.isNestedClass();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            classId = new ClassId(this.packageFqName, this.relativeClassName.parent(), this.isLocal);
        } else {
            classId = null;
        }
        return classId;
    }

    @NotNull
    public final Name getShortClassName() {
        return this.relativeClassName.shortName();
    }

    @Nullable
    public final ClassId getOuterClassId() {
        ClassId classId;
        FqName parent2 = this.relativeClassName.parent();
        boolean condition$iv = !parent2.isRoot();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            classId = new ClassId(this.packageFqName, parent2, this.isLocal);
        } else {
            classId = null;
        }
        return classId;
    }

    @NotNull
    public final ClassId getOutermostClassId() {
        FqName name = this.relativeClassName;
        while (!name.parent().isRoot()) {
            name = name.parent();
        }
        return new ClassId(this.packageFqName, name, false);
    }

    public final boolean isNestedClass() {
        return !this.relativeClassName.parent().isRoot();
    }

    @NotNull
    public final ClassId createNestedClassId(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new ClassId(this.packageFqName, this.relativeClassName.child(name), this.isLocal);
    }

    @NotNull
    public final FqName asSingleFqName() {
        return this.packageFqName.isRoot() ? this.relativeClassName : new FqName(this.packageFqName.asString() + '.' + this.relativeClassName.asString());
    }

    public final boolean startsWith(@NotNull Name segment) {
        Intrinsics.checkNotNullParameter(segment, "segment");
        return this.packageFqName.startsWith(segment);
    }

    @NotNull
    public final String asString() {
        String string;
        if (this.packageFqName.isRoot()) {
            string = ClassId.asString$escapeSlashes(this.relativeClassName);
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$asString_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$asString_u24lambda_u243.append(StringsKt.replace$default(this.packageFqName.asString(), '.', '/', false, 4, null));
            $this$asString_u24lambda_u243.append("/");
            $this$asString_u24lambda_u243.append(ClassId.asString$escapeSlashes(this.relativeClassName));
            string = stringBuilder.toString();
        }
        return string;
    }

    @NotNull
    public final String asFqNameString() {
        String string;
        if (this.packageFqName.isRoot()) {
            string = this.relativeClassName.asString();
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$asFqNameString_u24lambda_u244 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$asFqNameString_u24lambda_u244.append(this.packageFqName.asString());
            $this$asFqNameString_u24lambda_u244.append(".");
            $this$asFqNameString_u24lambda_u244.append(this.relativeClassName.asString());
            string = stringBuilder.toString();
        }
        return string;
    }

    @NotNull
    public String toString() {
        return this.packageFqName.isRoot() ? '/' + this.asString() : this.asString();
    }

    @NotNull
    public final FqName component1() {
        return this.packageFqName;
    }

    @NotNull
    public final FqName component2() {
        return this.relativeClassName;
    }

    public final boolean component3() {
        return this.isLocal;
    }

    @NotNull
    public final ClassId copy(@NotNull FqName packageFqName, @NotNull FqName relativeClassName, boolean isLocal) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(relativeClassName, "relativeClassName");
        return new ClassId(packageFqName, relativeClassName, isLocal);
    }

    public static /* synthetic */ ClassId copy$default(ClassId classId, FqName fqName2, FqName fqName3, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            fqName2 = classId.packageFqName;
        }
        if ((n2 & 2) != 0) {
            fqName3 = classId.relativeClassName;
        }
        if ((n2 & 4) != 0) {
            bl = classId.isLocal;
        }
        return classId.copy(fqName2, fqName3, bl);
    }

    public int hashCode() {
        int result2 = this.packageFqName.hashCode();
        result2 = result2 * 31 + this.relativeClassName.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isLocal);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassId)) {
            return false;
        }
        ClassId classId = (ClassId)other;
        if (!Intrinsics.areEqual(this.packageFqName, classId.packageFqName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.relativeClassName, classId.relativeClassName)) {
            return false;
        }
        return this.isLocal == classId.isLocal;
    }

    private static final String asString$escapeSlashes(FqName $this$asString_u24escapeSlashes) {
        String res = $this$asString_u24escapeSlashes.asString();
        if (StringsKt.contains$default((CharSequence)res, '/', false, 2, null)) {
            return '`' + res + '`';
        }
        return res;
    }

    @NotNull
    public static final ClassId topLevel(@NotNull FqName topLevelFqName) {
        return Companion.topLevel(topLevelFqName);
    }

    @NotNull
    public static final ClassId fromString(@NotNull String string, boolean isLocal) {
        return Companion.fromString(string, isLocal);
    }

    @NotNull
    public static final ClassId fromString(@NotNull String string) {
        return Companion.fromString(string);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/name/ClassId$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/name/FqName;", "topLevelFqName", "Lorg/jetbrains/kotlin/name/ClassId;", "topLevel", "(Lorg/jetbrains/kotlin/name/FqName;)Lorg/jetbrains/kotlin/name/ClassId;", "", "string", "", "isLocal", "fromString", "(Ljava/lang/String;Z)Lorg/jetbrains/kotlin/name/ClassId;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClassId topLevel(@NotNull FqName topLevelFqName) {
            Intrinsics.checkNotNullParameter(topLevelFqName, "topLevelFqName");
            return new ClassId(topLevelFqName.parent(), topLevelFqName.shortName());
        }

        @NotNull
        public final ClassId fromString(@NotNull String string, boolean isLocal) {
            Intrinsics.checkNotNullParameter(string, "string");
            int tickIndex = StringsKt.indexOf$default((CharSequence)string, '`', 0, false, 6, null);
            int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)string, "/", tickIndex == -1 ? string.length() : tickIndex, false, 4, null);
            String packageName = null;
            String className = null;
            if (lastSlashIndex == -1) {
                packageName = "";
                className = StringsKt.replace$default(string, "`", "", false, 4, null);
            } else {
                String string2 = string.substring(0, lastSlashIndex);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                packageName = StringsKt.replace$default(string2, '/', '.', false, 4, null);
                String string3 = string.substring(lastSlashIndex + 1);
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                className = StringsKt.replace$default(string3, "`", "", false, 4, null);
            }
            return new ClassId(new FqName(packageName), new FqName(className), isLocal);
        }

        public static /* synthetic */ ClassId fromString$default(Companion companion, String string, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            return companion.fromString(string, bl);
        }

        @NotNull
        public final ClassId fromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "string");
            return org.jetbrains.kotlin.name.ClassId$Companion.fromString$default(this, string, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

