/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u0000 ,2\u00020\u0001:\u0001,B7\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\n\u0010\u000bB#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\fB-\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\n\u0010\rB\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000fB\u001b\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\n\u0010\u0010B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0017\u00a2\u0006\u0004\b\u001f\u0010 R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u0013R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010!\u001a\u0004\b#\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010$\u001a\u0004\b%\u0010&R\u001c\u0010\b\u001a\u0004\u0018\u00010\u00078\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010'\u001a\u0004\b(\u0010)R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010!R\u0011\u0010*\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+"}, d2={"Lorg/jetbrains/kotlin/name/CallableId;", "", "Lorg/jetbrains/kotlin/name/FqName;", "packageName", "className", "Lorg/jetbrains/kotlin/name/Name;", "callableName", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "pathToLocal", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/FqName;)V", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)V", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/name/FqName;)V", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/Name;)V", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)V", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/name/FqName;)V", "(Lorg/jetbrains/kotlin/name/Name;)V", "asFqNameForDebugInfo", "()Lorg/jetbrains/kotlin/name/FqName;", "asSingleFqName", "copy", "(Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/name/CallableId;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageName", "getClassName", "Lorg/jetbrains/kotlin/name/Name;", "getCallableName", "()Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "isLocal", "()Z", "Companion"})
public final class CallableId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName packageName;
    @Nullable
    private final FqName className;
    @NotNull
    private final Name callableName;
    @Nullable
    private final ClassId classId;
    @Nullable
    private final FqName pathToLocal;
    @NotNull
    private static final Name LOCAL_NAME = SpecialNames.LOCAL;
    @NotNull
    private static final FqName PACKAGE_FQ_NAME_FOR_LOCAL = FqName.Companion.topLevel(LOCAL_NAME);

    private CallableId(FqName packageName, FqName className, Name callableName, ClassId classId, FqName pathToLocal) {
        this.packageName = packageName;
        this.className = className;
        this.callableName = callableName;
        this.classId = classId;
        this.pathToLocal = pathToLocal;
    }

    @NotNull
    public final FqName getPackageName() {
        return this.packageName;
    }

    @Nullable
    public final FqName getClassName() {
        return this.className;
    }

    @NotNull
    public final Name getCallableName() {
        return this.callableName;
    }

    @Nullable
    public final ClassId getClassId() {
        return this.classId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLocal() {
        if (Intrinsics.areEqual(this.packageName, PACKAGE_FQ_NAME_FOR_LOCAL)) return true;
        ClassId classId = this.classId;
        if (classId == null) return false;
        if (!classId.isLocal()) return false;
        return true;
    }

    public CallableId(@NotNull FqName packageName, @Nullable FqName className, @NotNull Name callableName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Intrinsics.checkNotNullParameter(callableName, "callableName");
        this(packageName, className, callableName, CallableId.Companion.calculateClassId(packageName, className), null);
    }

    public CallableId(@NotNull FqName packageName, @Nullable FqName className, @NotNull Name callableName, @Nullable FqName pathToLocal) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Intrinsics.checkNotNullParameter(callableName, "callableName");
        this(packageName, className, callableName, CallableId.Companion.calculateClassId(packageName, className), pathToLocal);
    }

    public CallableId(@NotNull ClassId classId, @NotNull Name callableName) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(callableName, "callableName");
        this(classId.getPackageFqName(), classId.getRelativeClassName(), callableName, classId, null);
    }

    public CallableId(@NotNull FqName packageName, @NotNull Name callableName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Intrinsics.checkNotNullParameter(callableName, "callableName");
        this(packageName, null, callableName, null, null);
    }

    public CallableId(@NotNull Name callableName, @Nullable FqName pathToLocal) {
        Intrinsics.checkNotNullParameter(callableName, "callableName");
        this(PACKAGE_FQ_NAME_FOR_LOCAL, null, callableName, null, pathToLocal);
    }

    public CallableId(@NotNull Name callableName) {
        Intrinsics.checkNotNullParameter(callableName, "callableName");
        this(PACKAGE_FQ_NAME_FOR_LOCAL, null, callableName, null, null);
    }

    @NotNull
    public final FqName asFqNameForDebugInfo() {
        FqName fqName2 = this.pathToLocal;
        if (fqName2 != null && (fqName2 = fqName2.child(this.callableName)) != null) {
            FqName it = fqName2;
            boolean bl = false;
            return it;
        }
        return this.asSingleFqName();
    }

    @NotNull
    public final FqName asSingleFqName() {
        Object object = this.classId;
        if (object == null || (object = ((ClassId)object).asSingleFqName()) == null || (object = ((FqName)object).child(this.callableName)) == null) {
            object = this.packageName.child(this.callableName);
        }
        return object;
    }

    @NotNull
    public final CallableId copy(@NotNull Name callableName) {
        Intrinsics.checkNotNullParameter(callableName, "callableName");
        return new CallableId(this.packageName, this.className, callableName, this.classId, this.pathToLocal);
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof CallableId) ? false : Intrinsics.areEqual(this.packageName, ((CallableId)other).packageName) && Intrinsics.areEqual(this.className, ((CallableId)other).className) && Intrinsics.areEqual(this.callableName, ((CallableId)other).callableName));
    }

    public int hashCode() {
        int result2 = 17;
        result2 = result2 * 31 + this.packageName.hashCode();
        FqName fqName2 = this.className;
        result2 = result2 * 31 + (fqName2 != null ? ((Object)fqName2).hashCode() : 0);
        result2 = result2 * 31 + this.callableName.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u241.append(StringsKt.replace$default(this.packageName.asString(), '.', '/', false, 4, null));
        $this$toString_u24lambda_u241.append("/");
        if (this.className != null) {
            $this$toString_u24lambda_u241.append(this.className);
            $this$toString_u24lambda_u241.append(".");
        }
        $this$toString_u24lambda_u241.append(this.callableName);
        return stringBuilder.toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/name/CallableId$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/name/FqName;", "packageName", "className", "Lorg/jetbrains/kotlin/name/ClassId;", "calculateClassId", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;)Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/name/Name;", "LOCAL_NAME", "Lorg/jetbrains/kotlin/name/Name;", "PACKAGE_FQ_NAME_FOR_LOCAL", "Lorg/jetbrains/kotlin/name/FqName;", "getPACKAGE_FQ_NAME_FOR_LOCAL", "()Lorg/jetbrains/kotlin/name/FqName;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getPACKAGE_FQ_NAME_FOR_LOCAL() {
            return PACKAGE_FQ_NAME_FOR_LOCAL;
        }

        private final ClassId calculateClassId(FqName packageName, FqName className) {
            ClassId classId;
            FqName fqName2 = className;
            if (fqName2 != null) {
                FqName it = fqName2;
                boolean bl = false;
                classId = new ClassId(packageName, it, Intrinsics.areEqual(packageName, Companion.getPACKAGE_FQ_NAME_FOR_LOCAL()));
            } else {
                classId = null;
            }
            return classId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

