/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0000H\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u000fJ%\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\u000fJ%\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u000f\u0010\u0018\u001a\u00020\u0017H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001a\u0010\u001b\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0003\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u001a\u0010\u0012\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010 \u001a\u0004\b!\u0010\u001eR\u0017\u0010\u0013\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010 \u001a\u0004\b\"\u0010\u001eR\u0017\u0010\u0014\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010 \u001a\u0004\b#\u0010\u001eR \u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020$8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010("}, d2={"Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "", "", "numbers", "<init>", "([I)V", "", "isCompatible", "()Z", "isCompatibleWithCurrentCompilerVersion", "", "toArray", "()[I", "ourVersion", "isCompatibleTo", "(Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)Z", "version", "isAtLeast", "major", "minor", "patch", "(III)Z", "isAtMost", "", "toString", "()Ljava/lang/String;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "[I", "I", "getMajor", "getMinor", "getPatch", "", "rest", "Ljava/util/List;", "getRest", "()Ljava/util/List;", "Companion"})
public abstract class BinaryVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] numbers;
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final List<Integer> rest;
    public static final int MAX_LENGTH = 1024;

    public BinaryVersion(int ... numbers) {
        List list;
        Intrinsics.checkNotNullParameter(numbers, "numbers");
        this.numbers = numbers;
        Integer n2 = ArraysKt.getOrNull(this.numbers, 0);
        this.major = n2 != null ? n2 : -1;
        Integer n3 = ArraysKt.getOrNull(this.numbers, 1);
        this.minor = n3 != null ? n3 : -1;
        Integer n4 = ArraysKt.getOrNull(this.numbers, 2);
        int n5 = this.patch = n4 != null ? n4 : -1;
        if (this.numbers.length > 3) {
            if (this.numbers.length > 1024) {
                throw new IllegalArgumentException("BinaryVersion with length more than 1024 are not supported. Provided length " + this.numbers.length + '.');
            }
            list = CollectionsKt.toList((Iterable)ArraysKt.asList(this.numbers).subList(3, this.numbers.length));
        } else {
            list = CollectionsKt.emptyList();
        }
        this.rest = list;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @NotNull
    public final List<Integer> getRest() {
        return this.rest;
    }

    @Deprecated(message="Please use isCompatibleWithCurrentCompilerVersion()", replaceWith=@ReplaceWith(expression="isCompatibleWithCurrentCompilerVersion()", imports={}))
    public boolean isCompatible() {
        return this.isCompatibleWithCurrentCompilerVersion();
    }

    public abstract boolean isCompatibleWithCurrentCompilerVersion();

    @NotNull
    public final int[] toArray() {
        return this.numbers;
    }

    protected final boolean isCompatibleTo(@NotNull BinaryVersion ourVersion) {
        Intrinsics.checkNotNullParameter(ourVersion, "ourVersion");
        return this.major == 0 ? ourVersion.major == 0 && this.minor == ourVersion.minor : this.major == ourVersion.major && this.minor <= ourVersion.minor;
    }

    public final boolean isAtLeast(@NotNull BinaryVersion version) {
        Intrinsics.checkNotNullParameter(version, "version");
        return this.isAtLeast(version.major, version.minor, version.patch);
    }

    public final boolean isAtLeast(int major, int minor, int patch) {
        if (this.major > major) {
            return true;
        }
        if (this.major < major) {
            return false;
        }
        if (this.minor > minor) {
            return true;
        }
        if (this.minor < minor) {
            return false;
        }
        return this.patch >= patch;
    }

    public final boolean isAtMost(@NotNull BinaryVersion version) {
        Intrinsics.checkNotNullParameter(version, "version");
        return this.isAtMost(version.major, version.minor, version.patch);
    }

    public final boolean isAtMost(int major, int minor, int patch) {
        if (this.major < major) {
            return true;
        }
        if (this.major > major) {
            return false;
        }
        if (this.minor < minor) {
            return true;
        }
        if (this.minor > minor) {
            return false;
        }
        return this.patch <= patch;
    }

    @NotNull
    public String toString() {
        List versions2;
        int[] $this$takeWhile$iv = this.toArray();
        boolean $i$f$takeWhile = false;
        ArrayList<Integer> list$iv = new ArrayList<Integer>();
        int n2 = $this$takeWhile$iv.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int item$iv;
            int it = item$iv = $this$takeWhile$iv[i2];
            boolean bl = false;
            if (!(it != -1)) break;
            list$iv.add(item$iv);
        }
        return (versions2 = (List)list$iv).isEmpty() ? "unknown" : CollectionsKt.joinToString$default(versions2, ".", null, null, 0, null, null, 62, null);
    }

    public boolean equals(@Nullable Object other) {
        return other != null && Intrinsics.areEqual(this.getClass(), other.getClass()) && this.major == ((BinaryVersion)other).major && this.minor == ((BinaryVersion)other).minor && this.patch == ((BinaryVersion)other).patch && Intrinsics.areEqual(this.rest, ((BinaryVersion)other).rest);
    }

    public int hashCode() {
        int result2 = this.major;
        result2 += 31 * result2 + this.minor;
        result2 += 31 * result2 + this.patch;
        result2 += 31 * result2 + ((Object)this.rest).hashCode();
        return result2;
    }

    @Nullable
    public static final int[] parseVersionArray(@NotNull String string) {
        return Companion.parseVersionArray(string);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion$Companion;", "", "<init>", "()V", "MAX_LENGTH", "", "UNKNOWN", "parseVersionArray", "", "string", "", "metadata"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final int[] parseVersionArray(@NotNull String string) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(string, "string");
            String[] stringArray = new String[]{"."};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void part;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Integer n2 = StringsKt.toIntOrNull((String)part);
                if (n2 == null) {
                    return null;
                }
                collection.add(Integer.valueOf(n2));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return ArraysKt.toIntArray(thisCollection$iv.toArray(new Integer[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

