/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.impl.LowLevelReadersKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\bv\u0018\u00002\u00020\u0001:\u0002\u0017\u0018J'\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\u00048&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\r8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0014\u001a\u00020\u00048&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00048&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000b\u0082\u0001\u0002\u0019\u001a\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/library/impl/ReadBuffer;", "", "", "result", "", "offset", "length", "", "get", "([BII)V", "getInt", "()I", "int", "", "getLong", "()J", "long", "getPosition", "setPosition", "(I)V", "position", "getSize", "size", "MemoryBuffer", "OnDemandMemoryBuffer", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer$MemoryBuffer;", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer$OnDemandMemoryBuffer;"})
public interface ReadBuffer {
    public int getSize();

    public void get(@NotNull byte[] var1, int var2, int var3);

    public int getPosition();

    public void setPosition(int var1);

    public int getInt();

    public long getLong();

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/library/impl/ReadBuffer$MemoryBuffer;", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer;", "", "bytes", "<init>", "([B)V", "result", "", "offset", "length", "", "get", "([BII)V", "Ljava/nio/ByteBuffer;", "buffer", "Ljava/nio/ByteBuffer;", "getInt", "()I", "int", "", "getLong", "()J", "long", "value", "getPosition", "setPosition", "(I)V", "position", "getSize", "size"})
    public static final class MemoryBuffer
    implements ReadBuffer {
        @NotNull
        private final ByteBuffer buffer;

        public MemoryBuffer(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            this.buffer = LowLevelReadersKt.getBuffer(bytes);
        }

        @Override
        public int getSize() {
            return this.buffer.limit();
        }

        @Override
        public void get(@NotNull byte[] result2, int offset, int length) {
            Intrinsics.checkNotNullParameter(result2, "result");
            this.buffer.get(result2, offset, length);
        }

        @Override
        public int getPosition() {
            return this.buffer.position();
        }

        @Override
        public void setPosition(int value2) {
            this.buffer.position(value2);
        }

        @Override
        public int getInt() {
            return this.buffer.getInt();
        }

        @Override
        public long getLong() {
            return this.buffer.getLong();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR$\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010!R\u0014\u0010$\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/library/impl/ReadBuffer$OnDemandMemoryBuffer;", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer;", "Lkotlin/Function0;", "", "loadBytes", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "Ljava/nio/ByteBuffer;", "ensureBuffer", "()Ljava/nio/ByteBuffer;", "result", "", "offset", "length", "", "get", "([BII)V", "Ljava/lang/ref/SoftReference;", "bufferRef", "Ljava/lang/ref/SoftReference;", "getInt", "()I", "int", "Lkotlin/jvm/functions/Function0;", "", "getLong", "()J", "long", "pos", "I", "value", "getPosition", "setPosition", "(I)V", "position", "getSize", "size"})
    public static final class OnDemandMemoryBuffer
    implements ReadBuffer {
        @NotNull
        private final Function0<byte[]> loadBytes;
        @NotNull
        private SoftReference<ByteBuffer> bufferRef;
        private int pos;

        public OnDemandMemoryBuffer(@NotNull Function0<byte[]> loadBytes) {
            Intrinsics.checkNotNullParameter(loadBytes, "loadBytes");
            this.loadBytes = loadBytes;
            this.bufferRef = new SoftReference<Object>(null);
        }

        @Override
        public int getSize() {
            return this.ensureBuffer().limit();
        }

        @Override
        public void get(@NotNull byte[] result2, int offset, int length) {
            Intrinsics.checkNotNullParameter(result2, "result");
            ByteBuffer buf = this.ensureBuffer();
            this.pos += length;
            buf.get(result2, offset, length);
        }

        @Override
        public int getPosition() {
            boolean bl;
            int n2;
            int it = n2 = this.pos;
            boolean bl2 = false;
            boolean bl3 = bl = it == this.ensureBuffer().position();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return n2;
        }

        @Override
        public void setPosition(int value2) {
            ByteBuffer buf = this.ensureBuffer();
            this.pos = value2;
            buf.position(value2);
        }

        @Override
        public int getInt() {
            ByteBuffer buf = this.ensureBuffer();
            this.pos += 4;
            return buf.getInt();
        }

        @Override
        public long getLong() {
            ByteBuffer buf = this.ensureBuffer();
            this.pos += 8;
            return buf.getLong();
        }

        private final ByteBuffer ensureBuffer() {
            ByteBuffer tmpBuffer = this.bufferRef.get();
            if (tmpBuffer == null) {
                tmpBuffer = LowLevelReadersKt.getBuffer(this.loadBytes.invoke());
                tmpBuffer.position(this.pos);
                this.bufferRef = new SoftReference<ByteBuffer>(tmpBuffer);
            }
            return tmpBuffer;
        }
    }
}

