/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.IrKotlinLibraryLayout;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.impl.DeclarationId;
import org.jetbrains.kotlin.library.impl.DeclarationIdMultiTableReader;
import org.jetbrains.kotlin.library.impl.IrArrayReader;
import org.jetbrains.kotlin.library.impl.IrLibraryAccess;
import org.jetbrains.kotlin.library.impl.IrLibraryImpl;
import org.jetbrains.kotlin.library.impl.IrMultiArrayReader;
import org.jetbrains.kotlin.library.impl.LowLevelReadersKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u0010\u0010\u000bJ\u0017\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u000bJ\u000f\u0010\u0012\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u000bJ!\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u000eJ\u001f\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u000eJ\u001f\u0010\u0017\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u000eJ\u001f\u0010\u0018\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u000eJ\u001f\u0010\u0019\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u000eJ\u001f\u0010\u001a\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u001a\u0010\u000eJ\u0017\u0010\u001b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u001b\u0010\u000bJ\u001f\u0010\u001c\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u001c\u0010\u000eJ\u0017\u0010\u001d\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u001d\u0010\u000bJ\u001f\u0010\u001e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u001e\u0010\u000eJ\u0017\u0010\u001f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u001f\u0010\u000bR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b!\u0010\"R\u001b\u0010\n\u001a\u00020#8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001b\u0010,\u001a\u00020(8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010%\u001a\u0004\b*\u0010+R\u001b\u0010/\u001a\u00020(8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010%\u001a\u0004\b.\u0010+R\u001d\u00102\u001a\u0004\u0018\u00010#8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010%\u001a\u0004\b1\u0010'R\u001d\u0010\u0014\u001a\u0004\u0018\u00010#8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010%\u001a\u0004\b4\u0010'R\u001b\u00109\u001a\u0002058BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010%\u001a\u0004\b7\u00108R\u001b\u0010>\u001a\u00020:8VX\u0097\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010%\u001a\u0004\b<\u0010=R\u001b\u0010A\u001a\u00020:8VX\u0097\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010%\u001a\u0004\b@\u0010=R\u001b\u0010\u001b\u001a\u00020#8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010%\u001a\u0004\bC\u0010'R\u001b\u0010\u001d\u001a\u00020#8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\bD\u0010%\u001a\u0004\bE\u0010'R\u001b\u0010\u001f\u001a\u00020#8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010%\u001a\u0004\bG\u0010'"}, d2={"Lorg/jetbrains/kotlin/library/impl/IrLibraryImpl;", "Lorg/jetbrains/kotlin/library/IrLibrary;", "Lorg/jetbrains/kotlin/library/impl/IrLibraryAccess;", "Lorg/jetbrains/kotlin/library/IrKotlinLibraryLayout;", "access", "<init>", "(Lorg/jetbrains/kotlin/library/impl/IrLibraryAccess;)V", "", "fileIndex", "", "bodies", "(I)[B", "index", "body", "(II)[B", "debugInfo", "declarations", "file", "fileCount", "()I", "fileEntries", "fileEntry", "irDeclaration", "irInlineDeclaration", "loadIrDeclaration", "loadIrInlineDeclaration", "signature", "signatures", "string", "strings", "type", "types", "Lorg/jetbrains/kotlin/library/impl/IrLibraryAccess;", "getAccess", "()Lorg/jetbrains/kotlin/library/impl/IrLibraryAccess;", "Lorg/jetbrains/kotlin/library/impl/IrMultiArrayReader;", "bodies$delegate", "Lkotlin/Lazy;", "getBodies", "()Lorg/jetbrains/kotlin/library/impl/IrMultiArrayReader;", "Lorg/jetbrains/kotlin/library/impl/DeclarationIdMultiTableReader;", "combinedDeclarations$delegate", "getCombinedDeclarations", "()Lorg/jetbrains/kotlin/library/impl/DeclarationIdMultiTableReader;", "combinedDeclarations", "combinedInlineDeclarations$delegate", "getCombinedInlineDeclarations", "combinedInlineDeclarations", "debugInfos$delegate", "getDebugInfos", "debugInfos", "fileEntries$delegate", "getFileEntries", "Lorg/jetbrains/kotlin/library/impl/IrArrayReader;", "files$delegate", "getFiles", "()Lorg/jetbrains/kotlin/library/impl/IrArrayReader;", "files", "", "hasFileEntriesTable$delegate", "getHasFileEntriesTable", "()Z", "hasFileEntriesTable", "hasIr$delegate", "getHasIr", "hasIr", "signatures$delegate", "getSignatures", "strings$delegate", "getStrings", "types$delegate", "getTypes"})
public final class IrLibraryImpl
implements IrLibrary {
    @NotNull
    private final IrLibraryAccess<IrKotlinLibraryLayout> access;
    @NotNull
    private final Lazy hasIr$delegate;
    @NotNull
    private final Lazy hasFileEntriesTable$delegate;
    @NotNull
    private final Lazy combinedDeclarations$delegate;
    @NotNull
    private final Lazy combinedInlineDeclarations$delegate;
    @NotNull
    private final Lazy types$delegate;
    @NotNull
    private final Lazy signatures$delegate;
    @NotNull
    private final Lazy strings$delegate;
    @NotNull
    private final Lazy bodies$delegate;
    @NotNull
    private final Lazy debugInfos$delegate;
    @NotNull
    private final Lazy fileEntries$delegate;
    @NotNull
    private final Lazy files$delegate;

    public IrLibraryImpl(@NotNull IrLibraryAccess<IrKotlinLibraryLayout> access) {
        Intrinsics.checkNotNullParameter(access, "access");
        this.access = access;
        this.hasIr$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                return (Boolean)this.this$0.getAccess().inPlace(hasIr.1.INSTANCE);
            }
        });
        this.hasFileEntriesTable$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                return (Boolean)this.this$0.getAccess().inPlace(hasFileEntriesTable.1.INSTANCE);
            }
        });
        this.combinedDeclarations$delegate = LazyKt.lazy((Function0)new Function0<DeclarationIdMultiTableReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DeclarationIdMultiTableReader invoke() {
                return LowLevelReadersKt.DeclarationIdMultiTableReader(this.this$0.getAccess(), combinedDeclarations.1.INSTANCE);
            }
        });
        this.combinedInlineDeclarations$delegate = LazyKt.lazy((Function0)new Function0<DeclarationIdMultiTableReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DeclarationIdMultiTableReader invoke() {
                return LowLevelReadersKt.DeclarationIdMultiTableReader(this.this$0.getAccess(), combinedInlineDeclarations.1.INSTANCE);
            }
        });
        this.types$delegate = LazyKt.lazy((Function0)new Function0<IrMultiArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrMultiArrayReader invoke() {
                return LowLevelReadersKt.IrMultiArrayReader(this.this$0.getAccess(), types.1.INSTANCE);
            }
        });
        this.signatures$delegate = LazyKt.lazy((Function0)new Function0<IrMultiArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrMultiArrayReader invoke() {
                return LowLevelReadersKt.IrMultiArrayReader(this.this$0.getAccess(), signatures.1.INSTANCE);
            }
        });
        this.strings$delegate = LazyKt.lazy((Function0)new Function0<IrMultiArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrMultiArrayReader invoke() {
                return LowLevelReadersKt.IrMultiArrayReader(this.this$0.getAccess(), strings.1.INSTANCE);
            }
        });
        this.bodies$delegate = LazyKt.lazy((Function0)new Function0<IrMultiArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrMultiArrayReader invoke() {
                return LowLevelReadersKt.IrMultiArrayReader(this.this$0.getAccess(), bodies.1.INSTANCE);
            }
        });
        this.debugInfos$delegate = LazyKt.lazy((Function0)new Function0<IrMultiArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrMultiArrayReader invoke() {
                return (Boolean)this.this$0.getAccess().inPlace(debugInfos.1.INSTANCE) != false ? LowLevelReadersKt.IrMultiArrayReader(this.this$0.getAccess(), debugInfos.2.INSTANCE) : null;
            }
        });
        this.fileEntries$delegate = LazyKt.lazy((Function0)new Function0<IrMultiArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrMultiArrayReader invoke() {
                return (Boolean)this.this$0.getAccess().inPlace(fileEntries.1.INSTANCE) != false ? LowLevelReadersKt.IrMultiArrayReader(this.this$0.getAccess(), fileEntries.2.INSTANCE) : null;
            }
        });
        this.files$delegate = LazyKt.lazy((Function0)new Function0<IrArrayReader>(this){
            final /* synthetic */ IrLibraryImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final IrArrayReader invoke() {
                return LowLevelReadersKt.IrArrayReader(this.this$0.getAccess(), files.1.INSTANCE);
            }
        });
    }

    @NotNull
    public final IrLibraryAccess<IrKotlinLibraryLayout> getAccess() {
        return this.access;
    }

    @Override
    public boolean getHasIr() {
        Lazy lazy = this.hasIr$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getHasFileEntriesTable() {
        Lazy lazy = this.hasFileEntriesTable$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public int fileCount() {
        return this.getFiles().entryCount();
    }

    @Override
    @NotNull
    public byte[] irDeclaration(int index2, int fileIndex) {
        return this.loadIrDeclaration(index2, fileIndex);
    }

    @Override
    @NotNull
    public byte[] irInlineDeclaration(int index2, int fileIndex) {
        return this.loadIrInlineDeclaration(index2, fileIndex);
    }

    @Override
    @NotNull
    public byte[] type(int index2, int fileIndex) {
        return this.getTypes().tableItemBytes(fileIndex, index2);
    }

    @Override
    @NotNull
    public byte[] signature(int index2, int fileIndex) {
        return this.getSignatures().tableItemBytes(fileIndex, index2);
    }

    @Override
    @NotNull
    public byte[] string(int index2, int fileIndex) {
        return this.getStrings().tableItemBytes(fileIndex, index2);
    }

    @Override
    @NotNull
    public byte[] body(int index2, int fileIndex) {
        return this.getBodies().tableItemBytes(fileIndex, index2);
    }

    @Override
    @Nullable
    public byte[] debugInfo(int index2, int fileIndex) {
        IrMultiArrayReader irMultiArrayReader = this.getDebugInfos();
        return irMultiArrayReader != null ? irMultiArrayReader.tableItemBytes(fileIndex, index2) : null;
    }

    @Override
    @Nullable
    public byte[] fileEntry(int index2, int fileIndex) {
        IrMultiArrayReader irMultiArrayReader = this.getFileEntries();
        return irMultiArrayReader != null ? irMultiArrayReader.tableItemBytes(fileIndex, index2) : null;
    }

    @Override
    @NotNull
    public byte[] file(int index2) {
        return this.getFiles().tableItemBytes(index2);
    }

    private final byte[] loadIrDeclaration(int index2, int fileIndex) {
        return this.getCombinedDeclarations().tableItemBytes(fileIndex, new DeclarationId(index2));
    }

    private final DeclarationIdMultiTableReader getCombinedDeclarations() {
        Lazy lazy = this.combinedDeclarations$delegate;
        return (DeclarationIdMultiTableReader)lazy.getValue();
    }

    private final byte[] loadIrInlineDeclaration(int index2, int fileIndex) {
        return this.getCombinedInlineDeclarations().tableItemBytes(fileIndex, new DeclarationId(index2));
    }

    private final DeclarationIdMultiTableReader getCombinedInlineDeclarations() {
        Lazy lazy = this.combinedInlineDeclarations$delegate;
        return (DeclarationIdMultiTableReader)lazy.getValue();
    }

    private final IrMultiArrayReader getTypes() {
        Lazy lazy = this.types$delegate;
        return (IrMultiArrayReader)lazy.getValue();
    }

    private final IrMultiArrayReader getSignatures() {
        Lazy lazy = this.signatures$delegate;
        return (IrMultiArrayReader)lazy.getValue();
    }

    private final IrMultiArrayReader getStrings() {
        Lazy lazy = this.strings$delegate;
        return (IrMultiArrayReader)lazy.getValue();
    }

    private final IrMultiArrayReader getBodies() {
        Lazy lazy = this.bodies$delegate;
        return (IrMultiArrayReader)lazy.getValue();
    }

    private final IrMultiArrayReader getDebugInfos() {
        Lazy lazy = this.debugInfos$delegate;
        return (IrMultiArrayReader)lazy.getValue();
    }

    private final IrMultiArrayReader getFileEntries() {
        Lazy lazy = this.fileEntries$delegate;
        return (IrMultiArrayReader)lazy.getValue();
    }

    private final IrArrayReader getFiles() {
        Lazy lazy = this.files$delegate;
        return (IrArrayReader)lazy.getValue();
    }

    @Override
    @NotNull
    public byte[] types(int fileIndex) {
        return this.getTypes().tableItemBytes(fileIndex);
    }

    @Override
    @NotNull
    public byte[] signatures(int fileIndex) {
        return this.getSignatures().tableItemBytes(fileIndex);
    }

    @Override
    @NotNull
    public byte[] strings(int fileIndex) {
        return this.getStrings().tableItemBytes(fileIndex);
    }

    @Override
    @NotNull
    public byte[] declarations(int fileIndex) {
        return this.getCombinedDeclarations().tableItemBytes(fileIndex);
    }

    @Override
    @NotNull
    public byte[] bodies(int fileIndex) {
        return this.getBodies().tableItemBytes(fileIndex);
    }

    @Override
    @Nullable
    public byte[] fileEntries(int fileIndex) {
        IrMultiArrayReader irMultiArrayReader = this.getFileEntries();
        return (byte[])(irMultiArrayReader != null ? irMultiArrayReader.tableItemBytes(fileIndex) : null);
    }
}

