/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.LenientUnresolvedLibrary;
import org.jetbrains.kotlin.library.RequiredUnresolvedLibrary;
import org.jetbrains.kotlin.library.SearchPathResolver;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u00004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a1\u0010\f\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\r\u001a-\u0010\u0012\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\u000e*\u00020\u0007*\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013\"\u0014\u0010\u0014\u001a\u00020\u00008\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\"\u0014\u0010\u0016\u001a\u00020\u00008\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015\"\u0014\u0010\u0017\u001a\u00020\u00008\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0015\"\u0014\u0010\u0018\u001a\u00020\u00008\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0015"}, d2={"", "path", "Lorg/jetbrains/kotlin/konan/file/File;", "validFileOrNull", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/konan/file/File;", "", "givenNames", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "resolvedLibraries", "Lorg/jetbrains/kotlin/util/Logger;", "logger", "", "validateNoLibrariesWerePassedViaCliByUniqueName", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/util/Logger;)V", "L", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "unresolved", "resolve", "(Lorg/jetbrains/kotlin/library/SearchPathResolver;Lorg/jetbrains/kotlin/library/UnresolvedLibrary;)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "KOTLINTEST_MODULE_NAME", "Ljava/lang/String;", "KOTLIN_JS_STDLIB_NAME", "KOTLIN_NATIVE_STDLIB_NAME", "KOTLIN_WASM_STDLIB_NAME"})
public final class SearchPathResolverKt {
    @NotNull
    public static final String KOTLIN_NATIVE_STDLIB_NAME = "stdlib";
    @NotNull
    public static final String KOTLIN_JS_STDLIB_NAME = "kotlin";
    @NotNull
    public static final String KOTLIN_WASM_STDLIB_NAME = "kotlin";
    @NotNull
    public static final String KOTLINTEST_MODULE_NAME = "kotlin-test";

    @Nullable
    public static final <L extends KotlinLibrary> L resolve(@NotNull SearchPathResolver<L> $this$resolve, @NotNull UnresolvedLibrary unresolved) {
        KotlinLibrary kotlinLibrary;
        Intrinsics.checkNotNullParameter($this$resolve, "<this>");
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        UnresolvedLibrary unresolvedLibrary = unresolved;
        if (unresolvedLibrary instanceof LenientUnresolvedLibrary) {
            kotlinLibrary = SearchPathResolver.resolve$default($this$resolve, (LenientUnresolvedLibrary)unresolved, false, 2, null);
        } else if (unresolvedLibrary instanceof RequiredUnresolvedLibrary) {
            kotlinLibrary = SearchPathResolver.resolve$default($this$resolve, (RequiredUnresolvedLibrary)unresolved, false, 2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (L)kotlinLibrary;
    }

    /*
     * WARNING - void declaration
     */
    public static final void validateNoLibrariesWerePassedViaCliByUniqueName(@NotNull List<String> givenNames, @NotNull List<? extends KotlinLibrary> resolvedLibraries, @NotNull Logger logger) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(givenNames, "givenNames");
        Intrinsics.checkNotNullParameter(resolvedLibraries, "resolvedLibraries");
        Intrinsics.checkNotNullParameter(logger, "logger");
        if (givenNames.isEmpty() || resolvedLibraries.isEmpty()) {
            return;
        }
        Iterable iterable = givenNames;
        Collection collection = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            String givenName = (String)element$iv;
            boolean bl = false;
            File given = SearchPathResolverKt.validFileOrNull(givenName);
            if (!(given == null || given.getNameSegments().size() == 1)) continue;
            collection.add(element$iv);
        }
        Set potentiallyUniqueNames = (Set)collection;
        if (potentiallyUniqueNames.isEmpty()) {
            return;
        }
        for (KotlinLibrary kotlinLibrary : resolvedLibraries) {
            String uniqueName = KotlinLibraryKt.getUniqueName(kotlinLibrary);
            if (!potentiallyUniqueNames.contains(uniqueName) || Intrinsics.areEqual(uniqueName, kotlinLibrary.getLibraryFile().getName())) continue;
            logger.error("KLIB resolver: Library '" + kotlinLibrary.getLibraryFile() + "' was found by its unique name '" + uniqueName + "'. This could happen if the library unique name was passed instead of the library path via the compiler CLI argument `-library` (`-l`). Note that using unique name is deprecated and will become unavailable in one of the future Kotlin releases. Please, specify full paths to libraries in compiler CLI arguments.");
        }
    }

    private static final File validFileOrNull(String path) {
        File file;
        try {
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "get(path)");
            file = new File(path2);
        }
        catch (InvalidPathException _) {
            file = null;
        }
        return file;
    }

    public static final /* synthetic */ File access$validFileOrNull(String path) {
        return SearchPathResolverKt.validFileOrNull(path);
    }
}

