/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinAbiVersionKt;
import org.jetbrains.kotlin.library.KotlinIrSignatureVersion;
import org.jetbrains.kotlin.library.KotlinIrSignatureVersionKt;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u0001*\u00060\u0002j\u0002`\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u0005*\u00060\u0002j\u0002`\u00032\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"readKonanLibraryVersioning", "Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;", "Ljava/util/Properties;", "Lorg/jetbrains/kotlin/konan/properties/Properties;", "writeKonanLibraryVersioning", "", "versions", "kotlin-util-klib"})
public final class KotlinLibraryVersioningKt {
    public static final void writeKonanLibraryVersioning(@NotNull Properties $this$writeKonanLibraryVersioning, @NotNull KotlinLibraryVersioning versions2) {
        Object it;
        Intrinsics.checkNotNullParameter($this$writeKonanLibraryVersioning, "<this>");
        Intrinsics.checkNotNullParameter(versions2, "versions");
        KotlinAbiVersion kotlinAbiVersion = versions2.getAbiVersion();
        if (kotlinAbiVersion != null) {
            it = kotlinAbiVersion;
            boolean bl = false;
            $this$writeKonanLibraryVersioning.setProperty("abi_version", ((KotlinAbiVersion)it).toString());
        }
        String string = versions2.getCompilerVersion();
        if (string != null) {
            it = string;
            boolean bl = false;
            $this$writeKonanLibraryVersioning.setProperty("compiler_version", (String)it);
        }
        MetadataVersion metadataVersion = versions2.getMetadataVersion();
        if (metadataVersion != null) {
            it = metadataVersion;
            boolean bl = false;
            $this$writeKonanLibraryVersioning.setProperty("metadata_version", ((BinaryVersion)it).toString());
        }
        $this$writeKonanLibraryVersioning.setProperty("ir_signature_versions", KotlinIrSignatureVersionKt.toManifestValue(versions2.getIrSignatureVersions()));
    }

    @NotNull
    public static final KotlinLibraryVersioning readKonanLibraryVersioning(@NotNull Properties $this$readKonanLibraryVersioning) {
        Set<KotlinIrSignatureVersion> set;
        Set<KotlinIrSignatureVersion> set2;
        MetadataVersion metadataVersion;
        Intrinsics.checkNotNullParameter($this$readKonanLibraryVersioning, "<this>");
        String string = $this$readKonanLibraryVersioning.getProperty("abi_version");
        KotlinAbiVersion abiVersion = string != null ? KotlinAbiVersionKt.parseKotlinAbiVersion(string) : null;
        String compilerVersion2 = $this$readKonanLibraryVersioning.getProperty("compiler_version");
        String string2 = $this$readKonanLibraryVersioning.getProperty("metadata_version");
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            int[] nArray = BinaryVersion.Companion.parseVersionArray(it);
            if (nArray != null) {
                int[] binaryVersion = nArray;
                boolean bl2 = false;
                metadataVersion = new MetadataVersion(Arrays.copyOf(binaryVersion, binaryVersion.length));
            } else {
                metadataVersion = null;
            }
        } else {
            metadataVersion = null;
        }
        MetadataVersion metadataVersion2 = metadataVersion;
        String string3 = $this$readKonanLibraryVersioning.getProperty("ir_signature_versions");
        if (string3 != null && (set2 = KotlinIrSignatureVersionKt.parseIrSignatureVersions(string3)) != null) {
            Set<KotlinIrSignatureVersion> set3;
            Set<KotlinIrSignatureVersion> it = set3 = set2;
            boolean bl = false;
            if (!(!((Collection)it).isEmpty())) {
                boolean bl3 = false;
                String string4 = "Malformed manifest: Empty set of IR signature versions";
                throw new IllegalStateException(string4.toString());
            }
            set = set3;
        } else {
            set = SetsKt.setOf(KotlinIrSignatureVersion.Companion.getV1());
        }
        Set<KotlinIrSignatureVersion> irSignatureVersions = set;
        return new KotlinLibraryVersioning(compilerVersion2, abiVersion, metadataVersion2, irSignatureVersions);
    }
}

