/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinIrSignatureVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u00c7\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u00c7\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c7\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014JD\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c7\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0002H\u00d7\u0001\u00a2\u0006\u0004\b\u001e\u0010\u000eR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010\u0010R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u000eR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010#\u001a\u0004\b$\u0010\u0014R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;", "", "", "compilerVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "abiVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "metadataVersion", "", "Lorg/jetbrains/kotlin/library/KotlinIrSignatureVersion;", "irSignatureVersions", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/library/KotlinAbiVersion;Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;Ljava/util/Set;)V", "component1", "()Ljava/lang/String;", "component2", "()Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "component3", "()Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "component4", "()Ljava/util/Set;", "copy", "(Ljava/lang/String;Lorg/jetbrains/kotlin/library/KotlinAbiVersion;Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;Ljava/util/Set;)Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "getAbiVersion", "Ljava/lang/String;", "getCompilerVersion", "Ljava/util/Set;", "getIrSignatureVersions", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "getMetadataVersion"})
public final class KotlinLibraryVersioning {
    @Nullable
    private final String compilerVersion;
    @Nullable
    private final KotlinAbiVersion abiVersion;
    @Nullable
    private final MetadataVersion metadataVersion;
    @NotNull
    private final Set<KotlinIrSignatureVersion> irSignatureVersions;

    public KotlinLibraryVersioning(@Nullable String compilerVersion2, @Nullable KotlinAbiVersion abiVersion, @Nullable MetadataVersion metadataVersion, @NotNull Set<KotlinIrSignatureVersion> irSignatureVersions) {
        Intrinsics.checkNotNullParameter(irSignatureVersions, "irSignatureVersions");
        this.compilerVersion = compilerVersion2;
        this.abiVersion = abiVersion;
        this.metadataVersion = metadataVersion;
        this.irSignatureVersions = irSignatureVersions;
        if (!(!((Collection)this.irSignatureVersions).isEmpty())) {
            boolean bl = false;
            String string = "Signature versions must not be empty!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ KotlinLibraryVersioning(String string, KotlinAbiVersion kotlinAbiVersion, MetadataVersion metadataVersion, Set set, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            set = KotlinIrSignatureVersion.Companion.getCURRENTLY_SUPPORTED_VERSIONS();
        }
        this(string, kotlinAbiVersion, metadataVersion, set);
    }

    @Nullable
    public final String getCompilerVersion() {
        return this.compilerVersion;
    }

    @Nullable
    public final KotlinAbiVersion getAbiVersion() {
        return this.abiVersion;
    }

    @Nullable
    public final MetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @NotNull
    public final Set<KotlinIrSignatureVersion> getIrSignatureVersions() {
        return this.irSignatureVersions;
    }

    @Nullable
    public final String component1() {
        return this.compilerVersion;
    }

    @Nullable
    public final KotlinAbiVersion component2() {
        return this.abiVersion;
    }

    @Nullable
    public final MetadataVersion component3() {
        return this.metadataVersion;
    }

    @NotNull
    public final Set<KotlinIrSignatureVersion> component4() {
        return this.irSignatureVersions;
    }

    @NotNull
    public final KotlinLibraryVersioning copy(@Nullable String compilerVersion2, @Nullable KotlinAbiVersion abiVersion, @Nullable MetadataVersion metadataVersion, @NotNull Set<KotlinIrSignatureVersion> irSignatureVersions) {
        Intrinsics.checkNotNullParameter(irSignatureVersions, "irSignatureVersions");
        return new KotlinLibraryVersioning(compilerVersion2, abiVersion, metadataVersion, irSignatureVersions);
    }

    public static /* synthetic */ KotlinLibraryVersioning copy$default(KotlinLibraryVersioning kotlinLibraryVersioning, String string, KotlinAbiVersion kotlinAbiVersion, MetadataVersion metadataVersion, Set set, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = kotlinLibraryVersioning.compilerVersion;
        }
        if ((n2 & 2) != 0) {
            kotlinAbiVersion = kotlinLibraryVersioning.abiVersion;
        }
        if ((n2 & 4) != 0) {
            metadataVersion = kotlinLibraryVersioning.metadataVersion;
        }
        if ((n2 & 8) != 0) {
            set = kotlinLibraryVersioning.irSignatureVersions;
        }
        return kotlinLibraryVersioning.copy(string, kotlinAbiVersion, metadataVersion, set);
    }

    @NotNull
    public String toString() {
        return "KotlinLibraryVersioning(compilerVersion=" + this.compilerVersion + ", abiVersion=" + this.abiVersion + ", metadataVersion=" + this.metadataVersion + ", irSignatureVersions=" + this.irSignatureVersions + ')';
    }

    public int hashCode() {
        int result2 = this.compilerVersion == null ? 0 : this.compilerVersion.hashCode();
        result2 = result2 * 31 + (this.abiVersion == null ? 0 : this.abiVersion.hashCode());
        result2 = result2 * 31 + (this.metadataVersion == null ? 0 : this.metadataVersion.hashCode());
        result2 = result2 * 31 + ((Object)this.irSignatureVersions).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KotlinLibraryVersioning)) {
            return false;
        }
        KotlinLibraryVersioning kotlinLibraryVersioning = (KotlinLibraryVersioning)other;
        if (!Intrinsics.areEqual(this.compilerVersion, kotlinLibraryVersioning.compilerVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.abiVersion, kotlinLibraryVersioning.abiVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.metadataVersion, kotlinLibraryVersioning.metadataVersion)) {
            return false;
        }
        return Intrinsics.areEqual(this.irSignatureVersions, kotlinLibraryVersioning.irSignatureVersions);
    }
}

