/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibrarySearchPathResolver;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u00032\b\u0012\u0004\u0012\u00028\u00000\u0004BW\b\u0017\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0010\u0010\u0011B=\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0010\u0010\u0012J\u001f\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/library/KotlinLibraryProperResolverWithAttributes;", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "L", "Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver;", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "", "", "repositories", "directLibs", "distributionKlib", "localKotlinDir", "", "skipCurrentDir", "Lorg/jetbrains/kotlin/util/Logger;", "logger", "knownIrProviders", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/kotlin/util/Logger;Ljava/util/List;)V", "(Ljava/util/List;Ljava/lang/String;ZLorg/jetbrains/kotlin/util/Logger;Ljava/util/List;)V", "candidate", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "unresolved", "libraryMatch", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;Lorg/jetbrains/kotlin/library/UnresolvedLibrary;)Z", "Ljava/util/List;"})
public abstract class KotlinLibraryProperResolverWithAttributes<L extends KotlinLibrary>
extends KotlinLibrarySearchPathResolver<L> {
    @NotNull
    private final List<String> knownIrProviders;

    public KotlinLibraryProperResolverWithAttributes(@NotNull List<String> directLibs, @Nullable String distributionKlib, boolean skipCurrentDir, @NotNull Logger logger, @NotNull List<String> knownIrProviders) {
        Intrinsics.checkNotNullParameter(directLibs, "directLibs");
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(knownIrProviders, "knownIrProviders");
        super(directLibs, distributionKlib, skipCurrentDir, logger);
        this.knownIrProviders = knownIrProviders;
    }

    @Deprecated(message="Please use the KotlinLibraryProperResolverWithAttributes constructor which does not has 'repositories' and 'localKotlinDir' value parameters", replaceWith=@ReplaceWith(expression="KotlinLibraryProperResolverWithAttributes<L>(directLibs, distributionKlib, skipCurrentDir, logger, knownIrProviders)", imports={}), level=DeprecationLevel.ERROR)
    public KotlinLibraryProperResolverWithAttributes(@NotNull List<String> repositories, @NotNull List<String> directLibs, @Nullable String distributionKlib, @Nullable String localKotlinDir, boolean skipCurrentDir, @NotNull Logger logger, @NotNull List<String> knownIrProviders) {
        Intrinsics.checkNotNullParameter(repositories, "repositories");
        Intrinsics.checkNotNullParameter(directLibs, "directLibs");
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(knownIrProviders, "knownIrProviders");
        this(directLibs, distributionKlib, skipCurrentDir, logger, knownIrProviders);
    }

    @Override
    public boolean libraryMatch(@NotNull L candidate, @NotNull UnresolvedLibrary unresolved) {
        KotlinAbiVersion candidateAbiVersion;
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        String candidatePath = candidate.getLibraryFile().getAbsolutePath();
        String candidateCompilerVersion = candidate.getVersions().getCompilerVersion();
        KotlinAbiVersion kotlinAbiVersion = candidateAbiVersion = candidate.getVersions().getAbiVersion();
        if (!(kotlinAbiVersion != null ? kotlinAbiVersion.isCompatible() : false) && KotlinLibraryKt.getHasAbi(candidate)) {
            this.getLogger().strongWarning("KLIB resolver: Skipping '" + candidatePath + "' having incompatible ABI version '" + candidateAbiVersion + "'. The library was produced by '" + candidateCompilerVersion + "' compiler.\nThe current Kotlin compiler can consume libraries having ABI version <= '" + KotlinAbiVersion.Companion.getCURRENT() + "'.\nPlease upgrade your Kotlin compiler version to consume this library.");
            return false;
        }
        String string = KotlinLibraryKt.getIrProviderName((BaseKotlinLibrary)candidate);
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (!this.knownIrProviders.contains(it)) {
                this.getLogger().strongWarning("KLIB resolver: Skipping '" + candidatePath + "'. The library requires unknown IR provider: " + it);
                return false;
            }
        }
        return true;
    }
}

