/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.target;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.TargetManager;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\b8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0016\u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/konan/target/TargetManagerImpl;", "Lorg/jetbrains/kotlin/konan/target/TargetManager;", "", "userRequest", "Lorg/jetbrains/kotlin/konan/target/HostManager;", "hostManager", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/konan/target/HostManager;)V", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "determineCurrent", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "", "list", "()V", "Lorg/jetbrains/kotlin/konan/target/HostManager;", "getHostManager", "()Lorg/jetbrains/kotlin/konan/target/HostManager;", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getTarget", "getTargetName", "()Ljava/lang/String;", "targetName", "Ljava/lang/String;", "getUserRequest"})
public final class TargetManagerImpl
implements TargetManager {
    @Nullable
    private final String userRequest;
    @NotNull
    private final HostManager hostManager;
    @NotNull
    private final KonanTarget target;

    public TargetManagerImpl(@Nullable String userRequest, @NotNull HostManager hostManager) {
        Intrinsics.checkNotNullParameter(hostManager, "hostManager");
        this.userRequest = userRequest;
        this.hostManager = hostManager;
        this.target = this.determineCurrent();
    }

    @Nullable
    public final String getUserRequest() {
        return this.userRequest;
    }

    @NotNull
    public final HostManager getHostManager() {
        return this.hostManager;
    }

    @Override
    @NotNull
    public KonanTarget getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public String getTargetName() {
        return this.getTarget().getVisibleName();
    }

    @Override
    public void list() {
        Iterable $this$forEach$iv = this.hostManager.getEnabled();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KonanTarget it = (KonanTarget)element$iv;
            boolean bl = false;
            String isDefault = Intrinsics.areEqual(it, this.getTarget()) ? " (default)" : "";
            String isDeprecated = CollectionsKt.contains((Iterable)KonanTarget.Companion.getDeprecatedTargets(), it) ? " (deprecated)" : "";
            System.out.println((Object)(it.getVisibleName() + isDefault + isDeprecated));
        }
    }

    private final KonanTarget determineCurrent() {
        KonanTarget konanTarget;
        if (this.userRequest == null || Intrinsics.areEqual(this.userRequest, "host")) {
            konanTarget = HostManager.Companion.getHost();
        } else {
            String resolvedAlias = HostManager.Companion.resolveAlias(this.userRequest);
            konanTarget = MapsKt.getValue(this.hostManager.getTargets(), this.hostManager.known(resolvedAlias));
        }
        return konanTarget;
    }
}

