/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.target;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.Distribution;
import org.jetbrains.kotlin.konan.target.Family;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.SubTargetProvider;
import org.jetbrains.kotlin.konan.target.TargetManager;
import org.jetbrains.kotlin.konan.target.TargetManagerImpl;
import org.jetbrains.kotlin.konan.target.TargetSupportException;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u000b\b\u0016\u0018\u0000 12\u00020\u0001:\u00011B\u001d\b\u0017\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001b\b\u0017\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\nB\u0007\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0018\u001a\u00020\u00172\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J#\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u001f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u001f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010!R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u001c8G\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R,\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001f0&8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R!\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0\u001c8GX\u0087\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010$R&\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0&8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b/\u0010(\u001a\u0004\b0\u0010*"}, d2={"Lorg/jetbrains/kotlin/konan/target/HostManager;", "", "Lorg/jetbrains/kotlin/konan/target/SubTargetProvider;", "subTargetProvider", "", "experimental", "<init>", "(Lorg/jetbrains/kotlin/konan/target/SubTargetProvider;Z)V", "Lorg/jetbrains/kotlin/konan/target/Distribution;", "distribution", "(Lorg/jetbrains/kotlin/konan/target/Distribution;Z)V", "()V", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "target", "isEnabled", "(Lorg/jetbrains/kotlin/konan/target/KonanTarget;)Z", "", "name", "known", "(Ljava/lang/String;)Ljava/lang/String;", "targetByName", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "userRequest", "Lorg/jetbrains/kotlin/konan/target/TargetManager;", "targetManager", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/konan/target/TargetManager;", "", "names", "", "toKonanTargets", "(Ljava/lang/Iterable;)Ljava/util/List;", "", "appleTargets", "Ljava/util/Set;", "commonTargets", "getEnabled", "()Ljava/util/List;", "enabled", "", "enabledByHost", "Ljava/util/Map;", "getEnabledByHost", "()Ljava/util/Map;", "targetValues$delegate", "Lkotlin/Lazy;", "getTargetValues", "targetValues", "targets", "getTargets", "Companion"})
public class HostManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy targetValues$delegate;
    @NotNull
    private final Map<String, KonanTarget> targets;
    @NotNull
    private final Set<KonanTarget> commonTargets;
    @NotNull
    private final Set<KonanTarget> appleTargets;
    @NotNull
    private final Map<KonanTarget, Set<KonanTarget>> enabledByHost;
    @NotNull
    private static final Map<Pair<String, String>, KonanTarget> hostMapping;
    @NotNull
    private static final List<String> defaultJvmArgs;
    @NotNull
    private static final List<String> regularJvmArgs;
    @NotNull
    private static final Map<String, String> targetAliasResolutions;
    @NotNull
    private static final Lazy<Map<String, List<String>>> targetAliases$delegate;

    /*
     * WARNING - void declaration
     */
    public HostManager() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        this.targetValues$delegate = LazyKt.lazy(targetValues.2.INSTANCE);
        Serializable[] serializableArray = (KonanTarget[])this.getTargetValues();
        HostManager hostManager = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        void var4_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KonanTarget konanTarget = (KonanTarget)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getVisibleName(), element$iv$iv);
        }
        hostManager.targets = destination$iv$iv;
        serializableArray = new KonanTarget[]{KonanTarget.LINUX_X64.INSTANCE, KonanTarget.LINUX_ARM32_HFP.INSTANCE, KonanTarget.LINUX_ARM64.INSTANCE, KonanTarget.MINGW_X64.INSTANCE, KonanTarget.ANDROID_X86.INSTANCE, KonanTarget.ANDROID_X64.INSTANCE, KonanTarget.ANDROID_ARM32.INSTANCE, KonanTarget.ANDROID_ARM64.INSTANCE};
        this.commonTargets = SetsKt.setOf(serializableArray);
        serializableArray = new KonanTarget[]{KonanTarget.MACOS_X64.INSTANCE, KonanTarget.MACOS_ARM64.INSTANCE, KonanTarget.IOS_ARM64.INSTANCE, KonanTarget.IOS_X64.INSTANCE, KonanTarget.IOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.WATCHOS_ARM32.INSTANCE, KonanTarget.WATCHOS_ARM64.INSTANCE, KonanTarget.WATCHOS_X64.INSTANCE, KonanTarget.WATCHOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.WATCHOS_DEVICE_ARM64.INSTANCE, KonanTarget.TVOS_ARM64.INSTANCE, KonanTarget.TVOS_X64.INSTANCE, KonanTarget.TVOS_SIMULATOR_ARM64.INSTANCE};
        this.appleTargets = SetsKt.setOf(serializableArray);
        serializableArray = new Pair[]{TuplesKt.to(KonanTarget.LINUX_X64.INSTANCE, this.commonTargets), TuplesKt.to(KonanTarget.MINGW_X64.INSTANCE, this.commonTargets), TuplesKt.to(KonanTarget.MACOS_X64.INSTANCE, SetsKt.plus(this.commonTargets, (Iterable)this.appleTargets)), TuplesKt.to(KonanTarget.MACOS_ARM64.INSTANCE, SetsKt.plus(this.commonTargets, (Iterable)this.appleTargets))};
        this.enabledByHost = MapsKt.mapOf(serializableArray);
    }

    @NotNull
    public final TargetManager targetManager(@Nullable String userRequest) {
        return new TargetManagerImpl(userRequest, this);
    }

    public static /* synthetic */ TargetManager targetManager$default(HostManager hostManager, String string, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: targetManager");
        }
        if ((n2 & 1) != 0) {
            string = null;
        }
        return hostManager.targetManager(string);
    }

    @Deprecated(message="Kept for binary compatibility of Gradle plugins", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ HostManager(SubTargetProvider subTargetProvider, boolean experimental) {
        Intrinsics.checkNotNullParameter(subTargetProvider, "subTargetProvider");
        this();
    }

    public /* synthetic */ HostManager(SubTargetProvider subTargetProvider, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            subTargetProvider = SubTargetProvider.NoSubTargets.INSTANCE;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(subTargetProvider, bl);
    }

    @Deprecated(message="Kept for binary compatibility of Gradle plugins", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ HostManager(Distribution distribution, boolean experimental) {
        Intrinsics.checkNotNullParameter(distribution, "distribution");
        this();
    }

    public /* synthetic */ HostManager(Distribution distribution, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(distribution, bl);
    }

    @NotNull
    public final List<KonanTarget> getTargetValues() {
        Lazy lazy = this.targetValues$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Map<String, KonanTarget> getTargets() {
        return this.targets;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KonanTarget> toKonanTargets(@NotNull Iterable<String> names) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(names, "names");
        Iterable<String> $this$map$iv = names;
        boolean $i$f$map = false;
        Iterable<String> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Intrinsics.areEqual(it, "host") ? Companion.getHost() : MapsKt.getValue(this.targets, this.known(Companion.resolveAlias((String)it))));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String known(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (this.targets.get(name) == null) {
            throw new TargetSupportException("Unknown target: " + name + ". Use -list_targets to see the list of available targets", null, 2, null);
        }
        return name;
    }

    @NotNull
    public final KonanTarget targetByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (Intrinsics.areEqual(name, "host")) {
            return Companion.getHost();
        }
        KonanTarget konanTarget = this.targets.get(Companion.resolveAlias(name));
        if (konanTarget == null) {
            throw new TargetSupportException("Unknown target name: " + name, null, 2, null);
        }
        return konanTarget;
    }

    @NotNull
    public final Map<KonanTarget, Set<KonanTarget>> getEnabledByHost() {
        return this.enabledByHost;
    }

    @NotNull
    public final List<KonanTarget> getEnabled() {
        Collection<KonanTarget> collection = this.enabledByHost.get(Companion.getHost());
        if (collection == null || (collection = CollectionsKt.toList((Iterable)collection)) == null) {
            throw new TargetSupportException("Unknown host platform: " + Companion.getHost(), null, 2, null);
        }
        return collection;
    }

    public final boolean isEnabled(@NotNull KonanTarget target) {
        Intrinsics.checkNotNullParameter(target, "target");
        return this.getEnabled().contains(target);
    }

    @NotNull
    public static final String simpleOsName() {
        return Companion.simpleOsName();
    }

    @NotNull
    public static final String platformName() {
        return Companion.platformName();
    }

    @NotNull
    public static final KonanTarget getHost() {
        return Companion.getHost();
    }

    public static final boolean getHostIsMac() {
        return Companion.getHostIsMac();
    }

    public static final boolean getHostIsLinux() {
        return Companion.getHostIsLinux();
    }

    public static final boolean getHostIsMingw() {
        return Companion.getHostIsMingw();
    }

    @NotNull
    public static final String getHostName() {
        return Companion.getHostName();
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to(new Pair<String, String>("osx", "x86_64"), KonanTarget.MACOS_X64.INSTANCE), TuplesKt.to(new Pair<String, String>("osx", "aarch64"), KonanTarget.MACOS_ARM64.INSTANCE), TuplesKt.to(new Pair<String, String>("linux", "x86_64"), KonanTarget.LINUX_X64.INSTANCE), TuplesKt.to(new Pair<String, String>("windows", "x86_64"), KonanTarget.MINGW_X64.INSTANCE)};
        hostMapping = MapsKt.mapOf(objectArray);
        objectArray = new String[]{"-XX:TieredStopAtLevel=1", "-ea", "-Dfile.encoding=UTF-8"};
        defaultJvmArgs = CollectionsKt.listOf(objectArray);
        regularJvmArgs = CollectionsKt.plus((Collection)defaultJvmArgs, "-Xmx3G");
        objectArray = new Pair[]{TuplesKt.to("linux", "linux_x64"), TuplesKt.to("macbook", "macos_x64"), TuplesKt.to("macos", "macos_x64"), TuplesKt.to("imac", "macos_x64"), TuplesKt.to("raspberrypi", "linux_arm32_hfp"), TuplesKt.to("iphone32", "ios_arm32"), TuplesKt.to("iphone", "ios_arm64"), TuplesKt.to("ipad", "ios_arm64"), TuplesKt.to("ios", "ios_arm64"), TuplesKt.to("iphone_sim", "ios_x64"), TuplesKt.to("mingw", "mingw_x64")};
        targetAliasResolutions = MapsKt.mapOf(objectArray);
        targetAliases$delegate = LazyKt.lazy(Companion.targetAliases.2.INSTANCE);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\f\u0010\u000bJ\u000f\u0010\r\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\r\u0010\u000bJ\u000f\u0010\u000e\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000bJ\u000f\u0010\u000f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u000bJ\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0010\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u000bJ\u0017\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u000bR \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00118\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010 \u001a\u00020\u00078G\u00a2\u0006\f\u0012\u0004\b\u001f\u0010\u0003\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010%\u001a\u00020!8F\u00a2\u0006\f\u0012\u0004\b$\u0010\u0003\u001a\u0004\b\"\u0010#R\u0017\u0010(\u001a\u00020!8F\u00a2\u0006\f\u0012\u0004\b'\u0010\u0003\u001a\u0004\b&\u0010#R\u0017\u0010+\u001a\u00020!8F\u00a2\u0006\f\u0012\u0004\b*\u0010\u0003\u001a\u0004\b)\u0010#R,\u0010.\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040-\u0012\u0004\u0012\u00020\u00070,8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0017\u00102\u001a\u00020\u00048G\u00a2\u0006\f\u0012\u0004\b1\u0010\u0003\u001a\u0004\b0\u0010\u000bR\u0013\u00104\u001a\u0004\u0018\u00010\u00078G\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u001eR\u0011\u00106\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u000bR \u00107\u001a\b\u0012\u0004\u0012\u00020\u00040\u00118\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b7\u0010\u001a\u001a\u0004\b8\u0010\u001cR \u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040,8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010/R-\u0010>\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00110,8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010="}, d2={"Lorg/jetbrains/kotlin/konan/target/HostManager$Companion;", "", "<init>", "()V", "", "os", "arch", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "determineHost", "(Ljava/lang/String;Ljava/lang/String;)Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "hostArch", "()Ljava/lang/String;", "hostArchOrNull", "hostOs", "host_arch", "host_os", "target", "", "listAliases", "(Ljava/lang/String;)Ljava/util/List;", "platformName", "request", "resolveAlias", "(Ljava/lang/String;)Ljava/lang/String;", "simpleOsName", "defaultJvmArgs", "Ljava/util/List;", "getDefaultJvmArgs", "()Ljava/util/List;", "getHost", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getHost$annotations", "host", "", "getHostIsLinux", "()Z", "getHostIsLinux$annotations", "hostIsLinux", "getHostIsMac", "getHostIsMac$annotations", "hostIsMac", "getHostIsMingw", "getHostIsMingw$annotations", "hostIsMingw", "", "Lkotlin/Pair;", "hostMapping", "Ljava/util/Map;", "getHostName", "getHostName$annotations", "hostName", "getHostOrNull", "hostOrNull", "getJniHostPlatformIncludeDir", "jniHostPlatformIncludeDir", "regularJvmArgs", "getRegularJvmArgs", "targetAliasResolutions", "targetAliases$delegate", "Lkotlin/Lazy;", "getTargetAliases", "()Ljava/util/Map;", "targetAliases"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use `hostOs` instead", replaceWith=@ReplaceWith(expression="HostManager.hostOs()", imports={}))
        @NotNull
        public final String host_os() {
            return this.hostOs();
        }

        @NotNull
        public final String hostOs() {
            String string;
            String javaOsName = System.getProperty("os.name");
            if (Intrinsics.areEqual(javaOsName, "Mac OS X")) {
                string = "osx";
            } else if (Intrinsics.areEqual(javaOsName, "Linux")) {
                string = "linux";
            } else {
                Intrinsics.checkNotNullExpressionValue(javaOsName, "javaOsName");
                if (StringsKt.startsWith$default(javaOsName, "Windows", false, 2, null)) {
                    string = "windows";
                } else {
                    throw new TargetSupportException("Unknown operating system: " + javaOsName, null, 2, null);
                }
            }
            return string;
        }

        @NotNull
        public final String simpleOsName() {
            String hostOs = this.hostOs();
            return Intrinsics.areEqual(hostOs, "osx") ? "macos" : hostOs;
        }

        @NotNull
        public final String platformName() {
            String hostOs = this.hostOs();
            String arch = this.hostArch();
            return Intrinsics.areEqual(hostOs, "osx") ? "macos-" + arch : hostOs + '-' + arch;
        }

        @NotNull
        public final String getJniHostPlatformIncludeDir() {
            String string;
            KonanTarget konanTarget = this.getHost();
            if (Intrinsics.areEqual(konanTarget, KonanTarget.MACOS_X64.INSTANCE) ? true : Intrinsics.areEqual(konanTarget, KonanTarget.MACOS_ARM64.INSTANCE)) {
                string = "darwin";
            } else if (Intrinsics.areEqual(konanTarget, KonanTarget.LINUX_X64.INSTANCE)) {
                string = "linux";
            } else if (Intrinsics.areEqual(konanTarget, KonanTarget.MINGW_X64.INSTANCE)) {
                string = "win32";
            } else {
                throw new TargetSupportException("Unknown host: " + this.getHost() + '.', null, 2, null);
            }
            return string;
        }

        @Deprecated(message="Use `hostArch` instead", replaceWith=@ReplaceWith(expression="HostManager.hostArch()", imports={}))
        @NotNull
        public final String host_arch() {
            return this.hostArch();
        }

        @NotNull
        public final String hostArch() {
            String string = this.hostArchOrNull();
            if (string == null) {
                throw new TargetSupportException("Unknown hardware platform: " + System.getProperty("os.arch"), null, 2, null);
            }
            return string;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final String hostArchOrNull() {
            String string = System.getProperty("os.arch");
            if (string == null) return null;
            int n2 = -1;
            switch (string.hashCode()) {
                case -1221096139: {
                    if (string.equals("aarch64")) {
                        n2 = 1;
                    }
                    break;
                }
                case -806050265: {
                    if (string.equals("x86_64")) {
                        n2 = 2;
                    }
                    break;
                }
                case 93084186: {
                    if (string.equals("arm64")) {
                        n2 = 3;
                    }
                    break;
                }
                case 92926582: {
                    if (string.equals("amd64")) {
                        n2 = 4;
                    }
                    break;
                }
            }
            switch (n2) {
                case 2: {
                    return "x86_64";
                }
                case 4: {
                    return "x86_64";
                }
                case 3: {
                    return "aarch64";
                }
                case 1: {
                    return "aarch64";
                }
                default: {
                    return null;
                }
            }
        }

        @NotNull
        public final KonanTarget getHost() {
            return this.determineHost(this.hostOs(), this.hostArchOrNull());
        }

        public static /* synthetic */ void getHost$annotations() {
        }

        @Nullable
        public final KonanTarget getHostOrNull() {
            KonanTarget konanTarget;
            try {
                konanTarget = this.getHost();
            }
            catch (TargetSupportException _) {
                konanTarget = null;
            }
            return konanTarget;
        }

        private final KonanTarget determineHost(String os, String arch) {
            Object v0;
            Object object;
            block3: {
                object = (KonanTarget)hostMapping.get(TuplesKt.to(os, arch));
                if (object != null) {
                    KonanTarget it = object;
                    boolean bl = false;
                    return it;
                }
                Iterable $this$firstOrNull$iv = hostMapping.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    Pair host = (Pair)entry.getKey();
                    if (!Intrinsics.areEqual(host.getFirst(), os)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            object = v0;
            if (object != null) {
                Object it = object;
                boolean bl = false;
                return (KonanTarget)it.getValue();
            }
            throw new TargetSupportException("Unknown host target: " + os + ' ' + arch, null, 2, null);
        }

        @NotNull
        public final List<String> getDefaultJvmArgs() {
            return defaultJvmArgs;
        }

        @NotNull
        public final List<String> getRegularJvmArgs() {
            return regularJvmArgs;
        }

        public final boolean getHostIsMac() {
            KonanTarget konanTarget = this.getHostOrNull();
            return (konanTarget != null ? konanTarget.getFamily() : null) == Family.OSX;
        }

        public static /* synthetic */ void getHostIsMac$annotations() {
        }

        public final boolean getHostIsLinux() {
            KonanTarget konanTarget = this.getHostOrNull();
            return (konanTarget != null ? konanTarget.getFamily() : null) == Family.LINUX;
        }

        public static /* synthetic */ void getHostIsLinux$annotations() {
        }

        public final boolean getHostIsMingw() {
            KonanTarget konanTarget = this.getHostOrNull();
            return (konanTarget != null ? konanTarget.getFamily() : null) == Family.MINGW;
        }

        public static /* synthetic */ void getHostIsMingw$annotations() {
        }

        @NotNull
        public final String getHostName() {
            return this.getHost().getName();
        }

        public static /* synthetic */ void getHostName$annotations() {
        }

        private final Map<String, List<String>> getTargetAliases() {
            Lazy lazy = targetAliases$delegate;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final String resolveAlias(@NotNull String request) {
            Intrinsics.checkNotNullParameter(request, "request");
            String string = (String)targetAliasResolutions.get(request);
            if (string == null) {
                string = request;
            }
            return string;
        }

        @NotNull
        public final List<String> listAliases(@NotNull String target) {
            Intrinsics.checkNotNullParameter(target, "target");
            List<String> list = this.getTargetAliases().get(target);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

