/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElement;

public final class JsRuntimeAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final JsRuntimeAnnotationChecker INSTANCE = new JsRuntimeAnnotationChecker();

    private JsRuntimeAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        for (AnnotationDescriptor annotation : descriptor2.getAnnotations()) {
            Object annotationPsi;
            ClassDescriptor annotationClass;
            if (DescriptorUtilsKt.getAnnotationClass(annotation) == null || DescriptorUtilsKt.getAnnotationRetention(annotationClass) != KotlinRetention.RUNTIME) continue;
            SourceElement sourceElement = annotation.getSource();
            Object object = sourceElement instanceof PsiSourceElement ? (PsiSourceElement)sourceElement : null;
            if (object == null || (object = object.getPsi()) == null) {
                object = annotationPsi = (PsiElement)declaration;
            }
            if (descriptor2 instanceof MemberDescriptor && DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2)) {
                context.getTrace().report(ErrorsJs.RUNTIME_ANNOTATION_ON_EXTERNAL_DECLARATION.on((PsiElement)annotationPsi));
                continue;
            }
            context.getTrace().report(ErrorsJs.RUNTIME_ANNOTATION_NOT_SUPPORTED.on((PsiElement)annotationPsi));
        }
    }
}

