/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

public final class JsReifiedNativeChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        KtTypeArgumentList ktTypeArgumentList = resolvedCall2.getCall().getTypeArgumentList();
        List<KtTypeProjection> typeArgumentList = ktTypeArgumentList != null ? ktTypeArgumentList.getArguments() : null;
        Map<TypeParameterDescriptor, KotlinType> map2 = resolvedCall2.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue(map2, "getTypeArguments(...)");
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : map2.entrySet()) {
            ClassifierDescriptor typeArgDescriptor;
            TypeParameterDescriptor typeParam = entry.getKey();
            KotlinType typeArg = entry.getValue();
            if (!typeParam.isReified() || (typeArgDescriptor = typeArg.getConstructor().getDeclarationDescriptor()) == null || !AnnotationsUtils.isNativeInterface(typeArgDescriptor)) continue;
            KtElement typeArgumentPsi = typeArgumentList != null ? (KtElement)typeArgumentList.get(typeParam.getIndex()).getTypeReference() : resolvedCall2.getCall().getCallElement();
            BindingTrace bindingTrace = context.getTrace();
            KtElement ktElement = typeArgumentPsi;
            Intrinsics.checkNotNull(ktElement);
            bindingTrace.report(ErrorsJs.EXTERNAL_INTERFACE_AS_REIFIED_TYPE_ARGUMENT.on(ktElement, typeArg));
        }
    }
}

