/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.checkers.AbstractReflectionApiCallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

public final class JsReflectionAPICallChecker
extends AbstractReflectionApiCallChecker {
    @Override
    protected boolean isWholeReflectionApiAvailable() {
        return false;
    }

    @Override
    protected boolean isAllowedReflectionApi(@NotNull CallableDescriptor descriptor2, @NotNull ClassDescriptor containingClass, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context, "context");
        return super.isAllowedReflectionApi(descriptor2, containingClass, context) || CollectionsKt.contains((Iterable)StandardClassIds.Annotations.INSTANCE.getAssociatedObjectAnnotations(), DescriptorUtilsKt.getClassId((ClassifierDescriptor)containingClass)) || Intrinsics.areEqual(descriptor2.getName(), StandardNames.FqNames.findAssociatedObject.shortName());
    }

    @Override
    protected void report(@NotNull PsiElement element, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(context, "context");
        context.getTrace().report(Errors.UNSUPPORTED.on(element, "This reflection API is not supported yet in JavaScript"));
    }
}

