/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.js.JsHelpersKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;

public final class JsQualifierChecker
implements AdditionalAnnotationChecker {
    @NotNull
    public static final JsQualifierChecker INSTANCE = new JsQualifierChecker();

    private JsQualifierChecker() {
    }

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace, @Nullable KtAnnotated annotated, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(entries, "entries");
        Intrinsics.checkNotNullParameter(actualTargets, "actualTargets");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        for (KtAnnotationEntry ktAnnotationEntry : entries) {
            String argument;
            AnnotationDescriptor annotation;
            if ((AnnotationDescriptor)bindingContext2.get(BindingContext.ANNOTATION, ktAnnotationEntry) == null || !Intrinsics.areEqual(annotation.getFqName(), JsStandardClassIds.Annotations.JsQualifier.asSingleFqName())) continue;
            ConstantValue constantValue = (ConstantValue)CollectionsKt.singleOrNull((Iterable)annotation.getAllValueArguments().values());
            Object t2 = constantValue != null ? constantValue.getValue() : null;
            String string = t2 instanceof String ? (String)t2 : null;
            if (string == null || JsHelpersKt.validateQualifier(argument = string)) continue;
            KtValueArgumentList ktValueArgumentList = ktAnnotationEntry.getValueArgumentList();
            Intrinsics.checkNotNull(ktValueArgumentList);
            KtValueArgument argumentPsi = ktValueArgumentList.getArguments().get(0);
            trace.report(ErrorsJs.WRONG_JS_QUALIFIER.on((KtValueArgument)((PsiElement)argumentPsi)));
        }
    }
}

