/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

public final class JsModuleChecker
implements DeclarationChecker {
    @NotNull
    public static final JsModuleChecker INSTANCE = new JsModuleChecker();

    private JsModuleChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        BindingTrace trace = context.getTrace();
        this.checkSuperClass(declaration, descriptor2, trace);
        if (AnnotationsUtils.getModuleName(descriptor2) == null && !AnnotationsUtils.isNonModule(descriptor2)) {
            return;
        }
        if (descriptor2 instanceof PropertyDescriptor && ((PropertyDescriptor)descriptor2).isVar()) {
            trace.report(ErrorsJs.JS_MODULE_PROHIBITED_ON_VAR.on((KtElement)((PsiElement)declaration)));
        }
        if (!AnnotationsUtils.isNativeObject(descriptor2)) {
            trace.report(ErrorsJs.JS_MODULE_PROHIBITED_ON_NON_NATIVE.on((KtElement)((PsiElement)declaration)));
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            boolean isFileModuleOrNonModule;
            boolean bl = isFileModuleOrNonModule = AnnotationsUtils.getFileModuleName(trace.getBindingContext(), descriptor2) != null || AnnotationsUtils.isFromNonModuleFile(trace.getBindingContext(), descriptor2);
            if (isFileModuleOrNonModule) {
                trace.report(ErrorsJs.NESTED_JS_MODULE_PROHIBITED.on((KtElement)((PsiElement)declaration)));
            }
        }
    }

    private final void checkSuperClass(KtDeclaration declaration, DeclarationDescriptor descriptor2, BindingTrace trace) {
        Object v2;
        ClassDescriptor superClass;
        block3: {
            if (!(descriptor2 instanceof ClassDescriptor)) {
                return;
            }
            ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor2);
            if (classDescriptor == null) {
                return;
            }
            superClass = classDescriptor;
            Intrinsics.checkNotNull(declaration, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            Iterable $this$firstOrNull$iv = ((KtClassOrObject)declaration).getSuperTypeListEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtSuperTypeListEntry entry = (KtSuperTypeListEntry)element$iv;
                boolean bl = false;
                Object object = (KotlinType)trace.get(BindingContext.TYPE, entry.getTypeReference());
                if (!Intrinsics.areEqual(object != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null, superClass)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        KtSuperTypeListEntry psi = v2;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        KtSuperTypeListEntry ktSuperTypeListEntry = psi;
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, trace, descriptor2, superClass, ktSuperTypeListEntry != null ? (KtElementImplStub)ktSuperTypeListEntry : (KtElementImplStub)((Object)declaration));
    }
}

