/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

public final class JsModuleCallChecker
implements CallChecker {
    @NotNull
    public static final JsModuleCallChecker INSTANCE = new JsModuleCallChecker();

    private JsModuleCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        this.checkReifieidTypeParameters(resolvedCall2, reportOn, context);
        DeclarationDescriptor declarationDescriptor = this.extractModuleCallee(resolvedCall2);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor callee = declarationDescriptor;
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        DeclarationDescriptor containingDescriptor = context.getScope().getOwnerDescriptor();
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext2, context.getTrace(), containingDescriptor, callee, reportOn);
    }

    private final DeclarationDescriptor extractModuleCallee(ResolvedCall<?> call2) {
        Object obj = call2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
        Object callee = obj;
        if (DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)callee)) {
            return (DeclarationDescriptor)callee;
        }
        ReceiverValue receiverValue = call2.getDispatchReceiver();
        if (receiverValue == null) {
            return (DeclarationDescriptor)callee;
        }
        ReceiverValue receiver = receiverValue;
        if (receiver instanceof ClassValueReceiver) {
            return ((ClassValueReceiver)receiver).getClassQualifier().getDescriptor();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReifieidTypeParameters(ResolvedCall<?> call2, PsiElement reportOn, CallCheckerContext context) {
        void $this$mapTo$iv$iv;
        Map map2;
        Map map3;
        void $this$filterTo$iv$iv;
        IndexedValue it;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        DeclarationDescriptor containingDescriptor = context.getScope().getOwnerDescriptor();
        List<TypeParameterDescriptor> list = call2.getCandidateDescriptor().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t2 : $this$mapTo$iv$iv2) {
            TypeParameterDescriptor object = (TypeParameterDescriptor)t2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOriginal());
        }
        Iterable $this$filter$iv = CollectionsKt.withIndex((List)destination$iv$iv);
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t3 : $this$filterTo$iv$iv) {
            it = (IndexedValue)t3;
            boolean bl22 = false;
            TypeParameterDescriptor param = (TypeParameterDescriptor)it.component2();
            if (!param.isReified()) continue;
            destination$iv$iv.add(t3);
        }
        List typeParams = (List)destination$iv$iv;
        KtTypeArgumentList ktTypeArgumentList = call2.getCall().getTypeArgumentList();
        if (ktTypeArgumentList != null) {
            void $this$associateTo$iv$iv;
            KtTypeArgumentList args = ktTypeArgumentList;
            boolean bl = false;
            Iterable $this$associate$iv = typeParams;
            boolean bl2 = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable bl22 = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map4 = destination$iv$iv2;
                Object object = (IndexedValue)element$iv$iv;
                boolean bl3 = false;
                int index2 = ((IndexedValue)object).component1();
                TypeParameterDescriptor param = (TypeParameterDescriptor)((IndexedValue)object).component2();
                TypeParameterDescriptor typeParameterDescriptor = param.getOriginal();
                List<KtTypeProjection> list2 = args.getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "getArguments(...)");
                KtTypeProjection ktTypeProjection = CollectionsKt.getOrNull(list2, index2);
                object = TuplesKt.to(typeParameterDescriptor, ktTypeProjection != null ? ktTypeProjection.getTypeReference() : null);
                map4.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
            }
            map3 = destination$iv$iv2;
        } else {
            map3 = map2 = null;
        }
        if (map3 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map typeArguments = map2;
        Iterable $this$map$iv2 = typeParams;
        boolean $i$f$map2 = false;
        Iterable bl = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean bl3 = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object item$iv$iv = object.next();
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl4 = false;
            TypeParameterDescriptor param = (TypeParameterDescriptor)indexedValue.component2();
            collection.add(param.getOriginal());
        }
        for (TypeParameterDescriptor typeParam : (List)destination$iv$iv3) {
            ClassDescriptor typeArgumentClass;
            KotlinType typeArgument;
            PsiElement argPsi;
            KtTypeReference ktTypeReference = (KtTypeReference)typeArguments.get(typeParam);
            PsiElement psiElement = argPsi = ktTypeReference != null ? (PsiElement)ktTypeReference : reportOn;
            if (call2.getTypeArguments().get(typeParam) == null || ((object = typeArgument.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor ? (ClassDescriptor)object : null) == null) continue;
            typeArgumentClass = typeArgumentClass;
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, context.getTrace(), containingDescriptor, typeArgumentClass, argPsi);
        }
    }
}

