/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public final class JsInheritanceChecker
implements DeclarationChecker {
    @NotNull
    public static final JsInheritanceChecker INSTANCE = new JsInheritanceChecker();

    private JsInheritanceChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        FunctionDescriptor fakeOverriddenMethod;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (descriptor2 instanceof FunctionDescriptor && !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2) && this.isOverridingExternalWithOptionalParams((FunctionDescriptor)descriptor2)) {
            context.getTrace().report(ErrorsJs.OVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS.on((KtElement)((PsiElement)declaration)));
        } else if (descriptor2 instanceof ClassDescriptor && !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2) && (fakeOverriddenMethod = this.findFakeMethodOverridingExternalWithOptionalParams((ClassDescriptor)descriptor2)) != null) {
            context.getTrace().report(ErrorsJs.OVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS_WITH_FAKE.on((KtElement)((PsiElement)declaration), fakeOverriddenMethod));
        }
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowImplementingFunctionInterface) && descriptor2 instanceof ClassDescriptor) {
            boolean bl;
            block8: {
                SimpleType simpleType2 = ((ClassDescriptor)descriptor2).getDefaultType();
                Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
                Iterable $this$any$iv = TypeUtilsKt.immediateSupertypes(simpleType2);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (!(FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype(it) && !FunctionTypesKt.isSuspendFunctionTypeOrSubtype(it))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                context.getTrace().report(ErrorsJs.IMPLEMENTING_FUNCTION_INTERFACE.on((KtClassOrObject)((PsiElement)((KtClassOrObject)declaration))));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isOverridingExternalWithOptionalParams(FunctionDescriptor function2) {
        void $this$filterTo$iv$iv;
        if (!function2.getKind().isReal() && function2.getModality() == Modality.ABSTRACT) {
            return false;
        }
        Collection<? extends FunctionDescriptor> collection = function2.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!DescriptorUtilsKt.isEffectivelyExternal(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (FunctionDescriptor overriddenFunction : (List)destination$iv$iv) {
            boolean bl;
            block6: {
                List<ValueParameterDescriptor> list = overriddenFunction.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull(it);
                        if (!ArgumentsUtilsKt.hasDefaultValue(it)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final FunctionDescriptor findFakeMethodOverridingExternalWithOptionalParams(ClassDescriptor cls) {
        Object v0;
        block3: {
            void $this$filterTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(cls.getUnsubstitutedMemberScope(), DescriptorKindFilter.CALLABLES, null, 2, null);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FunctionDescriptor it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof FunctionDescriptor ? (FunctionDescriptor)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getContainingDeclaration(), cls) && !it.getKind().isReal() && it.getOverriddenDescriptors().size() > 1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List members2 = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = members2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FunctionDescriptor it = (FunctionDescriptor)element$iv;
                boolean bl = false;
                if (!INSTANCE.isOverridingExternalWithOptionalParams(it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }
}

