/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.IdentifierChecker;

public final class JsIdentifierChecker
implements IdentifierChecker {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    @Override
    public void checkIdentifier(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull DiagnosticSink diagnosticHolder) {
        boolean hasIllegalChars;
        block6: {
            boolean bl;
            Intrinsics.checkNotNullParameter(simpleNameExpression, "simpleNameExpression");
            Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
            if (this.languageVersionSettings.supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
                return;
            }
            String simpleName2 = simpleNameExpression.getReferencedName();
            char[] cArray = new char[]{'.'};
            Iterable $this$any$iv = StringsKt.split$default((CharSequence)simpleName2, cArray, false, 0, 6, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual(NameSuggestion.Companion.sanitizeName(it), it))) continue;
                    bl = true;
                    break block6;
                }
                bl = hasIllegalChars = false;
            }
        }
        if (hasIllegalChars) {
            PsiElement psiElement = simpleNameExpression.getIdentifier();
            if (psiElement == null) {
                return;
            }
            PsiElement identifier = psiElement;
            diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(identifier, "contains illegal characters"));
        }
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
    }
}

