/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.Iterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

public final class JsExternalInheritorOnlyChecker
implements DeclarationChecker {
    @NotNull
    public static final JsExternalInheritorOnlyChecker INSTANCE = new JsExternalInheritorOnlyChecker();

    private JsExternalInheritorOnlyChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (descriptor2 instanceof ClassDescriptor && !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2)) {
            Sequence<ClassifierDescriptor> $this$forEach$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)descriptor2);
            boolean $i$f$forEach = false;
            Iterator<ClassifierDescriptor> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                ClassifierDescriptor element$iv;
                ClassifierDescriptor parent2 = element$iv = iterator2.next();
                boolean bl = false;
                if (!(parent2 instanceof ClassDescriptor) || !AnnotationsUtils.isJsExternalInheritorsOnly((ClassDescriptor)parent2)) continue;
                context.getTrace().report(ErrorsJs.JS_EXTERNAL_INHERITORS_ONLY.on(declaration, parent2, descriptor2));
            }
        }
    }
}

