/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

public final class JsExternalFileChecker
implements DeclarationChecker {
    @NotNull
    public static final JsExternalFileChecker INSTANCE;
    @NotNull
    private static final List<FqName> annotationFqNames;

    private JsExternalFileChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block3: {
            Object v1;
            block2: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                Intrinsics.checkNotNullParameter(context, "context");
                if (AnnotationsUtils.isNativeObject(descriptor2) || !DescriptorUtils.isTopLevelDeclaration(descriptor2)) break block3;
                List<AnnotationDescriptor> list = AnnotationsUtils.getContainingFileAnnotations(context.getTrace().getBindingContext(), descriptor2);
                Intrinsics.checkNotNullExpressionValue(list, "getContainingFileAnnotations(...)");
                Sequence sequence2 = CollectionsKt.asSequence((Iterable)list);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                    boolean bl = false;
                    if (!CollectionsKt.contains((Iterable)annotationFqNames, it.getFqName())) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            AnnotationDescriptor annotationDescriptor = v1;
            if (annotationDescriptor != null) {
                AnnotationDescriptor it = annotationDescriptor;
                boolean bl = false;
                context.getTrace().report(ErrorsJs.NON_EXTERNAL_DECLARATION_IN_INAPPROPRIATE_FILE.on((KtElement)((PsiElement)declaration), it.getType()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new JsExternalFileChecker();
        Iterable $this$map$iv = JsStandardClassIds.Annotations.annotationsRequiringExternal;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassId classId = (ClassId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asSingleFqName());
        }
        annotationFqNames = (List)var3_3;
    }
}

