/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public final class JsExternalArgumentCallChecker
implements CallChecker {
    @NotNull
    public static final JsExternalArgumentCallChecker INSTANCE = new JsExternalArgumentCallChecker();

    private JsExternalArgumentCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        for (ValueArgument valueArgument : resolvedCall2.getCall().getValueArguments()) {
            ClassDescriptor declaration;
            KotlinType argumentType;
            KtExpression argExpression;
            ValueParameterDescriptor parameter;
            if (CallUtilKt.getParameterForArgument(resolvedCall2, valueArgument) == null || !AnnotationsUtils.isJsExternalArgument(parameter) || valueArgument.getArgumentExpression() == null || context.getTrace().getBindingContext().getType(argExpression) == null) continue;
            ClassifierDescriptor classifierDescriptor = TypeUtilsKt.makeNotNullable(argumentType).getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null || DescriptorUtilsKt.isEffectivelyExternal(declaration = classDescriptor)) continue;
            context.getTrace().report(ErrorsJs.JS_EXTERNAL_ARGUMENT.on(argExpression, argumentType));
        }
    }
}

