/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

public final class JsDynamicDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final JsDynamicDeclarationChecker INSTANCE = new JsDynamicDeclarationChecker();

    private JsDynamicDeclarationChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block4: {
            BindingTrace trace;
            block3: {
                KtExpression delegateExpression;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter(declaration, "declaration");
                        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                        Intrinsics.checkNotNullParameter(context, "context");
                        trace = context.getTrace();
                        if (!(declaration instanceof KtProperty) || !(descriptor2 instanceof VariableDescriptorWithAccessors)) break block3;
                        KtExpression ktExpression = ((KtProperty)declaration).getDelegateExpression();
                        if (ktExpression == null) break block4;
                        delegateExpression = ktExpression;
                        boolean bl = false;
                        ResolvedCall provideDelegateCall = (ResolvedCall)trace.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, descriptor2);
                        if (provideDelegateCall == null) break block5;
                        KotlinType kotlinType = ((FunctionDescriptor)provideDelegateCall.getResultingDescriptor()).getReturnType();
                        if (kotlinType != null ? DynamicTypesKt.isDynamic(kotlinType) : false) break block6;
                    }
                    KotlinType kotlinType = trace.getType(delegateExpression);
                    boolean bl = kotlinType != null ? DynamicTypesKt.isDynamic(kotlinType) : false;
                    if (!bl) break block4;
                }
                trace.report(ErrorsJs.PROPERTY_DELEGATION_BY_DYNAMIC.on(delegateExpression));
                break block4;
            }
            if (declaration instanceof KtClassOrObject) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = ((KtClassOrObject)declaration).getSuperTypeListEntries();
                boolean $i$f$filterIsInstance = false;
                Iterable bl = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KtDelegatedSuperTypeEntry)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (KtDelegatedSuperTypeEntry delegateDecl : (List)destination$iv$iv) {
                    KtExpression delegateExpr;
                    if (delegateDecl.getDelegateExpression() == null) continue;
                    KotlinType kotlinType = trace.getType(delegateExpr);
                    boolean bl2 = kotlinType != null ? DynamicTypesKt.isDynamic(kotlinType) : false;
                    if (!bl2) continue;
                    trace.report(ErrorsJs.DELEGATION_BY_DYNAMIC.on(delegateExpr));
                }
            }
        }
    }
}

