/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.naming.JsNameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

public final class JsBuiltinNameClashChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsNameSuggestion nameSuggestion;
    @NotNull
    public static final Set<String> PROHIBITED_STATIC_NAMES;
    @NotNull
    public static final Set<String> PROHIBITED_MEMBER_NAMES;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (AnnotationsUtils.isNativeObject(descriptor2)) {
            return;
        }
        if (!(descriptor2.getContainingDeclaration() instanceof ClassDescriptor)) {
            return;
        }
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        SuggestedName suggestedName = this.nameSuggestion.suggest(descriptor2, bindingContext);
        Intrinsics.checkNotNull(suggestedName);
        SuggestedName suggestedName2 = suggestedName;
        if (!suggestedName2.getStable()) {
            return;
        }
        String simpleName2 = CollectionsKt.single(suggestedName2.getNames());
        if (descriptor2 instanceof ClassDescriptor) {
            if (PROHIBITED_STATIC_NAMES.contains(simpleName2)) {
                context.getTrace().report(ErrorsJs.JS_BUILTIN_NAME_CLASH.on((KtElement)((PsiElement)declaration), "Function." + simpleName2));
            }
        } else if (descriptor2 instanceof CallableMemberDescriptor && PROHIBITED_MEMBER_NAMES.contains(simpleName2)) {
            context.getTrace().report(ErrorsJs.JS_BUILTIN_NAME_CLASH.on((KtElement)((PsiElement)declaration), "Object.prototype." + simpleName2));
        }
    }

    static {
        String[] stringArray = new String[]{"prototype", "length", "$metadata$"};
        PROHIBITED_STATIC_NAMES = SetsKt.setOf(stringArray);
        PROHIBITED_MEMBER_NAMES = SetsKt.setOf("constructor");
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

