/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorEquivalenceForOverrides;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;

public abstract class AbstractNameClashChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NameSuggestion nameSuggestion;
    @NotNull
    private final KotlinTypeRefiner kotlinTypeRefiner;
    @NotNull
    private final Map<DeclarationDescriptor, Map<String, DeclarationDescriptor>> scopes;
    @NotNull
    private final Map<DeclarationDescriptor, Pair<DeclarationDescriptor, DeclarationDescriptor>> clashedFakeOverrides;
    @NotNull
    private final Set<Pair<DeclarationDescriptor, String>> clashedDescriptors;
    @NotNull
    private static final Set<DiagnosticFactory1<PsiElement, ? extends Object>> COMMON_DIAGNOSTICS;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!DescriptorUtilsKt.isExtensionProperty(descriptor2)) {
            DiagnosticSink diagnosticSink = context.getTrace();
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            this.checkDescriptor(descriptor2, declaration, diagnosticSink, bindingContext);
        }
    }

    private final void checkDescriptor(DeclarationDescriptor descriptor2, KtDeclaration declaration, DiagnosticSink diagnosticHolder, BindingContext bindingContext) {
        if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
            return;
        }
        for (SuggestedName suggested : this.suggestAllPossibleNames(this.nameSuggestion, descriptor2, bindingContext)) {
            String name;
            Map<String, DeclarationDescriptor> scope2;
            DeclarationDescriptor existing;
            if (!suggested.getStable() || !(suggested.getScope() instanceof ClassOrPackageFragmentDescriptor) || !this.presentsInGeneratedCode(suggested.getDescriptor()) || (existing = (scope2 = this.getScope(suggested.getScope(), bindingContext)).get(name = CollectionsKt.last(suggested.getNames()))) == null || Intrinsics.areEqual(existing, descriptor2) || this.isActual(existing) != this.isActual(descriptor2) || this.isExpect(existing) != this.isExpect(descriptor2) || this.isCommonDiagnosticReported(bindingContext, declaration)) continue;
            diagnosticHolder.report(ErrorsJs.JS_NAME_CLASH.on((KtElement)((PsiElement)declaration), name, existing));
            PsiElement existingDeclaration = SourceLocationUtilsKt.findPsi(existing);
            if (!this.clashedDescriptors.add(TuplesKt.to(existing, name)) || !(existingDeclaration instanceof KtDeclaration) || Intrinsics.areEqual(existingDeclaration, declaration)) continue;
            diagnosticHolder.report(ErrorsJs.JS_NAME_CLASH.on((KtElement)existingDeclaration, name, descriptor2));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            Sequence<CallableMemberDescriptor> fakeOverrides = SequencesKt.filter(SequencesKt.mapNotNull(CollectionsKt.asSequence(ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope(), null, null, 3, null)), AbstractNameClashChecker::checkDescriptor$lambda$0), AbstractNameClashChecker::checkDescriptor$lambda$1);
            Iterator<CallableMemberDescriptor> iterator2 = fakeOverrides.iterator();
            while (iterator2.hasNext()) {
                CallableMemberDescriptor overrideDescriptor;
                SuggestedName overrideFqn;
                CallableMemberDescriptor override = iterator2.next();
                Intrinsics.checkNotNull(this.nameSuggestion.suggest(override, bindingContext));
                Map<String, DeclarationDescriptor> scope3 = this.getScope(overrideFqn.getScope(), bindingContext);
                String name = CollectionsKt.last(overrideFqn.getNames());
                DeclarationDescriptor declarationDescriptor = scope3.get(name);
                CallableMemberDescriptor existing = declarationDescriptor instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)declarationDescriptor : null;
                DeclarationDescriptor declarationDescriptor2 = overrideFqn.getDescriptor();
                CallableMemberDescriptor callableMemberDescriptor = overrideDescriptor = declarationDescriptor2 instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)declarationDescriptor2 : null;
                if (existing != null && overrideDescriptor != null && !this.areDescriptorsEquivalent(existing, overrideDescriptor) && !this.isFakeOverridingNative(existing)) {
                    diagnosticHolder.report(ErrorsJs.JS_FAKE_NAME_CLASH.on((KtElement)((PsiElement)declaration), name, override, existing));
                    break;
                }
                Pair<DeclarationDescriptor, DeclarationDescriptor> clashedOverrides = this.clashedFakeOverrides.get(override);
                if (clashedOverrides == null) continue;
                DeclarationDescriptor firstExample = clashedOverrides.component1();
                DeclarationDescriptor secondExample = clashedOverrides.component2();
                diagnosticHolder.report(ErrorsJs.JS_FAKE_NAME_CLASH.on((KtElement)((PsiElement)declaration), name, firstExample, secondExample));
                break;
            }
        }
    }

    private final boolean areDescriptorsEquivalent(CallableMemberDescriptor existing, CallableMemberDescriptor overrideDescriptor) {
        return this.kotlinTypeRefiner == KotlinTypeRefiner.Default.INSTANCE ? Intrinsics.areEqual(existing, overrideDescriptor) : DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$default(DescriptorEquivalenceForOverrides.INSTANCE, existing, overrideDescriptor, true, false, false, this.kotlinTypeRefiner, 24, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<SuggestedName> suggestAllPossibleNames(NameSuggestion $this$suggestAllPossibleNames, DeclarationDescriptor descriptor2, BindingContext bindingContext) {
        Collection collection;
        if (descriptor2 instanceof CallableMemberDescriptor) {
            List list;
            SuggestedName primary = $this$suggestAllPossibleNames.suggest(descriptor2, bindingContext);
            if (primary != null) {
                void $this$flatMapTo$iv$iv;
                Collection<? extends CallableMemberDescriptor> collection2 = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection2, "getOverriddenDescriptors(...)");
                Iterable $this$flatMap$iv = collection2;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it);
                    Iterable $this$map$iv = this.suggestAllPossibleNames($this$suggestAllPossibleNames, it, bindingContext);
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void overridden;
                        SuggestedName suggestedName = (SuggestedName)item$iv$iv;
                        Collection collection3 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection3.add(new SuggestedName(overridden.getNames(), overridden.getStable(), primary.getDescriptor(), primary.getScope()));
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                List overriddenNames = (List)destination$iv$iv;
                Iterable $this$distinctBy$iv = CollectionsKt.plus((Collection)overriddenNames, primary);
                boolean $i$f$distinctBy = false;
                HashSet<List<String>> set$iv = new HashSet<List<String>>();
                ArrayList list$iv = new ArrayList();
                for (Object e$iv : $this$distinctBy$iv) {
                    SuggestedName it = (SuggestedName)e$iv;
                    boolean bl = false;
                    List<String> key$iv = it.getNames();
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                list = list$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            collection = list;
        } else {
            collection = CollectionsKt.listOfNotNull($this$suggestAllPossibleNames.suggest(descriptor2, bindingContext));
        }
        return collection;
    }

    private final boolean isCommonDiagnosticReported(BindingContext $this$isCommonDiagnosticReported, KtDeclaration declaration) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$isCommonDiagnosticReported.getDiagnostics().forElement(declaration);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!CollectionsKt.contains((Iterable)COMMON_DIAGNOSTICS, it.getFactory())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isActual(DeclarationDescriptor $this$isActual) {
        return $this$isActual instanceof MemberDescriptor && ((MemberDescriptor)$this$isActual).isActual() || $this$isActual instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)$this$isActual).getCorrespondingProperty().isActual();
    }

    private final boolean isExpect(DeclarationDescriptor $this$isExpect) {
        return $this$isExpect instanceof MemberDescriptor && ((MemberDescriptor)$this$isExpect).isExpect() || $this$isExpect instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)$this$isExpect).getCorrespondingProperty().isExpect();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFakeOverridingNative(CallableMemberDescriptor descriptor2) {
        boolean bl;
        if (descriptor2.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) return false;
        Collection<? extends CallableMemberDescriptor> collection = descriptor2.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
        Iterable $this$all$iv = collection;
        boolean $i$f$all = false;
        if (((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it);
            if (this.presentsInGeneratedCode(it)) return false;
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, DeclarationDescriptor> getScope(DeclarationDescriptor descriptor2, BindingContext bindingContext) {
        Map map2;
        Map<DeclarationDescriptor, Map<String, DeclarationDescriptor>> $this$getOrPut$iv = this.scopes;
        boolean $i$f$getOrPut = false;
        Map value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            Map scope2 = new LinkedHashMap();
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                void $this$forEach$iv;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                this.collect(((PackageFragmentDescriptor)descriptor2).getMemberScope(), (Map<String, DeclarationDescriptor>)scope2, bindingContext);
                ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(descriptor2);
                Intrinsics.checkNotNullExpressionValue(moduleDescriptor, "getContainingModule(...)");
                ModuleDescriptor module2 = moduleDescriptor;
                Iterable iterable = module2.getSubPackagesOf(((PackageFragmentDescriptor)descriptor2).getFqName(), AbstractNameClashChecker::getScope$lambda$10$lambda$7);
                boolean $i$f$flatMap = false;
                Iterator iterator2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    FqName it = (FqName)element$iv$iv;
                    boolean bl2 = false;
                    Iterable list$iv$iv = module2.getPackage(it).getFragments();
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PackageFragmentDescriptor it = (PackageFragmentDescriptor)element$iv;
                    boolean bl3 = false;
                    this.collect(it, (Map<String, DeclarationDescriptor>)scope2, bindingContext);
                }
            } else if (declarationDescriptor instanceof ClassDescriptor) {
                this.collect(((ClassDescriptor)descriptor2).getDefaultType().getMemberScope(), (Map<String, DeclarationDescriptor>)scope2, bindingContext);
            }
            Map answer$iv = scope2;
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            map2 = answer$iv;
        } else {
            map2 = value$iv;
        }
        return map2;
    }

    private final void collect(MemberScope scope2, Map<String, DeclarationDescriptor> target, BindingContext bindingContext) {
        for (DeclarationDescriptor descriptor2 : ResolutionScope.DefaultImpls.getContributedDescriptors$default(scope2, null, null, 3, null)) {
            this.collect(descriptor2, target, bindingContext);
        }
    }

    private final void collect(DeclarationDescriptor descriptor2, Map<String, DeclarationDescriptor> target, BindingContext bindingContext) {
        if (descriptor2 instanceof PropertyDescriptor && (DescriptorUtilsKt.isExtension(descriptor2) || AnnotationsUtils.hasJsNameInAccessors((PropertyDescriptor)descriptor2))) {
            List<PropertyAccessorDescriptor> list = ((PropertyDescriptor)descriptor2).getAccessors();
            Intrinsics.checkNotNullExpressionValue(list, "getAccessors(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PropertyAccessorDescriptor it = (PropertyAccessorDescriptor)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                this.collect(it, target, bindingContext);
            }
            return;
        }
        for (SuggestedName fqn : this.suggestAllPossibleNames(this.nameSuggestion, descriptor2, bindingContext)) {
            CallableMemberDescriptor it;
            if (!fqn.getStable() || !this.presentsInGeneratedCode(fqn.getDescriptor())) continue;
            target.put(CollectionsKt.last(fqn.getNames()), fqn.getDescriptor());
            DeclarationDescriptor declarationDescriptor = fqn.getDescriptor();
            if ((declarationDescriptor instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)declarationDescriptor : null) == null) continue;
            it = it;
            boolean bl = false;
            this.checkOverrideClashes(it, target, bindingContext);
        }
    }

    private final void checkOverrideClashes(CallableMemberDescriptor descriptor2, Map<String, DeclarationDescriptor> target, BindingContext bindingContext) {
        for (CallableMemberDescriptor overriddenDescriptor : DescriptorUtils.getAllOverriddenDeclarations(descriptor2)) {
            SuggestedName overriddenFqn;
            Intrinsics.checkNotNull(overriddenDescriptor);
            Intrinsics.checkNotNull(this.nameSuggestion.suggest(overriddenDescriptor, bindingContext));
            if (!overriddenFqn.getStable()) continue;
            DeclarationDescriptor existing = target.get(CollectionsKt.last(overriddenFqn.getNames()));
            if (existing != null) {
                if (Intrinsics.areEqual(existing, descriptor2) || descriptor2.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
                this.clashedFakeOverrides.put(descriptor2, new Pair<DeclarationDescriptor, CallableMemberDescriptor>(existing, overriddenDescriptor));
                continue;
            }
            target.put(CollectionsKt.last(overriddenFqn.getNames()), descriptor2);
        }
    }

    private final boolean presentsInGeneratedCode(DeclarationDescriptor descriptor2) {
        return !AnnotationsUtils.isNativeObject(descriptor2) && !AnnotationsUtils.isLibraryObject(descriptor2);
    }

    private static final CallableMemberDescriptor checkDescriptor$lambda$0(DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)it : null;
    }

    private static final boolean checkDescriptor$lambda$1(CallableMemberDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
    }

    private static final boolean getScope$lambda$10$lambda$7(Name it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    static {
        DiagnosticFactory1[] diagnosticFactory1Array = new DiagnosticFactory1[]{Errors.REDECLARATION, Errors.CONFLICTING_OVERLOADS, Errors.PACKAGE_OR_CLASSIFIER_REDECLARATION};
        COMMON_DIAGNOSTICS = SetsKt.setOf(diagnosticFactory1Array);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

