/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.ReasonableInlineRule;

public final class ExtensionFunctionToExternalIsInlinable
implements ReasonableInlineRule {
    @NotNull
    public static final ExtensionFunctionToExternalIsInlinable INSTANCE = new ExtensionFunctionToExternalIsInlinable();

    private ExtensionFunctionToExternalIsInlinable() {
    }

    @Override
    public boolean isInlineReasonable(@NotNull CallableMemberDescriptor descriptor2, @NotNull KtCallableDeclaration declaration, @NotNull BindingContext context) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return false;
        }
        ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
        ClassifierDescriptor classifierDescriptor = receiverParameter.getValue().getType().getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor receiverClass = classDescriptor;
        return DescriptorUtilsKt.isEffectivelyExternal(receiverClass);
    }
}

