/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.AbstractNativeAnnotationsChecker;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public abstract class AbstractNativeIndexerChecker
extends AbstractNativeAnnotationsChecker {
    @NotNull
    private final String indexerKind;
    private final int requiredParametersCount;

    public AbstractNativeIndexerChecker(@NotNull PredefinedAnnotation requiredAnnotation, @NotNull String indexerKind, int requiredParametersCount) {
        Intrinsics.checkNotNullParameter((Object)requiredAnnotation, "requiredAnnotation");
        Intrinsics.checkNotNullParameter(indexerKind, "indexerKind");
        super(requiredAnnotation);
        this.indexerKind = indexerKind;
        this.requiredParametersCount = requiredParametersCount;
    }

    @Override
    public void additionalCheck(@NotNull KtNamedFunction declaration, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        List<ValueParameterDescriptor> list = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        List<ValueParameterDescriptor> parameters2 = list;
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(descriptor2);
        if (!((Collection)parameters2).isEmpty()) {
            KotlinType kotlinType = CollectionsKt.first(parameters2).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            KotlinType firstParamType = kotlinType;
            if (!KotlinBuiltIns.isString(firstParamType)) {
                SimpleType simpleType2 = builtIns.getNumber().getDefaultType();
                Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
                if (!TypeUtilsKt.isSubtypeOf(firstParamType, simpleType2)) {
                    List<KtParameter> list2 = declaration.getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
                    diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_KEY_SHOULD_BE_STRING_OR_NUMBER.on((KtElement)((PsiElement)CollectionsKt.first(list2)), this.indexerKind));
                }
            }
        }
        if (parameters2.size() != this.requiredParametersCount) {
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_WRONG_PARAMETER_COUNT.on((KtElement)((PsiElement)declaration), this.requiredParametersCount, this.indexerKind));
        }
        for (KtParameter parameter : declaration.getValueParameters()) {
            if (!parameter.hasDefaultValue()) continue;
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_CAN_NOT_HAVE_DEFAULT_ARGUMENTS.on((KtElement)((PsiElement)parameter), this.indexerKind));
        }
    }
}

