/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.patterns;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public final class PatternBuilder {
    @NotNull
    private static final NamePredicate KOTLIN_NAME_PREDICATE = new NamePredicate("kotlin");
    @NotNull
    private static final Name KOTLIN_NAME = Name.identifier("Kotlin".toLowerCase());

    private PatternBuilder() {
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String stringWithPattern) {
        if (stringWithPattern == null) {
            PatternBuilder.$$$reportNull$$$0(4);
        }
        return PatternBuilder.pattern(PatternBuilder.parseFqNamesFromString(stringWithPattern), PatternBuilder.parseArgumentsFromString(stringWithPattern));
    }

    @NotNull
    private static List<NamePredicate> parseFqNamesFromString(@NotNull String stringWithPattern) {
        if (stringWithPattern == null) {
            PatternBuilder.$$$reportNull$$$0(5);
        }
        stringWithPattern = PatternBuilder.getNamePatternFromString(stringWithPattern);
        String[] subPatterns = stringWithPattern.split("\\.");
        ArrayList<NamePredicate> checkers = Lists.newArrayList();
        for (String subPattern : subPatterns) {
            String[] validNames = subPattern.split("\\|");
            checkers.add(new NamePredicate(validNames));
        }
        ArrayList<NamePredicate> arrayList = checkers;
        if (arrayList == null) {
            PatternBuilder.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    private static List<NamePredicate> parseArgumentsFromString(@NotNull String stringWithPattern) {
        String[] subPatterns;
        if (stringWithPattern == null) {
            PatternBuilder.$$$reportNull$$$0(7);
        }
        if ((stringWithPattern = PatternBuilder.getArgumentsPatternFromString(stringWithPattern)) == null) {
            return null;
        }
        ArrayList<NamePredicate> checkers = Lists.newArrayList();
        if (stringWithPattern.isEmpty()) {
            return checkers;
        }
        for (String subPattern : subPatterns = stringWithPattern.split("\\,")) {
            String[] validNames = subPattern.split("\\|");
            checkers.add(new NamePredicate(validNames));
        }
        return checkers;
    }

    @NotNull
    private static String getNamePatternFromString(@NotNull String stringWithPattern) {
        int left;
        if (stringWithPattern == null) {
            PatternBuilder.$$$reportNull$$$0(8);
        }
        if ((left = stringWithPattern.indexOf("(")) < 0) {
            String string = stringWithPattern;
            if (string == null) {
                PatternBuilder.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = stringWithPattern.substring(0, left);
        if (string == null) {
            PatternBuilder.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private static String getArgumentsPatternFromString(@NotNull String stringWithPattern) {
        int left;
        if (stringWithPattern == null) {
            PatternBuilder.$$$reportNull$$$0(11);
        }
        if ((left = stringWithPattern.indexOf("(")) < 0) {
            return null;
        }
        int right = stringWithPattern.indexOf(")");
        assert (right == stringWithPattern.length() - 1) : "expected ')' at the end: " + stringWithPattern;
        return stringWithPattern.substring(left + 1, right);
    }

    @NotNull
    private static DescriptorPredicate pattern(@NotNull List<NamePredicate> checkers, @Nullable List<NamePredicate> arguments2) {
        if (checkers == null) {
            PatternBuilder.$$$reportNull$$$0(13);
        }
        assert (!checkers.isEmpty());
        final ArrayList<NamePredicate> checkersWithPrefixChecker = Lists.newArrayList();
        if (!checkers.get(0).test(KOTLIN_NAME)) {
            checkersWithPrefixChecker.add(KOTLIN_NAME_PREDICATE);
        }
        checkersWithPrefixChecker.addAll(checkers);
        assert (checkersWithPrefixChecker.size() > 1);
        final ArrayList<NamePredicate> argumentCheckers = arguments2 != null ? Lists.newArrayList(arguments2) : null;
        return new DescriptorPredicate(){

            @Override
            public boolean test(FunctionDescriptor descriptor2) {
                try {
                    return this.doApply(descriptor2);
                }
                catch (IllegalArgumentException e2) {
                    return false;
                }
            }

            private boolean doApply(@NotNull FunctionDescriptor descriptor2) {
                List<Name> nameParts;
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((nameParts = DescriptorUtils.getFqName(descriptor2).pathSegments()).size() != checkersWithPrefixChecker.size()) {
                    return false;
                }
                return this.allNamePartsValid(nameParts) && this.checkAllArgumentsValidIfNeeded(descriptor2);
            }

            private boolean checkAllArgumentsValidIfNeeded(@NotNull FunctionDescriptor descriptor2) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (argumentCheckers != null) {
                    List<ValueParameterDescriptor> valueParameterDescriptors = descriptor2.getValueParameters();
                    if (valueParameterDescriptors.size() != argumentCheckers.size()) {
                        return false;
                    }
                    for (int i2 = 0; i2 < valueParameterDescriptors.size(); ++i2) {
                        ValueParameterDescriptor valueParameterDescriptor = valueParameterDescriptors.get(i2);
                        Name name = DescriptorUtilsKt.getNameIfStandardType(valueParameterDescriptor.getType());
                        NamePredicate namePredicate = (NamePredicate)argumentCheckers.get(i2);
                        if (namePredicate.test(name)) continue;
                        return false;
                    }
                }
                return true;
            }

            private boolean allNamePartsValid(@NotNull List<Name> nameParts) {
                if (nameParts == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (int i2 = 0; i2 < nameParts.size(); ++i2) {
                    Name namePart = nameParts.get(i2);
                    NamePredicate correspondingPredicate = (NamePredicate)checkersWithPrefixChecker.get(i2);
                    if (correspondingPredicate.test(namePart)) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nameParts";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/js/patterns/PatternBuilder$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doApply";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkAllArgumentsValidIfNeeded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "allNamePartsValid";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringWithPattern";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/patterns/PatternBuilder";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkers";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/patterns/PatternBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFqNamesFromString";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamePatternFromString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pattern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseFqNamesFromString";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseArgumentsFromString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamePatternFromString";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsPatternFromString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

